/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.schema.Schemas;
import org.apache.pulsar.schema.compatibility.SchemaCompatibilityCheckTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ClientGetSchemaTest
extends ProducerConsumerBase {
    private static final String topicBytes = "my-property/my-ns/topic-bytes";
    private static final String topicString = "my-property/my-ns/topic-string";
    private static final String topicJson = "my-property/my-ns/topic-json";
    private static final String topicAvro = "my-property/my-ns/topic-avro";
    private static final String topicJsonNotNull = "my-property/my-ns/topic-json-not-null";
    private static final String topicAvroNotNull = "my-property/my-ns/topic-avro-not-null";
    List<Producer<?>> producers = new ArrayList();

    @Override
    @BeforeClass(alwaysRun=true)
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
        this.producers.add(this.pulsarClient.newProducer(Schema.BYTES).topic(topicBytes).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.STRING).topic(topicString).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.AVRO(MyClass.class)).topic(topicAvro).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.JSON(MyClass.class)).topic(topicJson).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withPojo(MyClass.class).build())).topic(topicAvro).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.JSON((SchemaDefinition)SchemaDefinition.builder().withPojo(MyClass.class).build())).topic(topicJson).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withPojo(MyClass.class).withAlwaysAllowNull(false).build())).topic(topicAvroNotNull).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.JSON((SchemaDefinition)SchemaDefinition.builder().withPojo(MyClass.class).withAlwaysAllowNull(false).build())).topic(topicJsonNotNull).create());
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        this.producers.forEach(t -> {
            try {
                t.close();
            }
            catch (PulsarClientException pulsarClientException) {
                // empty catch block
            }
        });
        super.internalCleanup();
    }

    @DataProvider(name="serviceUrl")
    public Object[] serviceUrls() {
        return new Object[]{ClientGetSchemaTest.stringSupplier(() -> this.getPulsar().getBrokerServiceUrl()), ClientGetSchemaTest.stringSupplier(() -> this.getPulsar().getWebServiceAddress())};
    }

    private static Supplier<String> stringSupplier(Supplier<String> supplier) {
        return supplier;
    }

    @Test(dataProvider="serviceUrl")
    public void testGetSchema(Supplier<String> serviceUrl) throws Exception {
        PulsarClientImpl client = (PulsarClientImpl)PulsarClient.builder().serviceUrl(serviceUrl.get()).build();
        try {
            Assert.assertEquals(client.getSchema("non-existing-topic").join(), Optional.empty());
            Assert.assertEquals(client.getSchema(topicBytes).join(), Optional.empty());
            Assert.assertEquals(client.getSchema(topicString).join(), Optional.of(Schema.STRING.getSchemaInfo()));
            Assert.assertEquals(client.getSchema(topicJson).join(), Optional.of(Schema.JSON(MyClass.class).getSchemaInfo()));
            Assert.assertEquals(client.getSchema(topicAvro).join(), Optional.of(Schema.AVRO(MyClass.class).getSchemaInfo()));
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test
    public void testSchemaFailure() throws Exception {
        String tenant = "public";
        String namespace = "test-namespace-" + SchemaCompatibilityCheckTest.randomName(16);
        String topicOne = "test-broken-schema-storage";
        String fqtnOne = TopicName.get((String)TopicDomain.persistent.value(), (String)"public", (String)namespace, (String)"test-broken-schema-storage").toString();
        this.admin.namespaces().createNamespace("public/" + namespace, (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Producer producer = this.pulsarClient.newProducer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withAlwaysAllowNull(false).withSupportSchemaVersioning(true).withPojo(Schemas.PersonTwo.class).build())).topic(fqtnOne).create();
        producer.close();
        String key = TopicName.get((String)fqtnOne).getSchemaName();
        BookkeeperSchemaStorage schemaStrogate = (BookkeeperSchemaStorage)this.pulsar.getSchemaStorage();
        long schemaLedgerId = (Long)schemaStrogate.getSchemaLedgerList(key).get(0);
        schemaStrogate.getBookKeeper().deleteLedger(schemaLedgerId);
        this.admin.topics().unload(fqtnOne);
        producer = this.pulsarClient.newProducer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withAlwaysAllowNull(false).withSupportSchemaVersioning(true).withPojo(Schemas.PersonTwo.class).build())).topic(fqtnOne).create();
        Assert.assertNotEquals((Object)schemaLedgerId, schemaStrogate.getSchemaLedgerList(key).get(0));
        Schemas.PersonTwo personTwo = new Schemas.PersonTwo();
        personTwo.setId(1);
        personTwo.setName("Tom");
        Consumer consumer = this.pulsarClient.newConsumer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withAlwaysAllowNull(false).withSupportSchemaVersioning(true).withPojo(Schemas.PersonTwo.class).build())).subscriptionName("test").topic(new String[]{fqtnOne}).subscribe();
        producer.send((Object)personTwo);
        Schemas.PersonTwo personConsume = (Schemas.PersonTwo)consumer.receive().getValue();
        Assert.assertEquals((String)"Tom", (String)personConsume.getName());
        Assert.assertEquals((int)1, (int)personConsume.getId());
        producer.close();
        consumer.close();
    }

    private static class MyClass {
        public String name;
        public int age;

        private MyClass() {
        }
    }
}

