/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.utils;

import com.google.common.collect.Queues;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.util.Queue;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.CommandCloseConsumer;
import org.apache.pulsar.common.api.proto.CommandCloseProducer;
import org.apache.pulsar.common.api.proto.CommandConnect;
import org.apache.pulsar.common.api.proto.CommandConnected;
import org.apache.pulsar.common.api.proto.CommandError;
import org.apache.pulsar.common.api.proto.CommandFlow;
import org.apache.pulsar.common.api.proto.CommandLookupTopicResponse;
import org.apache.pulsar.common.api.proto.CommandMessage;
import org.apache.pulsar.common.api.proto.CommandProducer;
import org.apache.pulsar.common.api.proto.CommandProducerSuccess;
import org.apache.pulsar.common.api.proto.CommandSend;
import org.apache.pulsar.common.api.proto.CommandSendError;
import org.apache.pulsar.common.api.proto.CommandSendReceipt;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.CommandSuccess;
import org.apache.pulsar.common.api.proto.CommandUnsubscribe;
import org.apache.pulsar.common.protocol.PulsarDecoder;

public class ClientChannelHelper {
    private final EmbeddedChannel channel;
    private final Queue<Object> queue = Queues.newArrayDeque();
    private final PulsarDecoder decoder = new PulsarDecoder(){

        protected void messageReceived() {
        }

        protected void handleConnect(CommandConnect connect) {
            ClientChannelHelper.this.queue.offer(new CommandConnect().copyFrom(connect));
        }

        protected void handleConnected(CommandConnected connected) {
            ClientChannelHelper.this.queue.offer(new CommandConnected().copyFrom(connected));
        }

        protected void handleSubscribe(CommandSubscribe subscribe) {
            ClientChannelHelper.this.queue.offer(new CommandSubscribe().copyFrom(subscribe));
        }

        protected void handleProducer(CommandProducer producer) {
            ClientChannelHelper.this.queue.offer(new CommandProducer().copyFrom(producer));
        }

        protected void handleSend(CommandSend send, ByteBuf headersAndPayload) {
            ClientChannelHelper.this.queue.offer(new CommandSend().copyFrom(send));
        }

        protected void handleSendReceipt(CommandSendReceipt sendReceipt) {
            ClientChannelHelper.this.queue.offer(new CommandSendReceipt().copyFrom(sendReceipt));
        }

        protected void handleSendError(CommandSendError sendError) {
            ClientChannelHelper.this.queue.offer(new CommandSendError().copyFrom(sendError));
        }

        protected void handleMessage(CommandMessage cmdMessage, ByteBuf headersAndPayload) {
            ClientChannelHelper.this.queue.offer(new CommandMessage().copyFrom(cmdMessage));
        }

        protected void handleAck(CommandAck ack) {
            ClientChannelHelper.this.queue.offer(new CommandAck().copyFrom(ack));
        }

        protected void handleFlow(CommandFlow flow) {
            ClientChannelHelper.this.queue.offer(new CommandFlow().copyFrom(flow));
        }

        protected void handleUnsubscribe(CommandUnsubscribe unsubscribe) {
            ClientChannelHelper.this.queue.offer(new CommandUnsubscribe().copyFrom(unsubscribe));
        }

        protected void handleSuccess(CommandSuccess success) {
            ClientChannelHelper.this.queue.offer(new CommandSuccess().copyFrom(success));
        }

        protected void handleError(CommandError error) {
            ClientChannelHelper.this.queue.offer(new CommandError().copyFrom(error));
        }

        protected void handleCloseProducer(CommandCloseProducer closeProducer) {
            ClientChannelHelper.this.queue.offer(new CommandCloseProducer().copyFrom(closeProducer));
        }

        protected void handleCloseConsumer(CommandCloseConsumer closeConsumer) {
            ClientChannelHelper.this.queue.offer(new CommandCloseConsumer().copyFrom(closeConsumer));
        }

        protected void handleProducerSuccess(CommandProducerSuccess success) {
            ClientChannelHelper.this.queue.offer(new CommandProducerSuccess().copyFrom(success));
        }

        protected void handleLookupResponse(CommandLookupTopicResponse connection) {
            ClientChannelHelper.this.queue.offer(new CommandLookupTopicResponse().copyFrom(connection));
        }
    };

    public ClientChannelHelper() {
        int MaxMessageSize = 0x500000;
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(MaxMessageSize, 0, 4, 0, 4), this.decoder});
    }

    public Object getCommand(Object obj) {
        this.channel.writeInbound(new Object[]{obj});
        return this.queue.poll();
    }
}

