/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.systopic.NamespaceEventsSystemTopicFactory;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.common.naming.NamespaceName;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class PartitionedSystemTopicTest
extends BrokerTestBase {
    static final int PARTITIONS = 5;

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.resetConfig();
        this.conf.setAllowAutoTopicCreation(false);
        this.conf.setAllowAutoTopicCreationType("partitioned");
        this.conf.setDefaultNumPartitions(5);
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(true);
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testAutoCreatedPartitionedSystemTopic() throws Exception {
        String ns = "prop/ns-test";
        this.admin.namespaces().createNamespace("prop/ns-test", 2);
        NamespaceEventsSystemTopicFactory systemTopicFactory = new NamespaceEventsSystemTopicFactory(this.pulsarClient);
        TopicPoliciesSystemTopicClient systemTopicClientForNamespace = systemTopicFactory.createTopicPoliciesSystemTopicClient(NamespaceName.get((String)"prop/ns-test"));
        SystemTopicClient.Reader reader = systemTopicClientForNamespace.newReader();
        int partitions = this.admin.topics().getPartitionedTopicMetadata((String)String.format((String)"persistent://%s/%s", (Object[])new Object[]{"prop/ns-test", "__change_events"})).partitions;
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicList("prop/ns-test").size(), (int)1);
        Assert.assertEquals((int)partitions, (int)5);
        Assert.assertEquals((int)this.admin.topics().getList("prop/ns-test").size(), (int)5);
    }
}

