/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.zookeeper;

import com.google.common.collect.Sets;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ZooKeeperSessionExpireRecoveryTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        super.internalSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testSessionExpired() throws Exception {
        this.admin.clusters().createCluster("my-cluster", ClusterData.builder().serviceUrl("test-url").build());
        Assert.assertTrue((boolean)Sets.newHashSet((Iterable)this.admin.clusters().getClusters()).contains("my-cluster"));
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.CREATE && path.equals("/admin/clusters/my-cluster-2"));
        Assert.assertTrue((boolean)Sets.newHashSet((Iterable)this.admin.clusters().getClusters()).contains("my-cluster"));
        try {
            this.admin.clusters().createCluster("my-cluster-2", ClusterData.builder().serviceUrl("test-url").build());
            Assert.fail((String)"Should have failed, because global zk is down");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
        this.admin.clusters().createCluster("cluster-2", ClusterData.builder().serviceUrl("test-url").build());
    }
}

