/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataCommand;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authorization.AuthorizationProvider;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.RestException;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class AuthorizationProducerConsumerTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationProducerConsumerTest.class);
    private static final String clientRole = "plugbleRole";
    private static final Set<String> clientAuthProviderSupportedRoles = Sets.newHashSet((Object[])new String[]{"plugbleRole"});

    @Override
    protected void setup() throws Exception {
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthorizationEnabled(true);
        HashSet<String> superUserRoles = new HashSet<String>();
        superUserRoles.add("superUser");
        this.conf.setSuperUserRoles(superUserRoles);
        HashSet<String> providers = new HashSet<String>();
        providers.add(TestAuthenticationProvider.class.getName());
        this.conf.setAuthenticationProviders(providers);
        this.conf.setClusterName("test");
        super.init();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProducerAndConsumerAuthorization() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(TestAuthorizationProvider.class.getName());
        this.setup();
        ClientAuthentication adminAuthentication = new ClientAuthentication("superUser");
        PulsarAdmin admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)adminAuthentication).build());
        try {
            String lookupUrl = this.pulsar.getBrokerServiceUrl();
            ClientAuthentication authentication = new ClientAuthentication(clientRole);
            ClientAuthentication authenticationInvalidRole = new ClientAuthentication("test-role");
            PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(lookupUrl).authentication((Authentication)authentication).operationTimeout(1000, TimeUnit.MILLISECONDS).build();
            try {
                PulsarClient pulsarClientInvalidRole = PulsarClient.builder().serviceUrl(lookupUrl).operationTimeout(1000, TimeUnit.MILLISECONDS).authentication((Authentication)authenticationInvalidRole).build();
                try {
                    admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
                    admin.tenants().createTenant("my-property", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
                    admin.namespaces().createNamespace("my-property/my-ns", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
                    Consumer consumer = pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic"}).subscriptionName("my-subscriber-name").subscribe();
                    Producer producer = pulsarClient.newProducer().topic("persistent://my-property/my-ns/my-topic").create();
                    consumer.close();
                    producer.close();
                    try {
                        consumer = pulsarClientInvalidRole.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic"}).subscriptionName("my-subscriber-name").subscribe();
                        Assert.fail((String)"should have failed with authorization error");
                    }
                    catch (PulsarClientException.AuthorizationException authorizationException) {
                        // empty catch block
                    }
                    try {
                        producer = pulsarClientInvalidRole.newProducer().topic("persistent://my-property/my-ns/my-topic").create();
                        Assert.fail((String)"should have failed with authorization error");
                    }
                    catch (PulsarClientException.AuthorizationException authorizationException) {
                        // empty catch block
                    }
                    log.info("-- Exiting {} test --", (Object)this.methodName);
                }
                finally {
                    if (Collections.singletonList(pulsarClientInvalidRole).get(0) != null) {
                        pulsarClientInvalidRole.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(pulsarClient).get(0) != null) {
                    pulsarClient.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubscriberPermission() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(PulsarAuthorizationProvider.class.getName());
        this.setup();
        String tenantRole = "tenant-role";
        String subscriptionRole = "sub1-role";
        String subscriptionName = "sub1";
        String subscriptionName2 = "sub2";
        String namespace = "my-property/my-ns-sub-auth";
        String topicName = "persistent://my-property/my-ns-sub-auth/my-topic";
        ClientAuthentication adminAuthentication = new ClientAuthentication("superUser");
        clientAuthProviderSupportedRoles.add("sub1-role");
        PulsarAdmin superAdmin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)adminAuthentication).build());
        try {
            ClientAuthentication tenantAdminAuthentication = new ClientAuthentication("tenant-role");
            PulsarAdmin tenantAdmin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)tenantAdminAuthentication).build());
            try {
                ClientAuthentication subAdminAuthentication = new ClientAuthentication("sub1-role");
                PulsarAdmin sub1Admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)subAdminAuthentication).build());
                try {
                    ClientAuthentication authentication = new ClientAuthentication("sub1-role");
                    superAdmin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
                    superAdmin.tenants().createTenant("my-property", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"tenant-role"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
                    superAdmin.namespaces().createNamespace("my-property/my-ns-sub-auth", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
                    try {
                        sub1Admin.topics().getInternalStats("persistent://my-property/my-ns-sub-auth/my-topic", true);
                        Assert.fail((String)"should have failed with authorization exception");
                    }
                    catch (Exception e) {
                        Assert.assertTrue((boolean)e.getMessage().startsWith("Unauthorized to validateTopicOperation for operation [GET_STATS]"));
                    }
                    tenantAdmin.topics().grantPermission("persistent://my-property/my-ns-sub-auth/my-topic", "sub1-role", Collections.singleton(AuthAction.consume));
                    this.replacePulsarClient(PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)authentication));
                    Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns-sub-auth/my-topic"}).subscriptionName("sub1").subscribe();
                    Consumer consumer2 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns-sub-auth/my-topic"}).subscriptionName("sub2").subscribe();
                    consumer.close();
                    consumer2.close();
                    List subscriptions = sub1Admin.topics().getSubscriptions("persistent://my-property/my-ns-sub-auth/my-topic");
                    Assert.assertEquals((int)subscriptions.size(), (int)2);
                    PersistentTopicInternalStats internalStats = superAdmin.topics().getInternalStats("persistent://my-property/my-ns-sub-auth/my-topic", true);
                    Assert.assertNotNull((Object)internalStats);
                    tenantAdmin.topics().skipAllMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1");
                    tenantAdmin.topics().skipMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 1L);
                    try {
                        tenantAdmin.topics().expireMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
                    }
                    catch (Exception e) {
                        Assert.assertTrue((boolean)e.getMessage().startsWith("Expire message by timestamp not issued on topic"));
                    }
                    tenantAdmin.topics().expireMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", (MessageId)new MessageIdImpl(-1L, -1L, -1), true);
                    tenantAdmin.topics().peekMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 1);
                    tenantAdmin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
                    tenantAdmin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", MessageId.earliest);
                    try {
                        sub1Admin.namespaces().unsubscribeNamespace("my-property/my-ns-sub-auth", "sub2");
                        Assert.fail((String)"should have failed with authorization exception");
                    }
                    catch (Exception e) {
                        Assert.assertTrue((boolean)e.getMessage().startsWith("Unauthorized to validateNamespaceOperation for operation [UNSUBSCRIBE]"));
                    }
                    tenantAdmin.namespaces().grantPermissionOnNamespace("my-property/my-ns-sub-auth", "sub1-role", Collections.singleton(AuthAction.consume));
                    sub1Admin.namespaces().unsubscribeNamespaceBundle("my-property/my-ns-sub-auth", "0x00000000_0xffffffff", "sub2");
                    subscriptions = sub1Admin.topics().getSubscriptions("persistent://my-property/my-ns-sub-auth/my-topic");
                    Assert.assertEquals((int)subscriptions.size(), (int)1);
                    sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
                    String otherPrincipal = "Principal-1-to-access-sub";
                    tenantAdmin.namespaces().grantPermissionOnSubscription("my-property/my-ns-sub-auth", "sub1", Collections.singleton(otherPrincipal));
                    try {
                        sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
                        Assert.fail((String)"should have fail with authorization exception");
                    }
                    catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                        // empty catch block
                    }
                    try {
                        sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", MessageId.earliest);
                        Assert.fail((String)"should have fail with authorization exception");
                    }
                    catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                        // empty catch block
                    }
                    superAdmin.namespaces().grantPermissionOnSubscription("my-property/my-ns-sub-auth", "sub1", (Set)Sets.newHashSet((Object[])new String[]{otherPrincipal, "sub1-role"}));
                    sub1Admin.topics().skipAllMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1");
                    sub1Admin.topics().skipMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 1L);
                    try {
                        tenantAdmin.topics().expireMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
                    }
                    catch (Exception e) {
                        Assert.assertTrue((boolean)e.getMessage().startsWith("Expire message by timestamp not issued on topic"));
                    }
                    sub1Admin.topics().peekMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 1);
                    sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
                    sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", MessageId.earliest);
                    superAdmin.namespaces().revokePermissionOnSubscription("my-property/my-ns-sub-auth", "sub1", "sub1-role");
                    try {
                        sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
                        Assert.fail((String)"should have fail with authorization exception");
                    }
                    catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                        // empty catch block
                    }
                    log.info("-- Exiting {} test --", (Object)this.methodName);
                }
                finally {
                    if (Collections.singletonList(sub1Admin).get(0) != null) {
                        sub1Admin.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(tenantAdmin).get(0) != null) {
                    tenantAdmin.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(superAdmin).get(0) != null) {
                superAdmin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearBacklogPermission() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(PulsarAuthorizationProvider.class.getName());
        this.setup();
        String tenantRole = "tenant-role";
        String subscriptionRole = "sub-role";
        String subscriptionName = "sub1";
        String namespace = "my-property/my-ns-sub-auth";
        String topicName = "persistent://my-property/my-ns-sub-auth/my-topic";
        ClientAuthentication adminAuthentication = new ClientAuthentication("superUser");
        clientAuthProviderSupportedRoles.add("sub-role");
        PulsarAdmin superAdmin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)adminAuthentication).build());
        try {
            ClientAuthentication tenantAdminAuthentication = new ClientAuthentication("tenant-role");
            PulsarAdmin tenantAdmin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)tenantAdminAuthentication).build());
            try {
                ClientAuthentication subAdminAuthentication = new ClientAuthentication("sub-role");
                PulsarAdmin sub1Admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)subAdminAuthentication).build());
                try {
                    superAdmin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
                    superAdmin.tenants().createTenant("my-property", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"tenant-role"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
                    superAdmin.namespaces().createNamespace("my-property/my-ns-sub-auth", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
                    superAdmin.topics().createPartitionedTopic("persistent://my-property/my-ns-sub-auth/my-topic", 1);
                    Assert.assertEquals((Collection)tenantAdmin.topics().getPartitionedTopicList("my-property/my-ns-sub-auth"), (Collection)Lists.newArrayList((Object[])new String[]{"persistent://my-property/my-ns-sub-auth/my-topic"}));
                    superAdmin.topics().grantPermission("persistent://my-property/my-ns-sub-auth/my-topic", "sub-role", (Set)Sets.newHashSet((Object[])new AuthAction[]{AuthAction.produce, AuthAction.consume}));
                    this.replacePulsarClient(PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)subAdminAuthentication));
                    Producer batchProducer = this.pulsarClient.newProducer().topic("persistent://my-property/my-ns-sub-auth/my-topic").enableBatching(false).create();
                    try {
                        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns-sub-auth/my-topic"}).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscriptionName("sub1").subscribe();
                        try {
                            CompletableFuture completableFuture = new CompletableFuture();
                            for (int i = 0; i < 10; ++i) {
                                completableFuture = batchProducer.sendAsync((Object)"a".getBytes());
                            }
                            completableFuture.get();
                            Assert.assertEquals((long)((SubscriptionStats)sub1Admin.topics().getStats("persistent://my-property/my-ns-sub-auth/my-topic-partition-0").getSubscriptions().get("sub1")).getMsgBacklog(), (long)10L);
                            try {
                                sub1Admin.topics().getPartitionedTopicList("my-property/my-ns-sub-auth");
                                Assert.fail((String)"should have failed with authorization exception");
                            }
                            catch (Exception e) {
                                Assert.assertTrue((boolean)e.getMessage().startsWith("Unauthorized to validateNamespaceOperation for operation [GET_TOPICS]"));
                            }
                            try {
                                sub1Admin.namespaces().clearNamespaceBundleBacklog("my-property/my-ns-sub-auth", "0x00000000_0xffffffff");
                                Assert.fail((String)"should have failed with authorization exception");
                            }
                            catch (Exception e) {
                                Assert.assertTrue((boolean)e.getMessage().startsWith("Unauthorized to validateNamespaceOperation for operation [CLEAR_BACKLOG]"));
                            }
                            superAdmin.namespaces().grantPermissionOnNamespace("my-property/my-ns-sub-auth", "sub-role", (Set)Sets.newHashSet((Object[])new AuthAction[]{AuthAction.consume}));
                            Assert.assertEquals((Collection)sub1Admin.topics().getPartitionedTopicList("my-property/my-ns-sub-auth"), (Collection)Lists.newArrayList((Object[])new String[]{"persistent://my-property/my-ns-sub-auth/my-topic"}));
                            sub1Admin.namespaces().clearNamespaceBundleBacklog("my-property/my-ns-sub-auth", "0x00000000_0xffffffff");
                            Assert.assertEquals((long)((SubscriptionStats)sub1Admin.topics().getStats("persistent://my-property/my-ns-sub-auth/my-topic-partition-0").getSubscriptions().get("sub1")).getMsgBacklog(), (long)0L);
                            log.info("-- Exiting {} test --", (Object)this.methodName);
                        }
                        finally {
                            if (Collections.singletonList(consumer).get(0) != null) {
                                consumer.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(batchProducer).get(0) != null) {
                            batchProducer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(sub1Admin).get(0) != null) {
                        sub1Admin.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(tenantAdmin).get(0) != null) {
                    tenantAdmin.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(superAdmin).get(0) != null) {
                superAdmin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubscriptionPrefixAuthorization() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(TestAuthorizationProviderWithSubscriptionPrefix.class.getName());
        this.setup();
        ClientAuthentication adminAuthentication = new ClientAuthentication("superUser");
        PulsarAdmin admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)adminAuthentication).build());
        try {
            ClientAuthentication authentication = new ClientAuthentication(clientRole);
            this.replacePulsarClient(PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)authentication));
            admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
            admin.tenants().createTenant("prop-prefix", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
            admin.namespaces().createNamespace("prop-prefix/ns", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
            Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-prefix/ns/t1"}).subscriptionName("plugbleRole-sub1").subscribe();
            consumer.close();
            try {
                consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-prefix/ns/t1"}).subscriptionName("sub1").subscribe();
                Assert.fail((String)"should have failed with authorization error");
            }
            catch (PulsarClientException.AuthorizationException authorizationException) {
                // empty catch block
            }
            log.info("-- Exiting {} test --", (Object)this.methodName);
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    @Test
    public void testGrantPermission() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(TestAuthorizationProviderWithGrantPermission.class.getName());
        this.setup();
        AuthorizationService authorizationService = new AuthorizationService(this.conf, null);
        TopicName topicName = TopicName.get((String)"persistent://prop/cluster/ns/t1");
        String role = "test-role";
        Assert.assertFalse((boolean)authorizationService.canProduce(topicName, role, null));
        Assert.assertFalse((boolean)authorizationService.canConsume(topicName, role, null, "sub1"));
        authorizationService.grantPermissionAsync(topicName, null, role, "auth-json").get();
        Assert.assertTrue((boolean)authorizationService.canProduce(topicName, role, null));
        Assert.assertTrue((boolean)authorizationService.canConsume(topicName, role, null, "sub1"));
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    @Test
    public void testAuthData() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(TestAuthorizationProviderWithGrantPermission.class.getName());
        this.setup();
        AuthorizationService authorizationService = new AuthorizationService(this.conf, null);
        TopicName topicName = TopicName.get((String)"persistent://prop/cluster/ns/t1");
        String role = "test-role";
        authorizationService.grantPermissionAsync(topicName, null, role, "auth-json").get();
        Assert.assertEquals((String)TestAuthorizationProviderWithGrantPermission.authDataJson, (String)"auth-json");
        Assert.assertTrue((boolean)authorizationService.canProduce(topicName, role, (AuthenticationDataSource)new AuthenticationDataCommand("prod-auth")));
        Assert.assertEquals((String)TestAuthorizationProviderWithGrantPermission.authenticationData.getCommandData(), (String)"prod-auth");
        Assert.assertTrue((boolean)authorizationService.canConsume(topicName, role, (AuthenticationDataSource)new AuthenticationDataCommand("cons-auth"), "sub1"));
        Assert.assertEquals((String)TestAuthorizationProviderWithGrantPermission.authenticationData.getCommandData(), (String)"cons-auth");
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    public static class TestAuthorizationProviderWithGrantPermission
    extends TestAuthorizationProvider {
        private Set<String> grantRoles = Sets.newHashSet();
        static AuthenticationDataSource authenticationData;
        static String authDataJson;

        @Override
        public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            TestAuthorizationProviderWithGrantPermission.authenticationData = authenticationData;
            return CompletableFuture.completedFuture(this.grantRoles.contains(role));
        }

        @Override
        public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
            TestAuthorizationProviderWithGrantPermission.authenticationData = authenticationData;
            return CompletableFuture.completedFuture(this.grantRoles.contains(role));
        }

        @Override
        public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            TestAuthorizationProviderWithGrantPermission.authenticationData = authenticationData;
            return CompletableFuture.completedFuture(this.grantRoles.contains(role));
        }

        @Override
        public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespace, Set<AuthAction> actions, String role, String authData) {
            authDataJson = authData;
            this.grantRoles.add(role);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> grantPermissionAsync(TopicName topicname, Set<AuthAction> actions, String role, String authData) {
            authDataJson = authData;
            this.grantRoles.add(role);
            return CompletableFuture.completedFuture(null);
        }
    }

    public static class TestAuthorizationProviderWithSubscriptionPrefix
    extends TestAuthorizationProvider {
        @Override
        public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topic, String role, TopicOperation operation, AuthenticationDataSource authData) {
            String subscription;
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            if (authData.hasSubscription() && StringUtils.isNotBlank((CharSequence)(subscription = authData.getSubscription())) && !subscription.startsWith(role)) {
                future.completeExceptionally(new PulsarServerException("The subscription name needs to be prefixed by the authentication role"));
            }
            future.complete(AuthorizationProducerConsumerTest.clientRole.equals(role));
            return future;
        }
    }

    public static class TestAuthorizationProvider2
    extends TestAuthorizationProvider {
        @Override
        public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            return CompletableFuture.completedFuture(true);
        }

        @Override
        public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
            return CompletableFuture.completedFuture(false);
        }

        @Override
        public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            return CompletableFuture.completedFuture(true);
        }
    }

    public static class TestAuthorizationProvider
    implements AuthorizationProvider {
        public ServiceConfiguration conf;

        public void close() throws IOException {
        }

        public CompletableFuture<Boolean> isSuperUser(String role, ServiceConfiguration serviceConfiguration) {
            Set superUserRoles = serviceConfiguration.getSuperUserRoles();
            return CompletableFuture.completedFuture(role != null && superUserRoles.contains(role));
        }

        public void initialize(ServiceConfiguration conf, ConfigurationCacheService configCache) throws IOException {
            this.conf = conf;
        }

        public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            return CompletableFuture.completedFuture(clientAuthProviderSupportedRoles.contains(role));
        }

        public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
            return CompletableFuture.completedFuture(clientAuthProviderSupportedRoles.contains(role));
        }

        public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            return CompletableFuture.completedFuture(clientAuthProviderSupportedRoles.contains(role));
        }

        public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
            return null;
        }

        public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
            return null;
        }

        public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
            return null;
        }

        public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespace, Set<AuthAction> actions, String role, String authenticationData) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> grantPermissionAsync(TopicName topicname, Set<AuthAction> actions, String role, String authenticationData) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, String authDataJson) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, String role, String authDataJson) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Boolean> isTenantAdmin(String tenant, String role, TenantInfo tenantInfo, AuthenticationDataSource authenticationData) {
            return CompletableFuture.completedFuture(true);
        }

        public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
            return CompletableFuture.completedFuture(true);
        }

        public Boolean allowTenantOperation(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
            return true;
        }

        public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
            return CompletableFuture.completedFuture(true);
        }

        public Boolean allowNamespaceOperation(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
            return null;
        }

        public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topic, String role, TopicOperation operation, AuthenticationDataSource authData) {
            CompletableFuture<Boolean> isAuthorizedFuture = role.equals(AuthorizationProducerConsumerTest.clientRole) ? CompletableFuture.completedFuture(true) : CompletableFuture.completedFuture(false);
            return isAuthorizedFuture;
        }

        public Boolean allowTopicOperation(TopicName topicName, String role, TopicOperation operation, AuthenticationDataSource authData) {
            try {
                return this.allowTopicOperationAsync(topicName, role, operation, authData).get();
            }
            catch (InterruptedException e) {
                throw new RestException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new RestException((Throwable)e);
            }
        }
    }

    public static class TestAuthenticationProvider
    implements AuthenticationProvider {
        public void close() throws IOException {
        }

        public void initialize(ServiceConfiguration config) throws IOException {
        }

        public String getAuthMethodName() {
            return "test";
        }

        public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
            return authData.getCommandData() != null ? authData.getCommandData() : authData.getHttpHeader("user");
        }
    }

    public static class ClientAuthentication
    implements Authentication {
        String user;

        public ClientAuthentication(String user) {
            this.user = user;
        }

        public void close() throws IOException {
        }

        public String getAuthMethodName() {
            return "test";
        }

        public AuthenticationDataProvider getAuthData() throws PulsarClientException {
            AuthenticationDataProvider provider = new AuthenticationDataProvider(){

                public boolean hasDataForHttp() {
                    return true;
                }

                public Set<Map.Entry<String, String>> getHttpHeaders() {
                    return Sets.newHashSet((Object[])new Map.Entry[]{Maps.immutableEntry((Object)"user", (Object)user)});
                }

                public boolean hasDataFromCommand() {
                    return true;
                }

                public String getCommandData() {
                    return user;
                }
            };
            return provider;
        }

        public void configure(Map<String, String> authParams) {
        }

        public void start() throws PulsarClientException {
        }
    }
}

