/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.reflect.Nullable;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"flaky"})
public class DeadLetterTopicTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(DeadLetterTopicTest.class);

    @Override
    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"quarantine"})
    public void testDeadLetterTopic() throws Exception {
        String topic = "persistent://my-property/my-ns/dead-letter-topic";
        int maxRedeliveryCount = 2;
        int sendMessages = 100;
        Consumer consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(2).build()).receiverQueueSize(100).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        PulsarClient newPulsarClient = this.newPulsarClient(this.lookupUrl.toString(), 0);
        try {
            Consumer deadLetterConsumer = newPulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-my-subscription-DLQ"}).subscriptionName("my-subscription").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
            Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://my-property/my-ns/dead-letter-topic").create();
            for (int i = 0; i < 100; ++i) {
                producer.send((Object)String.format("Hello Pulsar [%d]", i).getBytes());
            }
            producer.close();
            int totalReceived = 0;
            do {
                Message message = consumer.receive();
                log.info("consumer received message : {} {}", (Object)message.getMessageId(), (Object)new String(message.getData()));
            } while (++totalReceived < 300);
            int totalInDeadLetter = 0;
            do {
                Message message = deadLetterConsumer.receive();
                log.info("dead letter consumer received message : {} {}", (Object)message.getMessageId(), (Object)new String(message.getData()));
                deadLetterConsumer.acknowledge(message);
            } while (++totalInDeadLetter < 100);
            deadLetterConsumer.close();
            consumer.close();
            Consumer checkConsumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Shared).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
            Message checkMessage = checkConsumer.receive(3, TimeUnit.SECONDS);
            if (checkMessage != null) {
                log.info("check consumer received message : {} {}", (Object)checkMessage.getMessageId(), (Object)new String(checkMessage.getData()));
            }
            Assert.assertNull((Object)checkMessage);
            checkConsumer.close();
        }
        finally {
            if (Collections.singletonList(newPulsarClient).get(0) != null) {
                newPulsarClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=20000L)
    public void testDeadLetterTopicHasOriginalInfo() throws Exception {
        String topic = "persistent://my-property/my-ns/dead-letter-topic";
        boolean maxRedeliveryCount = true;
        int sendMessages = 10;
        Consumer consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(1).build()).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        PulsarClient newPulsarClient = this.newPulsarClient(this.lookupUrl.toString(), 0);
        try {
            Consumer deadLetterConsumer = newPulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-my-subscription-DLQ"}).subscriptionName("my-subscription").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
            Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://my-property/my-ns/dead-letter-topic").create();
            HashSet<String> messageIds = new HashSet<String>();
            for (int i = 0; i < 10; ++i) {
                MessageId messageId = producer.send((Object)String.format("Hello Pulsar [%d]", i).getBytes());
                messageIds.add(messageId.toString());
            }
            producer.close();
            int totalReceived = 0;
            do {
                consumer.receive();
            } while (++totalReceived < 20);
            int totalInDeadLetter = 0;
            do {
                Message message = deadLetterConsumer.receive();
                Assert.assertEquals((String)((String)message.getProperties().get("REAL_TOPIC")), (String)"persistent://my-property/my-ns/dead-letter-topic");
                Assert.assertTrue((boolean)messageIds.contains(message.getProperties().get("ORIGIN_MESSAGE_IDY_TIME")));
                deadLetterConsumer.acknowledge(message);
            } while (++totalInDeadLetter < 10);
            Assert.assertEquals((int)totalInDeadLetter, (int)10);
            deadLetterConsumer.close();
            consumer.close();
        }
        finally {
            if (Collections.singletonList(newPulsarClient).get(0) != null) {
                newPulsarClient.close();
            }
        }
    }

    @Test(timeOut=20000L)
    public void testAutoConsumeSchemaDeadLetter() throws Exception {
        String topic = "persistent://my-property/my-ns/dead-letter-topic";
        String subName = "my-subscription";
        boolean maxRedeliveryCount = true;
        int sendMessages = 10;
        this.admin.topics().createNonPartitionedTopic("persistent://my-property/my-ns/dead-letter-topic");
        PulsarClient newPulsarClient = this.newPulsarClient(this.lookupUrl.toString(), 0);
        Consumer deadLetterConsumer = newPulsarClient.newConsumer(Schema.AVRO(FooV2.class)).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-my-subscription-DLQ"}).subscriptionName("my-subscription").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        Producer producer = this.pulsarClient.newProducer(Schema.AUTO_PRODUCE_BYTES()).topic("persistent://my-property/my-ns/dead-letter-topic").create();
        HashSet<String> messageIds = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            Object foo;
            if (i % 2 == 0) {
                foo = new Foo();
                ((Foo)foo).field1 = i + "";
                ((Foo)foo).field2 = i + "";
                messageIds.add(producer.newMessage(Schema.AVRO(Foo.class)).value(foo).send().toString());
                continue;
            }
            foo = new FooV2();
            ((FooV2)foo).field1 = i + "";
            ((FooV2)foo).field2 = i + "";
            ((FooV2)foo).field3 = i + "";
            messageIds.add(producer.newMessage(Schema.AVRO(FooV2.class)).value(foo).send().toString());
        }
        Consumer consumer = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(1).build()).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        producer.close();
        int totalReceived = 0;
        do {
            consumer.receive();
        } while (++totalReceived < 20);
        int totalInDeadLetter = 0;
        for (int i = 0; i < 10; ++i) {
            Message message = deadLetterConsumer.receive();
            FooV2 fooV2 = (FooV2)message.getValue();
            Assert.assertNotNull((Object)fooV2.field1);
            Assert.assertEquals((String)fooV2.field2, (String)fooV2.field1);
            Assert.assertTrue((fooV2.field3 == null || fooV2.field1.equals(fooV2.field3) ? 1 : 0) != 0);
            Assert.assertEquals((String)((String)message.getProperties().get("REAL_TOPIC")), (String)"persistent://my-property/my-ns/dead-letter-topic");
            Assert.assertTrue((boolean)messageIds.contains(message.getProperties().get("ORIGIN_MESSAGE_IDY_TIME")));
            deadLetterConsumer.acknowledge(message);
            ++totalInDeadLetter;
        }
        Assert.assertEquals((int)totalInDeadLetter, (int)10);
        deadLetterConsumer.close();
        consumer.close();
        newPulsarClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testDuplicatedMessageSendToDeadLetterTopic() throws Exception {
        String topic = "persistent://my-property/my-ns/dead-letter-topic-DuplicatedMessage";
        boolean maxRedeliveryCount = true;
        int messageCount = 10;
        int consumerCount = 3;
        ArrayList consumers = new ArrayList();
        AtomicInteger totalReceived = new AtomicInteger(0);
        ExecutorService executor = Executors.newFixedThreadPool(3);
        try {
            Message message;
            for (int i = 0; i < 3; ++i) {
                executor.execute(() -> {
                    try {
                        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-DuplicatedMessage"}).subscriptionName("my-subscription-DuplicatedMessage").subscriptionType(SubscriptionType.Shared).ackTimeout(1001L, TimeUnit.MILLISECONDS).deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(1).deadLetterTopic("persistent://my-property/my-ns/dead-letter-topic-DuplicatedMessage-DLQ").build()).negativeAckRedeliveryDelay(1001L, TimeUnit.MILLISECONDS).receiverQueueSize(100).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).messageListener((MessageListener & Serializable)(consumer1, msg) -> totalReceived.getAndIncrement()).subscribe();
                        consumers.add(consumer);
                    }
                    catch (PulsarClientException e) {
                        Assert.fail();
                    }
                });
            }
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic("persistent://my-property/my-ns/dead-letter-topic-DuplicatedMessage").create();
            for (int i = 0; i < 10; ++i) {
                producer.send((Object)String.format("Message [%d]", i));
            }
            Consumer deadLetterConsumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-DuplicatedMessage-DLQ"}).subscriptionName("my-subscription-DuplicatedMessage-DLQ").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
            int totalInDeadLetter = 0;
            while ((message = deadLetterConsumer.receive(10, TimeUnit.SECONDS)) != null) {
                deadLetterConsumer.acknowledge(message);
                ++totalInDeadLetter;
            }
            Assert.assertEquals((int)totalReceived.get(), (int)20);
            Assert.assertEquals((int)totalInDeadLetter, (int)10);
            producer.close();
            deadLetterConsumer.close();
            for (Consumer consumer : consumers) {
                consumer.close();
            }
        }
        finally {
            if (Collections.singletonList(executor).get(0) != null) {
                executor.shutdownNow();
            }
        }
    }

    @Test(enabled=false)
    public void testDeadLetterTopicWithMultiTopic() throws Exception {
        String topic1 = "persistent://my-property/my-ns/dead-letter-topic-1";
        String topic2 = "persistent://my-property/my-ns/dead-letter-topic-2";
        int maxRedeliveryCount = 2;
        int sendMessages = 100;
        Consumer consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-1", "persistent://my-property/my-ns/dead-letter-topic-2"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(2).build()).receiverQueueSize(100).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        Consumer deadLetterConsumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-1-my-subscription-DLQ", "persistent://my-property/my-ns/dead-letter-topic-2-my-subscription-DLQ"}).subscriptionName("my-subscription").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        Producer producer1 = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://my-property/my-ns/dead-letter-topic-1").create();
        Producer producer2 = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://my-property/my-ns/dead-letter-topic-2").create();
        for (int i = 0; i < sendMessages; ++i) {
            producer1.send((Object)String.format("Hello Pulsar [%d]", i).getBytes());
            producer2.send((Object)String.format("Hello Pulsar [%d]", i).getBytes());
        }
        sendMessages *= 2;
        producer1.close();
        producer2.close();
        int totalReceived = 0;
        do {
            Message message = consumer.receive();
            log.info("consumer received message : {} {} - total = {}", new Object[]{message.getMessageId(), new String(message.getData()), ++totalReceived});
        } while (totalReceived < sendMessages * 3);
        int totalInDeadLetter = 0;
        do {
            Message message = deadLetterConsumer.receive();
            log.info("dead letter consumer received message : {} {}", (Object)message.getMessageId(), (Object)new String(message.getData()));
            deadLetterConsumer.acknowledge(message);
        } while (++totalInDeadLetter < sendMessages);
        deadLetterConsumer.close();
        consumer.close();
        Consumer checkConsumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-1", "persistent://my-property/my-ns/dead-letter-topic-2"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Shared).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        Message checkMessage = checkConsumer.receive(3, TimeUnit.SECONDS);
        if (checkMessage != null) {
            log.info("check consumer received message : {} {}", (Object)checkMessage.getMessageId(), (Object)new String(checkMessage.getData()));
        }
        Assert.assertNull((Object)checkMessage);
        checkConsumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"quarantine"})
    public void testDeadLetterTopicByCustomTopicName() throws Exception {
        String topic = "persistent://my-property/my-ns/dead-letter-topic";
        int maxRedeliveryCount = 2;
        int sendMessages = 100;
        Consumer consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).receiverQueueSize(100).deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(2).deadLetterTopic("persistent://my-property/my-ns/dead-letter-custom-topic-my-subscription-custom-DLQ").build()).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        PulsarClient newPulsarClient = this.newPulsarClient(this.lookupUrl.toString(), 0);
        try {
            Consumer deadLetterConsumer = newPulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-custom-topic-my-subscription-custom-DLQ"}).subscriptionName("my-subscription").subscribe();
            Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://my-property/my-ns/dead-letter-topic").create();
            for (int i = 0; i < 100; ++i) {
                producer.send((Object)String.format("Hello Pulsar [%d]", i).getBytes());
            }
            producer.close();
            int totalReceived = 0;
            do {
                Message message = consumer.receive();
                log.info("consumer received message : {} {}", (Object)message.getMessageId(), (Object)new String(message.getData()));
            } while (++totalReceived < 300);
            int totalInDeadLetter = 0;
            do {
                Message message = deadLetterConsumer.receive();
                log.info("dead letter consumer received message : {} {}", (Object)message.getMessageId(), (Object)new String(message.getData()));
                deadLetterConsumer.acknowledge(message);
            } while (++totalInDeadLetter < 100);
            deadLetterConsumer.close();
            consumer.close();
            PulsarClient newPulsarClient1 = this.newPulsarClient(this.lookupUrl.toString(), 0);
            try {
                Consumer checkConsumer = newPulsarClient1.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Shared).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
                Message checkMessage = checkConsumer.receive(3, TimeUnit.SECONDS);
                if (checkMessage != null) {
                    log.info("check consumer received message : {} {}", (Object)checkMessage.getMessageId(), (Object)new String(checkMessage.getData()));
                }
                Assert.assertNull((Object)checkMessage);
                checkConsumer.close();
            }
            finally {
                if (Collections.singletonList(newPulsarClient1).get(0) != null) {
                    newPulsarClient1.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(newPulsarClient).get(0) != null) {
                newPulsarClient.close();
            }
        }
    }

    @Test(timeOut=200000L)
    public void testDeadLetterWithoutConsumerReceiveImmediately() throws PulsarClientException, InterruptedException {
        String topic = "persistent://my-property/my-ns/dead-letter-topic-without-consumer-receive-immediately";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-without-consumer-receive-immediately"}).subscriptionType(SubscriptionType.Shared).subscriptionName("my-subscription").ackTimeout(1L, TimeUnit.SECONDS).deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(1).build()).subscribe();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://my-property/my-ns/dead-letter-topic-without-consumer-receive-immediately").create();
        producer.send((Object)"a message".getBytes());
        Thread.sleep(5000L);
        Message msg = consumer.receive(1, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)msg);
    }

    @Test
    public void testDeadLetterTopicUnderPartitionedTopicWithKeyShareType() throws Exception {
        Message message;
        String topic = "persistent://my-property/my-ns/dead-letter-topic-with-partitioned-topic";
        int maxRedeliveryCount = 2;
        boolean sendMessages = true;
        int partitionCount = 2;
        this.admin.topics().createPartitionedTopic("persistent://my-property/my-ns/dead-letter-topic-with-partitioned-topic", partitionCount);
        Consumer consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-with-partitioned-topic"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Key_Shared).keySharedPolicy((KeySharedPolicy)KeySharedPolicy.autoSplitHashRange()).ackTimeout(1L, TimeUnit.SECONDS).deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(2).build()).receiverQueueSize(100).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        Consumer deadLetterConsumer0 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-with-partitioned-topic-partition-0-my-subscription-DLQ"}).subscriptionName("my-subscription").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        Consumer deadLetterConsumer1 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-with-partitioned-topic-partition-1-my-subscription-DLQ"}).subscriptionName("my-subscription").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://my-property/my-ns/dead-letter-topic-with-partitioned-topic").create();
        for (int i = 0; i < 1; ++i) {
            producer.send((Object)String.format("Hello Pulsar [%d]", i).getBytes());
        }
        producer.close();
        int totalReceived = 0;
        do {
            Message message2 = consumer.receive();
            log.info("consumer received message : {} {}", (Object)message2.getMessageId(), (Object)new String(message2.getData()));
        } while (++totalReceived < 3);
        int totalInDeadLetter = 0;
        while ((message = deadLetterConsumer0.receive(3, TimeUnit.SECONDS)) != null) {
            log.info("dead letter consumer received message : {} {}", (Object)message.getMessageId(), (Object)new String(message.getData()));
            deadLetterConsumer0.acknowledge(message);
            if (++totalInDeadLetter < 1) continue;
        }
        while ((message = deadLetterConsumer1.receive(3, TimeUnit.SECONDS)) != null) {
            log.info("dead letter consumer received message : {} {}", (Object)message.getMessageId(), (Object)new String(message.getData()));
            deadLetterConsumer1.acknowledge(message);
            if (++totalInDeadLetter < 1) continue;
        }
        Assert.assertEquals((int)totalInDeadLetter, (int)1);
        deadLetterConsumer0.close();
        deadLetterConsumer1.close();
        consumer.close();
        Consumer checkConsumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://my-property/my-ns/dead-letter-topic-with-partitioned-topic"}).subscriptionName("my-subscription").subscriptionType(SubscriptionType.Key_Shared).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        Message checkMessage = checkConsumer.receive(3, TimeUnit.SECONDS);
        if (checkMessage != null) {
            log.info("check consumer received message : {} {}", (Object)checkMessage.getMessageId(), (Object)new String(checkMessage.getData()));
        }
        Assert.assertNull((Object)checkMessage);
        checkConsumer.close();
    }

    public static class FooV2 {
        @Nullable
        private String field1;
        @Nullable
        private String field2;
        @Nullable
        private String field3;

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }

        public String getField3() {
            return this.field3;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public void setField3(String field3) {
            this.field3 = field3;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FooV2)) {
                return false;
            }
            FooV2 other = (FooV2)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$field1 = this.getField1();
            String other$field1 = other.getField1();
            if (this$field1 == null ? other$field1 != null : !this$field1.equals(other$field1)) {
                return false;
            }
            String this$field2 = this.getField2();
            String other$field2 = other.getField2();
            if (this$field2 == null ? other$field2 != null : !this$field2.equals(other$field2)) {
                return false;
            }
            String this$field3 = this.getField3();
            String other$field3 = other.getField3();
            return !(this$field3 == null ? other$field3 != null : !this$field3.equals(other$field3));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FooV2;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field1 = this.getField1();
            result = result * 59 + ($field1 == null ? 43 : $field1.hashCode());
            String $field2 = this.getField2();
            result = result * 59 + ($field2 == null ? 43 : $field2.hashCode());
            String $field3 = this.getField3();
            result = result * 59 + ($field3 == null ? 43 : $field3.hashCode());
            return result;
        }

        public String toString() {
            return "DeadLetterTopicTest.FooV2(field1=" + this.getField1() + ", field2=" + this.getField2() + ", field3=" + this.getField3() + ")";
        }
    }

    public static class Foo {
        @Nullable
        private String field1;
        @Nullable
        private String field2;

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Foo)) {
                return false;
            }
            Foo other = (Foo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$field1 = this.getField1();
            String other$field1 = other.getField1();
            if (this$field1 == null ? other$field1 != null : !this$field1.equals(other$field1)) {
                return false;
            }
            String this$field2 = this.getField2();
            String other$field2 = other.getField2();
            return !(this$field2 == null ? other$field2 != null : !this$field2.equals(other$field2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Foo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field1 = this.getField1();
            result = result * 59 + ($field1 == null ? 43 : $field1.hashCode());
            String $field2 = this.getField2();
            result = result * 59 + ($field2 == null ? 43 : $field2.hashCode());
            return result;
        }

        public String toString() {
            return "DeadLetterTopicTest.Foo(field1=" + this.getField1() + ", field2=" + this.getField2() + ")";
        }
    }
}

