/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.impl.MemoryLimitController;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class ProducerMemoryLimitTest
extends ProducerConsumerBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=10000L)
    public void testProducerTimeoutMemoryRelease() throws Exception {
        this.initClientWithMemoryLimit();
        ProducerImpl producer = (ProducerImpl)this.pulsarClient.newProducer().topic("testProducerMemoryLimit").sendTimeout(5, TimeUnit.SECONDS).maxPendingMessages(0).enableBatching(false).create();
        try {
            this.stopBroker();
            try {
                producer.send((Object)"memory-test".getBytes(StandardCharsets.UTF_8));
                throw new IllegalStateException("can not reach here");
            }
            catch (PulsarClientException.TimeoutException ex) {
                PulsarClientImpl clientImpl = (PulsarClientImpl)this.pulsarClient;
                MemoryLimitController memoryLimitController = clientImpl.getMemoryLimitController();
                Assert.assertEquals((long)memoryLimitController.currentUsage(), (long)0L);
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=10000L)
    public void testProducerCloseMemoryRelease() throws Exception {
        this.initClientWithMemoryLimit();
        ProducerImpl producer = (ProducerImpl)this.pulsarClient.newProducer().topic("testProducerMemoryLimit").sendTimeout(5, TimeUnit.SECONDS).maxPendingMessages(0).enableBatching(false).create();
        try {
            this.stopBroker();
            producer.sendAsync((Object)"memory-test".getBytes(StandardCharsets.UTF_8));
            producer.close();
            PulsarClientImpl clientImpl = (PulsarClientImpl)this.pulsarClient;
            MemoryLimitController memoryLimitController = clientImpl.getMemoryLimitController();
            Assert.assertEquals((long)memoryLimitController.currentUsage(), (long)0L);
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    private void initClientWithMemoryLimit() throws PulsarClientException {
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.lookupUrl.toString()).memoryLimit(50L, SizeUnit.KILO_BYTES).build();
    }
}

