/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.ResourceGroup;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceGroupsBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(ResourceGroupsBase.class);

    protected List<String> internalGetResourceGroups() {
        try {
            this.validateSuperUserAccess();
            return this.getListOfResourcegroups("abc");
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to get ResourceGroups list ", (Object)this.clientAppId());
            throw new RestException(Response.Status.NOT_FOUND, "Property does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to get ResourceGroups list: {}", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    protected ResourceGroup internalGetResourceGroup(String rgName) {
        try {
            String resourceGroupPath = AdminResource.path("resourcegroups", rgName);
            ResourceGroup resourceGroup = (ResourceGroup)this.resourceGroupResources().get(resourceGroupPath).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "ResourceGroup does not exist"));
            return resourceGroup;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get ResourceGroup  {}", new Object[]{this.clientAppId(), rgName, e});
            throw new RestException(e);
        }
    }

    protected void internalUpdateResourceGroup(String rgName, ResourceGroup rgConfig) {
        String resourceGroupPath = AdminResource.path("resourcegroups", rgName);
        try {
            ResourceGroup resourceGroup = (ResourceGroup)this.resourceGroupResources().get(resourceGroupPath).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "ResourceGroup does not exist"));
            resourceGroup.setPublishRateInMsgs(rgConfig.getPublishRateInMsgs());
            resourceGroup.setPublishRateInBytes(rgConfig.getPublishRateInBytes());
            resourceGroup.setDispatchRateInMsgs(rgConfig.getDispatchRateInMsgs());
            resourceGroup.setDispatchRateInBytes(rgConfig.getDispatchRateInBytes());
            this.resourceGroupResources().set(resourceGroupPath, r -> resourceGroup);
            log.info("[{}] Successfully updated the ResourceGroup {}", (Object)this.clientAppId(), (Object)rgName);
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update configuration for ResourceGroup {}", new Object[]{this.clientAppId(), rgName, e});
            throw new RestException(e);
        }
    }

    protected void internalCreateResourceGroup(String rgName, ResourceGroup rgConfig) {
        String resourceGroupPath = AdminResource.path("resourcegroups", rgName);
        try {
            this.resourceGroupResources().create(resourceGroupPath, (Object)rgConfig);
            log.info("[{}] Created ResourceGroup {}", (Object)this.clientAppId(), (Object)rgName);
        }
        catch (MetadataStoreException.AlreadyExistsException e) {
            log.warn("[{}] Failed to create ResourceGroup {} - already exists", (Object)this.clientAppId(), (Object)rgName);
            throw new RestException(Response.Status.CONFLICT, "ResourceGroup already exists");
        }
        catch (Exception e) {
            log.error("[{}] Failed to create ResourceGroup {}", new Object[]{this.clientAppId(), rgName, e});
            throw new RestException(e);
        }
    }

    protected void internalCreateOrUpdateResourceGroup(String rgName, ResourceGroup rgConfig) {
        try {
            this.validateSuperUserAccess();
            ResourceGroupsBase.checkNotNull(rgConfig);
            String resourceGroupPath = AdminResource.path("resourcegroups", rgName);
            boolean rgExists = false;
            try {
                rgExists = this.resourceGroupResources().exists(resourceGroupPath);
            }
            catch (Exception e) {
                log.error("[{}] Failed to create/update ResourceGroup {}: {}", new Object[]{this.clientAppId(), rgName, e});
            }
            try {
                if (rgExists) {
                    this.internalUpdateResourceGroup(rgName, rgConfig);
                } else {
                    this.internalCreateResourceGroup(rgName, rgConfig);
                }
            }
            catch (Exception e) {
                log.error("[{}] Failed to create/update ResourceGroup {}: {}", new Object[]{this.clientAppId(), rgName, e});
                throw new RestException(e);
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to create/update ResourceGroup {}: {}", new Object[]{this.clientAppId(), rgName, e});
            throw new RestException(e);
        }
    }

    protected boolean internalCheckRgInUse(String rgName) {
        try {
            List tenants = this.tenantResources().getChildren(ResourceGroupsBase.path("policies"));
            for (String tenant : tenants) {
                List<String> namespaces = this.getListOfNamespaces(tenant);
                for (String namespace : namespaces) {
                    Policies policies = this.getNamespacePolicies(NamespaceName.get((String)namespace));
                    if (null == policies || !rgName.equals(policies.resource_group_name)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to get tenant/namespace list {}: {}", new Object[]{this.clientAppId(), rgName, e});
            throw new RestException(e);
        }
        return false;
    }

    protected void internalDeleteResourceGroup(String rgName) {
        try {
            if (this.internalCheckRgInUse(rgName)) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "ResourceGroup is in use");
            }
            String globalZkResourceGroupPath = ResourceGroupsBase.path("resourcegroups", rgName);
            this.resourceGroupResources().delete(globalZkResourceGroupPath);
            log.info("[{}] Deleted ResourceGroup {}", (Object)this.clientAppId(), (Object)rgName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete ResourceGroup {}.", new Object[]{this.clientAppId(), rgName, e});
            throw new RestException(e);
        }
    }
}

