/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.PublishRateLimiter;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.service.plugin.EntryFilter;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.EntryFilters;
import org.apache.pulsar.common.policies.data.Policies;

public class SystemTopic
extends PersistentTopic {
    public SystemTopic(String topic, ManagedLedger ledger, BrokerService brokerService) throws PulsarServerException {
        super(topic, ledger, brokerService);
    }

    @Override
    public boolean isDeleteWhileInactive() {
        return false;
    }

    @Override
    public boolean isSizeBacklogExceeded() {
        return false;
    }

    @Override
    public CompletableFuture<Boolean> checkTimeBacklogExceeded(boolean shouldUpdateOldPositionInfo) {
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public boolean isSystemTopic() {
        return true;
    }

    @Override
    public void checkMessageExpiry() {
    }

    @Override
    public void checkGC() {
    }

    @Override
    public CompletableFuture<Void> checkReplication() {
        if (SystemTopicNames.isTopicPoliciesSystemTopic((String)this.topic)) {
            return super.checkReplication();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isCompactionEnabled() {
        return !NamespaceService.isHeartbeatNamespace((ServiceUnitId)TopicName.get((String)this.topic));
    }

    @Override
    public boolean isDeduplicationEnabled() {
        return false;
    }

    @Override
    public boolean isEncryptionRequired() {
        return false;
    }

    @Override
    public EntryFilters getEntryFiltersPolicy() {
        return null;
    }

    @Override
    public List<EntryFilter> getEntryFilters() {
        return null;
    }

    @Override
    public PublishRateLimiter getBrokerPublishRateLimiter() {
        return PublishRateLimiter.DISABLED_RATE_LIMITER;
    }

    @Override
    public void updateResourceGroupLimiter(@Nonnull Policies namespacePolicies) {
    }

    @Override
    public Optional<DispatchRateLimiter> getBrokerDispatchRateLimiter() {
        return Optional.empty();
    }
}

