/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.common.naming.TopicName;

class SchemaRegistryStats
implements AutoCloseable,
Runnable {
    private static final String NAMESPACE = "namespace";
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.95, 0.99, 0.999, 0.9999, 1.0};
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);
    private final Counter getOpsFailedCounter;
    private final Counter putOpsFailedCounter;
    private final Counter deleteOpsFailedCounter;
    private final Counter compatibleCounter;
    private final Counter incompatibleCounter;
    private final Summary deleteOpsLatency;
    private final Summary getOpsLatency;
    private final Summary putOpsLatency;
    private final Map<String, Long> namespaceAccess = new ConcurrentHashMap<String, Long>();
    private ScheduledFuture<?> future;
    private static volatile SchemaRegistryStats instance;

    static synchronized SchemaRegistryStats getInstance(ScheduledExecutorService scheduler) {
        if (null == instance) {
            instance = new SchemaRegistryStats(scheduler);
        }
        return instance;
    }

    private SchemaRegistryStats(ScheduledExecutorService scheduler) {
        this.deleteOpsFailedCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_del_ops_failed_total", (String)"-").labelNames(new String[]{NAMESPACE})).create().register();
        this.getOpsFailedCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_get_ops_failed_total", (String)"-").labelNames(new String[]{NAMESPACE})).create().register();
        this.putOpsFailedCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_put_ops_failed_total", (String)"-").labelNames(new String[]{NAMESPACE})).create().register();
        this.compatibleCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_compatible_total", (String)"-").labelNames(new String[]{NAMESPACE})).create().register();
        this.incompatibleCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_incompatible_total", (String)"-").labelNames(new String[]{NAMESPACE})).create().register();
        this.deleteOpsLatency = this.buildSummary("pulsar_schema_del_ops_latency", "-");
        this.getOpsLatency = this.buildSummary("pulsar_schema_get_ops_latency", "-");
        this.putOpsLatency = this.buildSummary("pulsar_schema_put_ops_latency", "-");
        if (null != scheduler) {
            this.future = scheduler.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
        }
    }

    private Summary buildSummary(String name, String help) {
        Summary.Builder builder = (Summary.Builder)Summary.build((String)name, (String)help).labelNames(new String[]{NAMESPACE});
        for (double quantile : QUANTILES) {
            builder.quantile(quantile, 0.01);
        }
        return (Summary)builder.create().register();
    }

    void recordDelFailed(String schemaId) {
        ((Counter.Child)this.deleteOpsFailedCounter.labels(new String[]{this.getNamespace(schemaId)})).inc();
    }

    void recordGetFailed(String schemaId) {
        ((Counter.Child)this.getOpsFailedCounter.labels(new String[]{this.getNamespace(schemaId)})).inc();
    }

    void recordPutFailed(String schemaId) {
        ((Counter.Child)this.putOpsFailedCounter.labels(new String[]{this.getNamespace(schemaId)})).inc();
    }

    void recordDelLatency(String schemaId, long millis) {
        ((Summary.Child)this.deleteOpsLatency.labels(new String[]{this.getNamespace(schemaId)})).observe((double)millis);
    }

    void recordGetLatency(String schemaId, long millis) {
        ((Summary.Child)this.getOpsLatency.labels(new String[]{this.getNamespace(schemaId)})).observe((double)millis);
    }

    void recordPutLatency(String schemaId, long millis) {
        ((Summary.Child)this.putOpsLatency.labels(new String[]{this.getNamespace(schemaId)})).observe((double)millis);
    }

    void recordSchemaIncompatible(String schemaId) {
        ((Counter.Child)this.incompatibleCounter.labels(new String[]{this.getNamespace(schemaId)})).inc();
    }

    void recordSchemaCompatible(String schemaId) {
        ((Counter.Child)this.compatibleCounter.labels(new String[]{this.getNamespace(schemaId)})).inc();
    }

    private String getNamespace(String schemaId) {
        String namespace;
        try {
            namespace = TopicName.get((String)schemaId).getNamespace();
        }
        catch (IllegalArgumentException t) {
            namespace = "unknown";
        }
        this.namespaceAccess.put(namespace, System.currentTimeMillis());
        return namespace;
    }

    private void removeChild(String namespace) {
        this.getOpsFailedCounter.remove(new String[]{namespace});
        this.putOpsFailedCounter.remove(new String[]{namespace});
        this.deleteOpsFailedCounter.remove(new String[]{namespace});
        this.compatibleCounter.remove(new String[]{namespace});
        this.incompatibleCounter.remove(new String[]{namespace});
        this.deleteOpsLatency.remove(new String[]{namespace});
        this.getOpsLatency.remove(new String[]{namespace});
        this.putOpsLatency.remove(new String[]{namespace});
    }

    @Override
    public void close() throws Exception {
        if (CLOSED.compareAndSet(false, true)) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.deleteOpsFailedCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.getOpsFailedCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.putOpsFailedCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.compatibleCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.incompatibleCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.deleteOpsLatency);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.getOpsLatency);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.putOpsLatency);
            if (null != this.future) {
                this.future.cancel(false);
            }
        }
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        long interval = TimeUnit.MINUTES.toMillis(5L);
        this.namespaceAccess.entrySet().removeIf(entry -> {
            String namespace = (String)entry.getKey();
            long accessTime = (Long)entry.getValue();
            if (now - accessTime > interval) {
                this.removeChild(namespace);
                return true;
            }
            return false;
        });
    }
}

