/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.jetty.JettyStatisticsCollector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.DisableDebugHttpMethodFilter;
import org.apache.pulsar.broker.web.DynamicSkipUnknownPropertyHandler;
import org.apache.pulsar.broker.web.ExceptionHandler;
import org.apache.pulsar.broker.web.GzipHandlerUtil;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.JsonMapperProvider;
import org.apache.pulsar.broker.web.MaxRequestSizeFilter;
import org.apache.pulsar.broker.web.PreInterceptFilter;
import org.apache.pulsar.broker.web.ProcessHandlerFilter;
import org.apache.pulsar.broker.web.RateLimitingFilter;
import org.apache.pulsar.broker.web.ResponseHandlerFilter;
import org.apache.pulsar.broker.web.UnrecognizedPropertyExceptionMapper;
import org.apache.pulsar.broker.web.WebExecutorStats;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.jetty.tls.JettySslContextFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.QoSFilter;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebService
implements AutoCloseable {
    private static final String MATCH_ALL = "/*";
    public static final String ATTRIBUTE_PULSAR_NAME = "pulsar";
    public static final String HANDLER_CACHE_CONTROL = "max-age=3600";
    private final PulsarService pulsar;
    private final Server server;
    private final List<Handler> handlers = new ArrayList<Handler>();
    private final WebExecutorStats executorStats;
    private final WebExecutorThreadPool webServiceExecutor;
    private final ServerConnector httpConnector;
    private final ServerConnector httpsConnector;
    private final FilterInitializer filterInitializer;
    private JettyStatisticsCollector jettyStatisticsCollector;
    private static final DynamicSkipUnknownPropertyHandler sharedUnknownPropertyHandler = new DynamicSkipUnknownPropertyHandler();
    private static final Logger log = LoggerFactory.getLogger(WebService.class);

    public void updateHttpRequestsFailOnUnknownPropertiesEnabled(boolean httpRequestsFailOnUnknownPropertiesEnabled) {
        sharedUnknownPropertyHandler.setSkipUnknownProperty(!httpRequestsFailOnUnknownPropertiesEnabled);
    }

    public WebService(PulsarService pulsar) throws PulsarServerException {
        this.pulsar = pulsar;
        ServiceConfiguration config = pulsar.getConfiguration();
        this.webServiceExecutor = new WebExecutorThreadPool(config.getNumHttpServerThreads(), "pulsar-web", config.getHttpServerThreadPoolQueueSize());
        this.executorStats = WebExecutorStats.getStats(this.webServiceExecutor);
        this.server = new Server((ThreadPool)this.webServiceExecutor);
        if (config.getMaxHttpServerConnections() > 0) {
            this.server.addBean((Object)new ConnectionLimit(config.getMaxHttpServerConnections(), this.server));
        }
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        Optional port = config.getWebServicePort();
        HttpConfiguration httpConfig = new HttpConfiguration();
        if (config.isWebServiceTrustXForwardedFor()) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        httpConfig.setRequestHeaderSize(pulsar.getConfig().getHttpMaxRequestHeaderSize());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        if (port.isPresent()) {
            ArrayList<Object> connectionFactories = new ArrayList<Object>();
            if (config.isWebServiceHaProxyProtocolEnabled()) {
                connectionFactories.add(new ProxyConnectionFactory());
            }
            connectionFactories.add(httpConnectionFactory);
            this.httpConnector = new ServerConnector(this.server, connectionFactories.toArray(new ConnectionFactory[0]));
            this.httpConnector.setPort(((Integer)port.get()).intValue());
            this.httpConnector.setHost(pulsar.getBindAddress());
            connectors.add(this.httpConnector);
        } else {
            this.httpConnector = null;
        }
        Optional tlsPort = config.getWebServicePortTls();
        if (tlsPort.isPresent()) {
            try {
                Object sslCtxFactory = config.isTlsEnabledWithKeyStore() ? JettySslContextFactory.createServerSslContextWithKeystore((String)config.getWebServiceTlsProvider(), (String)config.getTlsKeyStoreType(), (String)config.getTlsKeyStore(), (String)config.getTlsKeyStorePassword(), (boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustStoreType(), (String)config.getTlsTrustStore(), (String)config.getTlsTrustStorePassword(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), (Set)config.getWebServiceTlsCiphers(), (Set)config.getWebServiceTlsProtocols(), (long)config.getTlsCertRefreshCheckDurationSec()) : JettySslContextFactory.createServerSslContext((String)config.getWebServiceTlsProvider(), (boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustCertsFilePath(), (String)config.getTlsCertificateFilePath(), (String)config.getTlsKeyFilePath(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), (Set)config.getWebServiceTlsCiphers(), (Set)config.getWebServiceTlsProtocols(), (long)config.getTlsCertRefreshCheckDurationSec());
                ArrayList<Object> connectionFactories = new ArrayList<Object>();
                if (config.isWebServiceHaProxyProtocolEnabled()) {
                    connectionFactories.add(new ProxyConnectionFactory());
                }
                connectionFactories.add(new SslConnectionFactory(sslCtxFactory, httpConnectionFactory.getProtocol()));
                connectionFactories.add(httpConnectionFactory);
                if (httpConfig.getCustomizer(SecureRequestCustomizer.class) == null) {
                    httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                }
                this.httpsConnector = new ServerConnector(this.server, connectionFactories.toArray(new ConnectionFactory[0]));
                this.httpsConnector.setPort(((Integer)tlsPort.get()).intValue());
                this.httpsConnector.setHost(pulsar.getBindAddress());
                connectors.add(this.httpsConnector);
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        } else {
            this.httpsConnector = null;
        }
        connectors.forEach(c -> c.setAcceptQueueSize(config.getHttpServerAcceptQueueSize()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
        this.filterInitializer = new FilterInitializer(pulsar);
        sharedUnknownPropertyHandler.setSkipUnknownProperty(!config.isHttpRequestsFailOnUnknownPropertiesEnabled());
    }

    public void addRestResources(String basePath, boolean requiresAuthentication, Map<String, Object> attributeMap, boolean useSharedJsonMapperProvider, String ... javaPackages) {
        ResourceConfig config = new ResourceConfig();
        for (String javaPackage : javaPackages) {
            config.packages(false, new String[]{javaPackage});
        }
        this.addResourceServlet(basePath, requiresAuthentication, attributeMap, config, useSharedJsonMapperProvider);
    }

    public void addRestResource(String basePath, boolean requiresAuthentication, Map<String, Object> attributeMap, boolean useSharedJsonMapperProvider, Class<?> ... resourceClasses) {
        ResourceConfig config = new ResourceConfig();
        for (Class<?> resourceClass : resourceClasses) {
            config.register(resourceClass);
        }
        this.addResourceServlet(basePath, requiresAuthentication, attributeMap, config, useSharedJsonMapperProvider);
    }

    private void addResourceServlet(String basePath, boolean requiresAuthentication, Map<String, Object> attributeMap, ResourceConfig config, boolean useSharedJsonMapperProvider) {
        if (useSharedJsonMapperProvider) {
            JsonMapperProvider jsonMapperProvider = new JsonMapperProvider((DeserializationProblemHandler)sharedUnknownPropertyHandler);
            config.register((Object)jsonMapperProvider);
            config.register(UnrecognizedPropertyExceptionMapper.class);
        } else {
            config.register(JsonMapperProvider.class);
        }
        config.register(MultiPartFeature.class);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        this.addServlet(basePath, servletHolder, requiresAuthentication, attributeMap);
    }

    public void addServlet(String path, ServletHolder servletHolder, boolean requiresAuthentication, Map<String, Object> attributeMap) {
        ServletContextHandler servletContextHandler = new ServletContextHandler(1);
        servletContextHandler.setContextPath(path);
        servletContextHandler.addServlet(servletHolder, MATCH_ALL);
        if (attributeMap != null) {
            attributeMap.forEach((arg_0, arg_1) -> ((ServletContextHandler)servletContextHandler).setAttribute(arg_0, arg_1));
        }
        this.filterInitializer.addFilters(servletContextHandler, requiresAuthentication);
        this.handlers.add((Handler)servletContextHandler);
    }

    public void addStaticResources(String basePath, String resourcePath) {
        ContextHandler capHandler = new ContextHandler();
        capHandler.setContextPath(basePath);
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setBaseResource(Resource.newClassPathResource((String)resourcePath));
        resHandler.setEtags(true);
        resHandler.setCacheControl(HANDLER_CACHE_CONTROL);
        capHandler.setHandler((Handler)resHandler);
        this.handlers.add((Handler)capHandler);
    }

    public void start() throws PulsarServerException {
        try {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            boolean showDetailedAddresses = this.pulsar.getConfiguration().getWebServiceLogDetailedAddresses() != null ? this.pulsar.getConfiguration().getWebServiceLogDetailedAddresses() : this.pulsar.getConfiguration().isWebServiceHaProxyProtocolEnabled() || this.pulsar.getConfiguration().isWebServiceTrustXForwardedFor();
            RequestLog requestLogger = JettyRequestLogFactory.createRequestLogger((boolean)showDetailedAddresses, (Server)this.server);
            requestLogHandler.setRequestLog(requestLogger);
            this.handlers.add(0, (Handler)new ContextHandlerCollection());
            this.handlers.add((Handler)requestLogHandler);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
            Handler handlerForContexts = GzipHandlerUtil.wrapWithGzipHandler((Handler)contexts, (List)this.pulsar.getConfig().getHttpServerGzipCompressionExcludedPaths());
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.setHandlers(new Handler[]{handlerForContexts, new DefaultHandler(), requestLogHandler});
            StatisticsHandler stats = new StatisticsHandler();
            stats.setHandler((Handler)handlerCollection);
            try {
                this.jettyStatisticsCollector = new JettyStatisticsCollector(stats);
                this.jettyStatisticsCollector.register();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.server.setHandler((Handler)stats);
            this.server.start();
            if (this.httpConnector != null) {
                log.info("HTTP Service started at http://{}:{}", (Object)this.httpConnector.getHost(), (Object)this.httpConnector.getLocalPort());
                this.pulsar.getConfiguration().setWebServicePort(Optional.of(this.httpConnector.getLocalPort()));
            } else {
                log.info("HTTP Service disabled");
            }
            if (this.httpsConnector != null) {
                log.info("HTTPS Service started at https://{}:{}", (Object)this.httpsConnector.getHost(), (Object)this.httpsConnector.getLocalPort());
                this.pulsar.getConfiguration().setWebServicePortTls(Optional.of(this.httpsConnector.getLocalPort()));
            } else {
                log.info("HTTPS Service disabled");
            }
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    @Override
    public void close() throws PulsarServerException {
        try {
            this.server.stop();
            if (this.jettyStatisticsCollector != null) {
                try {
                    CollectorRegistry.defaultRegistry.unregister((Collector)this.jettyStatisticsCollector);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.jettyStatisticsCollector = null;
            }
            this.webServiceExecutor.join();
            this.executorStats.close();
            log.info("Web service closed");
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.httpConnector != null) {
            return Optional.of(this.httpConnector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.httpsConnector != null) {
            return Optional.of(this.httpsConnector.getLocalPort());
        }
        return Optional.empty();
    }

    @Generated
    public static DynamicSkipUnknownPropertyHandler getSharedUnknownPropertyHandler() {
        return sharedUnknownPropertyHandler;
    }

    private static class FilterInitializer {
        private final List<FilterHolder> filterHolders = new ArrayList<FilterHolder>();
        private final FilterHolder authenticationFilterHolder;

        FilterInitializer(PulsarService pulsarService) {
            boolean brokerInterceptorEnabled;
            ServiceConfiguration config = pulsarService.getConfiguration();
            if (config.getMaxConcurrentHttpRequests() > 0) {
                FilterHolder filterHolder = new FilterHolder(QoSFilter.class);
                filterHolder.setInitParameter("maxRequests", String.valueOf(config.getMaxConcurrentHttpRequests()));
                this.filterHolders.add(filterHolder);
            }
            if (config.isHttpRequestsLimitEnabled()) {
                this.filterHolders.add(new FilterHolder((Filter)new RateLimitingFilter(config.getHttpRequestsMaxPerSecond())));
            }
            this.filterHolders.add(new FilterHolder((Filter)new WaitUntilPulsarServiceIsReadyForIncomingRequestsFilter(pulsarService)));
            boolean bl = brokerInterceptorEnabled = pulsarService.getBrokerInterceptor() != null;
            if (brokerInterceptorEnabled) {
                ExceptionHandler handler = new ExceptionHandler();
                this.filterHolders.add(new FilterHolder((Filter)new PreInterceptFilter(pulsarService.getBrokerInterceptor(), handler)));
                this.filterHolders.add(new FilterHolder((Filter)new ProcessHandlerFilter(pulsarService.getBrokerInterceptor())));
            }
            if (config.isAuthenticationEnabled()) {
                this.authenticationFilterHolder = new FilterHolder((Filter)new AuthenticationFilter(pulsarService.getBrokerService().getAuthenticationService()));
                this.filterHolders.add(this.authenticationFilterHolder);
            } else {
                this.authenticationFilterHolder = null;
            }
            if (config.isDisableHttpDebugMethods()) {
                this.filterHolders.add(new FilterHolder((Filter)new DisableDebugHttpMethodFilter(config)));
            }
            if (config.getHttpMaxRequestSize() > 0L) {
                this.filterHolders.add(new FilterHolder((Filter)new MaxRequestSizeFilter(config.getHttpMaxRequestSize())));
            }
            if (brokerInterceptorEnabled) {
                this.filterHolders.add(new FilterHolder((Filter)new ResponseHandlerFilter(pulsarService)));
            }
        }

        public void addFilters(ServletContextHandler context, boolean requiresAuthentication) {
            for (FilterHolder filterHolder : this.filterHolders) {
                if (!requiresAuthentication && filterHolder == this.authenticationFilterHolder) continue;
                context.addFilter(filterHolder, WebService.MATCH_ALL, EnumSet.allOf(DispatcherType.class));
            }
        }

        private static class WaitUntilPulsarServiceIsReadyForIncomingRequestsFilter
        implements Filter {
            private final PulsarService pulsarService;

            public WaitUntilPulsarServiceIsReadyForIncomingRequestsFilter(PulsarService pulsarService) {
                this.pulsarService = pulsarService;
            }

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                try {
                    this.pulsarService.waitUntilReadyForIncomingRequests();
                }
                catch (ExecutionException e) {
                    ((HttpServletResponse)response).sendError(503, "PulsarService failed to start.");
                    return;
                }
                catch (InterruptedException e) {
                    ((HttpServletResponse)response).sendError(503, "PulsarService is not ready.");
                    return;
                }
                chain.doFilter(request, response);
            }

            public void destroy() {
            }
        }
    }
}

