/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.extensions.data.TopBundlesLoadData;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceAllocationPolicies;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopKBundles {
    private static final Logger log = LoggerFactory.getLogger(TopKBundles.class);
    private final List<Map.Entry<String, ? extends Comparable>> arr = new ArrayList<Map.Entry<String, ? extends Comparable>>();
    private final TopBundlesLoadData loadData = new TopBundlesLoadData();
    private final PulsarService pulsar;
    private final SimpleResourceAllocationPolicies allocationPolicies;

    public TopKBundles(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.allocationPolicies = new SimpleResourceAllocationPolicies(pulsar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Map<String, NamespaceBundleStats> bundleStats, int topk) {
        this.arr.clear();
        try {
            boolean isLoadBalancerSheddingBundlesWithPoliciesEnabled = this.pulsar.getConfiguration().isLoadBalancerSheddingBundlesWithPoliciesEnabled();
            for (Map.Entry<String, NamespaceBundleStats> etr : bundleStats.entrySet()) {
                String bundle = etr.getKey();
                if (NamespaceService.isSystemServiceNamespace(NamespaceBundle.getBundleNamespace(bundle)) || !isLoadBalancerSheddingBundlesWithPoliciesEnabled && this.hasPolicies(bundle)) continue;
                this.arr.add(etr);
            }
            List<TopBundlesLoadData.BundleLoadData> topKBundlesLoadData = this.loadData.getTopBundlesLoadData();
            topKBundlesLoadData.clear();
            if (this.arr.isEmpty()) {
                return;
            }
            topk = Math.min(topk, this.arr.size());
            TopKBundles.partitionSort(this.arr, topk);
            for (int i = topk - 1; i >= 0; --i) {
                Map.Entry<String, ? extends Comparable> etr = this.arr.get(i);
                topKBundlesLoadData.add(new TopBundlesLoadData.BundleLoadData(etr.getKey(), (NamespaceBundleStats)etr.getValue()));
            }
        }
        finally {
            this.arr.clear();
        }
    }

    static void partitionSort(List<Map.Entry<String, ? extends Comparable>> arr, int k) {
        int start = 0;
        int end = arr.size() - 1;
        int target = k - 1;
        while (start < end) {
            int lo = start;
            int hi = end;
            int mid = lo;
            Comparable pivot = arr.get(hi).getValue();
            while (mid <= hi) {
                Map.Entry<String, ? extends Comparable> tmp;
                int cmp = pivot.compareTo(arr.get(mid).getValue());
                if (cmp < 0) {
                    tmp = arr.get(lo);
                    arr.set(lo++, arr.get(mid));
                    arr.set(mid++, tmp);
                    continue;
                }
                if (cmp > 0) {
                    tmp = arr.get(mid);
                    arr.set(mid, arr.get(hi));
                    arr.set(hi--, tmp);
                    continue;
                }
                ++mid;
            }
            if (lo <= target && target < mid) {
                end = lo;
                break;
            }
            if (target < lo) {
                end = lo - 1;
                continue;
            }
            start = mid;
        }
        Collections.sort(arr.subList(0, end), (a, b) -> ((Comparable)b.getValue()).compareTo(a.getValue()));
    }

    private boolean hasPolicies(String bundle) {
        NamespaceName namespace = NamespaceName.get((String)LoadManagerShared.getNamespaceNameFromBundleName(bundle));
        if (this.allocationPolicies.areIsolationPoliciesPresent(namespace)) {
            return true;
        }
        try {
            Optional<String> antiAffinityGroupOptional = LoadManagerShared.getNamespaceAntiAffinityGroup(this.pulsar, namespace.toString());
            if (antiAffinityGroupOptional.isPresent()) {
                return true;
            }
        }
        catch (MetadataStoreException e) {
            log.error("Failed to get localPolicies for bundle:{}.", (Object)bundle, (Object)e);
            throw new RuntimeException(e);
        }
        return false;
    }

    public List<Map.Entry<String, ? extends Comparable>> getArr() {
        return this.arr;
    }

    public TopBundlesLoadData getLoadData() {
        return this.loadData;
    }

    public PulsarService getPulsar() {
        return this.pulsar;
    }

    public SimpleResourceAllocationPolicies getAllocationPolicies() {
        return this.allocationPolicies;
    }

    public String toString() {
        return "TopKBundles(arr=" + String.valueOf(this.getArr()) + ", loadData=" + String.valueOf(this.getLoadData()) + ", pulsar=" + String.valueOf(this.getPulsar()) + ", allocationPolicies=" + String.valueOf(this.getAllocationPolicies()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopKBundles)) {
            return false;
        }
        TopKBundles other = (TopKBundles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Map.Entry<String, ? extends Comparable>> this$arr = this.getArr();
        List<Map.Entry<String, ? extends Comparable>> other$arr = other.getArr();
        if (this$arr == null ? other$arr != null : !((Object)this$arr).equals(other$arr)) {
            return false;
        }
        TopBundlesLoadData this$loadData = this.getLoadData();
        TopBundlesLoadData other$loadData = other.getLoadData();
        if (this$loadData == null ? other$loadData != null : !((Object)this$loadData).equals(other$loadData)) {
            return false;
        }
        PulsarService this$pulsar = this.getPulsar();
        PulsarService other$pulsar = other.getPulsar();
        if (this$pulsar == null ? other$pulsar != null : !this$pulsar.equals(other$pulsar)) {
            return false;
        }
        SimpleResourceAllocationPolicies this$allocationPolicies = this.getAllocationPolicies();
        SimpleResourceAllocationPolicies other$allocationPolicies = other.getAllocationPolicies();
        return !(this$allocationPolicies == null ? other$allocationPolicies != null : !this$allocationPolicies.equals(other$allocationPolicies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopKBundles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Map.Entry<String, ? extends Comparable>> $arr = this.getArr();
        result = result * 59 + ($arr == null ? 43 : ((Object)$arr).hashCode());
        TopBundlesLoadData $loadData = this.getLoadData();
        result = result * 59 + ($loadData == null ? 43 : ((Object)$loadData).hashCode());
        PulsarService $pulsar = this.getPulsar();
        result = result * 59 + ($pulsar == null ? 43 : $pulsar.hashCode());
        SimpleResourceAllocationPolicies $allocationPolicies = this.getAllocationPolicies();
        result = result * 59 + ($allocationPolicies == null ? 43 : $allocationPolicies.hashCode());
        return result;
    }
}

