/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import java.io.Closeable;
import java.util.function.Consumer;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.opentelemetry.OpenTelemetryService;

public class PulsarBrokerOpenTelemetry
implements Closeable {
    public static final String SERVICE_NAME = "pulsar-broker";
    private final OpenTelemetryService openTelemetryService;
    private final Meter meter;

    public PulsarBrokerOpenTelemetry(ServiceConfiguration config, @VisibleForTesting Consumer<AutoConfiguredOpenTelemetrySdkBuilder> builderCustomizer) {
        this.openTelemetryService = OpenTelemetryService.builder().clusterName(config.getClusterName()).serviceName(SERVICE_NAME).serviceVersion(PulsarVersion.getVersion()).builderCustomizer(builderCustomizer).build();
        this.meter = this.openTelemetryService.getOpenTelemetry().getMeter("org.apache.pulsar.broker");
    }

    @Override
    public void close() {
        this.openTelemetryService.close();
    }

    public Meter getMeter() {
        return this.meter;
    }
}

