/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import io.netty.buffer.ByteBuf;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TransactionBufferClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionBufferHandler;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnPartitionResponse;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnSubscriptionResponse;
import org.apache.pulsar.common.api.proto.ServerError;
import org.apache.pulsar.common.api.proto.TxnAction;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.GrowableArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBufferHandlerImpl
implements TransactionBufferHandler {
    private static final Logger log = LoggerFactory.getLogger(TransactionBufferHandlerImpl.class);
    private final ConcurrentSkipListMap<Long, OpRequestSend> outstandingRequests;
    private final GrowableArrayBlockingQueue<OpRequestSend> pendingRequests;
    private final AtomicLong requestIdGenerator = new AtomicLong();
    private final long operationTimeoutInMills;
    private final HashedWheelTimer timer;
    private final PulsarService pulsarService;
    private final PulsarClientImpl pulsarClient;
    private final int randomKeyForSelectConnection;
    private static final AtomicIntegerFieldUpdater<TransactionBufferHandlerImpl> REQUEST_CREDITS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TransactionBufferHandlerImpl.class, "requestCredits");
    private volatile int requestCredits;

    public TransactionBufferHandlerImpl(PulsarService pulsarService, HashedWheelTimer timer, int maxConcurrentRequests, long operationTimeoutInMills) throws PulsarServerException {
        this.pulsarService = pulsarService;
        this.pulsarClient = (PulsarClientImpl)pulsarService.getClient();
        this.outstandingRequests = new ConcurrentSkipListMap();
        this.pendingRequests = new GrowableArrayBlockingQueue();
        this.operationTimeoutInMills = operationTimeoutInMills;
        this.timer = timer;
        this.requestCredits = Math.max(100, maxConcurrentRequests);
        this.randomKeyForSelectConnection = this.pulsarClient.getCnxPool().genRandomKeyToSelectCon();
    }

    public CompletableFuture<TxnID> endTxnOnTopic(String topic, long txnIdMostBits, long txnIdLeastBits, TxnAction action, long lowWaterMark) {
        ByteBuf cmd;
        if (log.isDebugEnabled()) {
            log.debug("[{}] endTxnOnTopic txnId: [{}], txnAction: [{}]", new Object[]{topic, new TxnID(txnIdMostBits, txnIdLeastBits), action.getValue()});
        }
        CompletableFuture<TxnID> cb = new CompletableFuture<TxnID>();
        long requestId = this.requestIdGenerator.getAndIncrement();
        OpRequestSend op = OpRequestSend.create(requestId, topic, cmd = Commands.newEndTxnOnPartition((long)requestId, (long)txnIdLeastBits, (long)txnIdMostBits, (String)topic, (TxnAction)action, (long)lowWaterMark), cb, this.getClientCnx(topic));
        if (this.checkRequestCredits(op)) {
            this.endTxn(op);
        }
        return cb;
    }

    public CompletableFuture<TxnID> endTxnOnSubscription(String topic, String subscription, long txnIdMostBits, long txnIdLeastBits, TxnAction action, long lowWaterMark) {
        ByteBuf cmd;
        if (log.isDebugEnabled()) {
            log.debug("[{}] endTxnOnSubscription txnId: [{}], txnAction: [{}]", new Object[]{topic, new TxnID(txnIdMostBits, txnIdLeastBits), action.getValue()});
        }
        CompletableFuture<TxnID> cb = new CompletableFuture<TxnID>();
        long requestId = this.requestIdGenerator.getAndIncrement();
        OpRequestSend op = OpRequestSend.create(requestId, topic, cmd = Commands.newEndTxnOnSubscription((long)requestId, (long)txnIdLeastBits, (long)txnIdMostBits, (String)topic, (String)subscription, (TxnAction)action, (long)lowWaterMark), cb, this.getClientCnx(topic));
        if (this.checkRequestCredits(op)) {
            this.endTxn(op);
        }
        return cb;
    }

    private boolean checkRequestCredits(OpRequestSend op) {
        int currentPermits = REQUEST_CREDITS_UPDATER.get(this);
        if (currentPermits > 0 && this.pendingRequests.peek() == null) {
            if (REQUEST_CREDITS_UPDATER.compareAndSet(this, currentPermits, currentPermits - 1)) {
                return true;
            }
            return this.checkRequestCredits(op);
        }
        this.pendingRequests.add((Object)op);
        return false;
    }

    public void endTxn(OpRequestSend op) {
        op.cnx.whenComplete((clientCnx, ex) -> {
            if (ex == null) {
                if (clientCnx.ctx().channel().isActive()) {
                    clientCnx.registerTransactionBufferHandler((TransactionBufferHandler)this);
                    this.outstandingRequests.put(op.requestId, op);
                    long requestId = op.requestId;
                    this.timer.newTimeout(timeout -> {
                        OpRequestSend peek = this.outstandingRequests.remove(requestId);
                        if (peek != null && !peek.cb.isDone() && !peek.cb.isCompletedExceptionally()) {
                            peek.cb.completeExceptionally((Throwable)new TransactionBufferClientException.RequestTimeoutException());
                            this.onResponse(peek);
                        }
                    }, this.operationTimeoutInMills, TimeUnit.MILLISECONDS);
                    op.cmd.retain();
                    clientCnx.ctx().writeAndFlush((Object)op.cmd, clientCnx.ctx().voidPromise());
                } else {
                    op.cb.completeExceptionally((Throwable)new PulsarClientException.LookupException(op.topic + " endTxn channel is not active"));
                    this.onResponse(op);
                }
            } else {
                Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
                log.error("endTxn error topic: [{}]", (Object)op.topic, (Object)cause);
                if (cause instanceof PulsarClientException.BrokerMetadataException) {
                    op.cb.complete(null);
                } else {
                    op.cb.completeExceptionally((Throwable)new PulsarClientException.LookupException(cause.getMessage()));
                }
                this.onResponse(op);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEndTxnOnTopicResponse(long requestId, CommandEndTxnOnPartitionResponse response) {
        OpRequestSend op = this.outstandingRequests.remove(requestId);
        if (op == null) {
            if (log.isDebugEnabled()) {
                log.debug("Got end txn on topic response for timeout {} - {}", (Object)response.getTxnidMostBits(), (Object)response.getTxnidLeastBits());
            }
            return;
        }
        try {
            if (!response.hasError()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Got end txn on topic response for for request {}", (Object)op.topic, (Object)response.getRequestId());
                }
                op.cb.complete(new TxnID(response.getTxnidMostBits(), response.getTxnidLeastBits()));
            } else {
                log.error("[{}] Got end txn on topic response for request {} error {}", new Object[]{op.topic, response.getRequestId(), response.getError()});
                op.cb.completeExceptionally(ClientCnx.getPulsarClientException((ServerError)response.getError(), (String)response.getMessage()));
            }
        }
        finally {
            this.onResponse(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEndTxnOnSubscriptionResponse(long requestId, CommandEndTxnOnSubscriptionResponse response) {
        OpRequestSend op = this.outstandingRequests.remove(requestId);
        if (op == null) {
            if (log.isDebugEnabled()) {
                log.debug("Got end txn on subscription response for timeout {} - {}", (Object)response.getTxnidMostBits(), (Object)response.getTxnidLeastBits());
            }
            return;
        }
        try {
            if (!response.hasError()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Got end txn on subscription response for for request {}", (Object)op.topic, (Object)response.getRequestId());
                }
                op.cb.complete(new TxnID(response.getTxnidMostBits(), response.getTxnidLeastBits()));
            } else {
                log.error("[{}] Got end txn on subscription response for request {} error {}", new Object[]{op.topic, response.getRequestId(), response.getError()});
                op.cb.completeExceptionally(ClientCnx.getPulsarClientException((ServerError)response.getError(), (String)response.getMessage()));
            }
        }
        finally {
            this.onResponse(op);
        }
    }

    public void onResponse(OpRequestSend op) {
        REQUEST_CREDITS_UPDATER.incrementAndGet(this);
        if (op != null) {
            ReferenceCountUtil.safeRelease((Object)op.cmd);
            op.recycle();
        }
        this.checkPendingRequests();
    }

    private void checkPendingRequests() {
        int permits;
        while ((permits = REQUEST_CREDITS_UPDATER.get(this)) > 0 && this.pendingRequests.peek() != null) {
            if (!REQUEST_CREDITS_UPDATER.compareAndSet(this, permits, permits - 1)) continue;
            OpRequestSend polled = (OpRequestSend)this.pendingRequests.poll();
            if (polled != null) {
                CompletableFuture<ClientCnx> clientCnx = this.getClientCnx(polled.topic);
                if (polled.cnx != clientCnx) {
                    OpRequestSend invalid = polled;
                    polled = OpRequestSend.create(invalid.requestId, invalid.topic, invalid.cmd, invalid.cb, clientCnx);
                    invalid.recycle();
                }
                this.endTxn(polled);
                continue;
            }
            REQUEST_CREDITS_UPDATER.incrementAndGet(this);
        }
    }

    public CompletableFuture<ClientCnx> getClientCnxWithLookup(String topic) {
        return this.pulsarClient.getConnection(topic, this.randomKeyForSelectConnection).thenApply(Pair::getLeft);
    }

    public CompletableFuture<ClientCnx> getClientCnx(String topic) {
        NamespaceService namespaceService = this.pulsarService.getNamespaceService();
        CompletableFuture<NamespaceBundle> nsBundle = namespaceService.getBundleAsync(TopicName.get((String)topic));
        return ((CompletableFuture)nsBundle.thenCompose(bundle -> namespaceService.getOwnerAsync((NamespaceBundle)bundle))).thenCompose(data -> {
            if (data.isPresent()) {
                NamespaceEphemeralData ephemeralData = (NamespaceEphemeralData)data.get();
                try {
                    if (!ephemeralData.isDisabled()) {
                        URI uri = this.pulsarClient.getConfiguration().isUseTls() ? new URI(ephemeralData.getNativeUrlTls()) : new URI(ephemeralData.getNativeUrl());
                        InetSocketAddress brokerAddress = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
                        return this.pulsarClient.getConnection(brokerAddress, brokerAddress, this.randomKeyForSelectConnection);
                    }
                    return this.getClientCnxWithLookup(topic);
                }
                catch (URISyntaxException e) {
                    return this.getClientCnxWithLookup(topic);
                }
            }
            return this.getClientCnxWithLookup(topic);
        });
    }

    public void close() {
        this.timer.stop();
    }

    public int getAvailableRequestCredits() {
        return REQUEST_CREDITS_UPDATER.get(this);
    }

    public int getPendingRequestsCount() {
        return this.pendingRequests.size();
    }

    public static final class OpRequestSend {
        long requestId;
        String topic;
        ByteBuf cmd;
        CompletableFuture<TxnID> cb;
        long createdAt;
        CompletableFuture<ClientCnx> cnx;
        private final Recycler.Handle<OpRequestSend> recyclerHandle;
        private static final Recycler<OpRequestSend> RECYCLER = new Recycler<OpRequestSend>(){

            protected OpRequestSend newObject(Recycler.Handle<OpRequestSend> handle) {
                return new OpRequestSend(handle);
            }
        };

        static OpRequestSend create(long requestId, String topic, ByteBuf cmd, CompletableFuture<TxnID> cb, CompletableFuture<ClientCnx> cnx) {
            OpRequestSend op = (OpRequestSend)RECYCLER.get();
            op.requestId = requestId;
            op.topic = topic;
            op.cmd = cmd;
            op.cb = cb;
            op.createdAt = System.currentTimeMillis();
            op.cnx = cnx;
            return op;
        }

        void recycle() {
            this.recyclerHandle.recycle((Object)this);
        }

        private OpRequestSend(Recycler.Handle<OpRequestSend> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }
    }
}

