/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import org.apache.pulsar.PulsarClusterMetadataSetup;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import picocli.CommandLine;

public class PulsarTransactionCoordinatorMetadataSetup {
    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        CommandLine commander = new CommandLine((Object)arguments);
        try {
            commander.parseArgs(args);
            if (arguments.help) {
                commander.usage(commander.getOut());
                return;
            }
            if (arguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("initialize-transaction-coordinator-metadata", (Object)commander);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            commander.usage(commander.getOut());
            throw e;
        }
        if (arguments.configurationStore == null) {
            System.err.println("Configuration store address argument is required (--configuration-store)");
            commander.usage(commander.getOut());
            System.exit(1);
        }
        if (arguments.numTransactionCoordinators <= 0) {
            System.err.println("Number of transaction coordinators must greater than 0");
            System.exit(1);
        }
        try (MetadataStoreExtended configStore = PulsarClusterMetadataSetup.initConfigMetadataStore(arguments.configurationStore, arguments.configurationStoreConfigPath, arguments.zkSessionTimeoutMillis);){
            PulsarResources pulsarResources = new PulsarResources(null, (MetadataStore)configStore);
            PulsarClusterMetadataSetup.createTenantIfAbsent(pulsarResources, NamespaceName.SYSTEM_NAMESPACE.getTenant(), arguments.cluster);
            PulsarClusterMetadataSetup.createNamespaceIfAbsent(pulsarResources, NamespaceName.SYSTEM_NAMESPACE, arguments.cluster);
            PulsarClusterMetadataSetup.createPartitionedTopic((MetadataStore)configStore, SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN, arguments.numTransactionCoordinators);
        }
        System.out.println("Transaction coordinator metadata setup success");
    }

    @CommandLine.Command(name="initialize-transaction-coordinator-metadata", showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
    private static class Arguments {
        @CommandLine.Option(names={"-c", "--cluster"}, description={"Cluster name"}, required=true)
        private String cluster;
        @CommandLine.Option(names={"-cs", "--configuration-store"}, description={"Configuration Store connection string"}, required=true)
        private String configurationStore;
        @CommandLine.Option(names={"-cmscp", "--configuration-metadata-store-config-path"}, description={"Configuration Metadata Store config path"}, hidden=false)
        private String configurationStoreConfigPath;
        @CommandLine.Option(names={"--zookeeper-session-timeout-ms"}, description={"Local zookeeper session timeout ms"})
        private int zkSessionTimeoutMillis = 30000;
        @CommandLine.Option(names={"--initial-num-transaction-coordinators"}, description={"Num transaction coordinators will assigned in cluster"})
        private int numTransactionCoordinators = 16;
        @CommandLine.Option(names={"-h", "--help"}, description={"Show this help message"})
        private boolean help = false;
        @CommandLine.Option(names={"-g", "--generate-docs"}, description={"Generate docs"})
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

