/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.protocol;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.protocol.ProtocolHandler;
import org.apache.pulsar.broker.protocol.ProtocolHandlerDefinitions;
import org.apache.pulsar.broker.protocol.ProtocolHandlerMetadata;
import org.apache.pulsar.broker.protocol.ProtocolHandlerUtils;
import org.apache.pulsar.broker.protocol.ProtocolHandlerWithClassLoader;
import org.apache.pulsar.broker.service.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolHandlers
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocolHandlers.class);
    private final Map<SocketAddress, String> endpoints = new ConcurrentHashMap<SocketAddress, String>();
    private final Map<String, ProtocolHandlerWithClassLoader> handlers;

    public static ProtocolHandlers load(ServiceConfiguration conf) throws IOException {
        if (conf.getMessagingProtocols().isEmpty()) {
            return new ProtocolHandlers(Collections.emptyMap());
        }
        ProtocolHandlerDefinitions definitions = ProtocolHandlerUtils.searchForHandlers(conf.getProtocolHandlerDirectory(), conf.getNarExtractionDirectory());
        ImmutableMap.Builder handlersBuilder = ImmutableMap.builder();
        conf.getMessagingProtocols().forEach(protocol -> {
            ProtocolHandlerWithClassLoader handler;
            ProtocolHandlerMetadata definition = definitions.handlers().get(protocol);
            if (null == definition) {
                throw new RuntimeException("No protocol handler is found for protocol `" + protocol + "`. Available protocols are : " + String.valueOf(definitions.handlers()));
            }
            try {
                handler = ProtocolHandlerUtils.load(definition, conf.getNarExtractionDirectory());
            }
            catch (IOException e) {
                log.error("Failed to load the protocol handler for protocol `" + protocol + "`", (Throwable)e);
                throw new RuntimeException("Failed to load the protocol handler for protocol `" + protocol + "`");
            }
            if (!handler.accept((String)protocol)) {
                handler.close();
                log.error("Malformed protocol handler found for protocol `" + protocol + "`");
                throw new RuntimeException("Malformed protocol handler found for protocol `" + protocol + "`");
            }
            handlersBuilder.put(protocol, (Object)handler);
            log.info("Successfully loaded protocol handler for protocol `{}`", protocol);
        });
        return new ProtocolHandlers((Map<String, ProtocolHandlerWithClassLoader>)handlersBuilder.build());
    }

    ProtocolHandlers(Map<String, ProtocolHandlerWithClassLoader> handlers) {
        this.handlers = handlers;
    }

    public ProtocolHandler protocol(String protocol) {
        ProtocolHandlerWithClassLoader h = this.handlers.get(protocol);
        if (null == h) {
            return null;
        }
        return h.getHandler();
    }

    public void initialize(ServiceConfiguration conf) throws Exception {
        for (ProtocolHandler protocolHandler : this.handlers.values()) {
            protocolHandler.initialize(conf);
        }
    }

    public Map<String, String> getProtocolDataToAdvertise() {
        return this.handlers.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ProtocolHandlerWithClassLoader)e.getValue()).getProtocolDataToAdvertise()));
    }

    public Map<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>> newChannelInitializers() {
        HashMap<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>> channelInitializers = new HashMap<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>>();
        HashSet addresses = new HashSet();
        for (Map.Entry<String, ProtocolHandlerWithClassLoader> handler : this.handlers.entrySet()) {
            Map<InetSocketAddress, ChannelInitializer<SocketChannel>> initializers = handler.getValue().newChannelInitializers();
            initializers.forEach((address, initializer) -> {
                if (!addresses.add(address)) {
                    log.error("Protocol handler for `{}` attempts to use {} for its listening port. But it is already occupied by other message protocols.", handler.getKey(), address);
                    throw new RuntimeException("Protocol handler for `" + (String)handler.getKey() + "` attempts to use " + String.valueOf(address) + " for its listening port. But it is already occupied by other messaging protocols");
                }
                channelInitializers.put((String)handler.getKey(), initializers);
                this.endpoints.put((SocketAddress)address, (String)handler.getKey());
            });
        }
        return channelInitializers;
    }

    public void start(BrokerService service) {
        this.handlers.values().forEach(handler -> handler.start(service));
    }

    @Override
    public void close() {
        this.handlers.values().forEach(ProtocolHandler::close);
    }

    @Generated
    public Map<SocketAddress, String> getEndpoints() {
        return this.endpoints;
    }
}

