/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferClientStats;
import org.apache.pulsar.client.impl.transaction.TransactionBufferHandler;
import org.apache.pulsar.common.naming.TopicName;

public final class TransactionBufferClientStatsImpl
implements TransactionBufferClientStats {
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.95, 0.99, 0.999, 0.9999, 1.0};
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Counter abortFailed;
    private final Counter commitFailed;
    private final Summary abortLatency;
    private final Summary commitLatency;
    private final Gauge pendingRequests;
    private final boolean exposeTopicLevelMetrics;
    private static TransactionBufferClientStats instance;

    private TransactionBufferClientStatsImpl(boolean exposeTopicLevelMetrics, final TransactionBufferHandler handler) {
        String[] stringArray;
        this.exposeTopicLevelMetrics = exposeTopicLevelMetrics;
        if (exposeTopicLevelMetrics) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "namespace";
            stringArray = stringArray2;
            stringArray2[1] = "topic";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "namespace";
        }
        String[] labelNames = stringArray;
        this.abortFailed = (Counter)((Counter.Builder)Counter.build((String)"pulsar_txn_tb_client_abort_failed", (String)"-").labelNames(labelNames)).register();
        this.commitFailed = (Counter)((Counter.Builder)Counter.build((String)"pulsar_txn_tb_client_commit_failed", (String)"-").labelNames(labelNames)).register();
        this.abortLatency = this.buildSummary("pulsar_txn_tb_client_abort_latency", "-", labelNames);
        this.commitLatency = this.buildSummary("pulsar_txn_tb_client_commit_latency", "-", labelNames);
        this.pendingRequests = (Gauge)((Gauge)Gauge.build((String)"pulsar_txn_tb_client_pending_requests", (String)"-").register()).setChild((Object)new Gauge.Child(){

            public double get() {
                return null == handler ? 0.0 : (double)handler.getPendingRequestsCount();
            }
        }, new String[0]);
    }

    private Summary buildSummary(String name, String help, String[] labelNames) {
        Summary.Builder builder = (Summary.Builder)Summary.build((String)name, (String)help).labelNames(labelNames);
        for (double quantile : QUANTILES) {
            builder.quantile(quantile, 0.01);
        }
        return (Summary)builder.register();
    }

    public static synchronized TransactionBufferClientStats getInstance(boolean exposeTopicLevelMetrics, TransactionBufferHandler handler) {
        if (null == instance) {
            instance = new TransactionBufferClientStatsImpl(exposeTopicLevelMetrics, handler);
        }
        return instance;
    }

    @Override
    public void recordAbortFailed(String topic) {
        ((Counter.Child)this.abortFailed.labels(this.labelValues(topic))).inc();
    }

    @Override
    public void recordCommitFailed(String topic) {
        ((Counter.Child)this.commitFailed.labels(this.labelValues(topic))).inc();
    }

    @Override
    public void recordAbortLatency(String topic, long nanos) {
        ((Summary.Child)this.abortLatency.labels(this.labelValues(topic))).observe((double)nanos);
    }

    @Override
    public void recordCommitLatency(String topic, long nanos) {
        ((Summary.Child)this.commitLatency.labels(this.labelValues(topic))).observe((double)nanos);
    }

    private String[] labelValues(String topic) {
        try {
            String[] stringArray;
            TopicName topicName = TopicName.get((String)topic);
            if (this.exposeTopicLevelMetrics) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = topicName.getNamespace();
                stringArray = stringArray2;
                stringArray2[1] = topic;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = topicName.getNamespace();
            }
            return stringArray;
        }
        catch (Throwable t) {
            String[] stringArray;
            if (this.exposeTopicLevelMetrics) {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "unknown";
                stringArray = stringArray4;
                stringArray4[1] = "unknown";
            } else {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = "unknown";
            }
            return stringArray;
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            instance = null;
            CollectorRegistry.defaultRegistry.unregister((Collector)this.abortFailed);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.commitFailed);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.abortLatency);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.commitLatency);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.pendingRequests);
        }
    }
}

