/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.checksum.utils;

import com.scurrilous.circe.IncrementalIntHash;
import com.scurrilous.circe.crc.Sse42Crc32C;
import com.scurrilous.circe.crc.StandardCrcProvider;
import com.scurrilous.circe.params.CrcParameters;
import io.netty.buffer.ByteBuf;
import org.apache.pulsar.checksum.utils.Crc32cSse42Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crc32cChecksum {
    private static final Logger log = LoggerFactory.getLogger(Crc32cChecksum.class);
    private static final IncrementalIntHash CRC32C_HASH;

    public static int computeChecksum(ByteBuf payload) {
        if (payload.hasMemoryAddress() && CRC32C_HASH instanceof Sse42Crc32C) {
            return CRC32C_HASH.calculate(payload.memoryAddress() + (long)payload.readerIndex(), payload.readableBytes());
        }
        if (payload.hasArray()) {
            return CRC32C_HASH.calculate(payload.array(), payload.arrayOffset() + payload.readerIndex(), payload.readableBytes());
        }
        return CRC32C_HASH.calculate(payload.nioBuffer());
    }

    public static int resumeChecksum(int previousChecksum, ByteBuf payload) {
        if (payload.hasMemoryAddress() && CRC32C_HASH instanceof Sse42Crc32C) {
            return CRC32C_HASH.resume(previousChecksum, payload.memoryAddress() + (long)payload.readerIndex(), payload.readableBytes());
        }
        if (payload.hasArray()) {
            return CRC32C_HASH.resume(previousChecksum, payload.array(), payload.arrayOffset() + payload.readerIndex(), payload.readableBytes());
        }
        return CRC32C_HASH.resume(previousChecksum, payload.nioBuffer());
    }

    static {
        if (Sse42Crc32C.isSupported()) {
            CRC32C_HASH = new Crc32cSse42Provider().getIncrementalInt(CrcParameters.CRC32C);
            if (log.isDebugEnabled()) {
                log.debug("SSE4.2 CRC32C provider initialized");
            }
        } else {
            CRC32C_HASH = new StandardCrcProvider().getIncrementalInt(CrcParameters.CRC32C);
        }
    }
}

