/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.checksum.utils;

import com.scurrilous.circe.Hash;
import com.scurrilous.circe.HashParameters;
import com.scurrilous.circe.HashSupport;
import com.scurrilous.circe.StatelessHash;
import com.scurrilous.circe.crc.Sse42Crc32C;
import com.scurrilous.circe.impl.AbstractHashProvider;
import com.scurrilous.circe.params.CrcParameters;
import java.util.EnumSet;

public final class Crc32cSse42Provider
extends AbstractHashProvider<HashParameters> {
    private static final int[] DEFAULT_CHUNK = new int[]{4096, 512, 64};

    public Crc32cSse42Provider() {
        super(HashParameters.class);
    }

    @Override
    protected EnumSet<HashSupport> querySupportTyped(HashParameters params) {
        if (Crc32cSse42Provider.isCrc32C(params) && Sse42Crc32C.isSupported()) {
            return EnumSet.allOf(HashSupport.class);
        }
        return EnumSet.noneOf(HashSupport.class);
    }

    @Override
    protected Hash get(HashParameters params, EnumSet<HashSupport> required) {
        if (Crc32cSse42Provider.isCrc32C(params) && Sse42Crc32C.isSupported()) {
            return this.getCacheable(params, required);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean isCrc32C(HashParameters params) {
        return params.equals(CrcParameters.CRC32C);
    }

    @Override
    protected StatelessHash createCacheable(HashParameters params, EnumSet<HashSupport> required) {
        return new Sse42Crc32C(DEFAULT_CHUNK);
    }
}

