/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.v1;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.client.api.ClientConfiguration;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerConfiguration;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConfiguration;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderConfiguration;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.apache.pulsar.client.impl.conf.ReaderConfigurationData;
import org.apache.pulsar.client.impl.v1.ConsumerV1Impl;
import org.apache.pulsar.client.impl.v1.ProducerV1Impl;
import org.apache.pulsar.client.impl.v1.ReaderV1Impl;
import org.apache.pulsar.common.util.FutureUtil;

public class PulsarClientV1Impl
implements PulsarClient {
    private final PulsarClientImpl client;

    public PulsarClientV1Impl(String serviceUrl, ClientConfiguration conf) throws PulsarClientException {
        this.client = new PulsarClientImpl(conf.setServiceUrl(serviceUrl).getConfigurationData().clone());
    }

    @Override
    public void close() throws PulsarClientException {
        this.client.close();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.client.closeAsync();
    }

    @Override
    public Producer createProducer(String topic, ProducerConfiguration conf) throws PulsarClientException {
        if (conf == null) {
            throw new PulsarClientException.InvalidConfigurationException("Invalid null configuration object");
        }
        try {
            return this.createProducerAsync(topic, conf).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException((Throwable)e);
        }
    }

    @Override
    public Producer createProducer(String topic) throws PulsarClientException {
        return this.createProducer(topic, new ProducerConfiguration());
    }

    @Override
    public CompletableFuture<Producer> createProducerAsync(String topic, ProducerConfiguration conf) {
        ProducerConfigurationData confData = conf.getProducerConfigurationData().clone();
        confData.setTopicName(topic);
        return this.client.createProducerAsync(confData).thenApply(p -> new ProducerV1Impl((ProducerImpl<byte[]>)((ProducerImpl)p)));
    }

    @Override
    public CompletableFuture<Producer> createProducerAsync(String topic) {
        return this.createProducerAsync(topic, new ProducerConfiguration());
    }

    @Override
    public Reader createReader(String topic, MessageId startMessageId, ReaderConfiguration conf) throws PulsarClientException {
        try {
            return this.createReaderAsync(topic, startMessageId, conf).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Reader> createReaderAsync(String topic, MessageId startMessageId, ReaderConfiguration conf) {
        ReaderConfigurationData confData = conf.getReaderConfigurationData().clone();
        confData.setTopicName(topic);
        confData.setStartMessageId(startMessageId);
        return this.client.createReaderAsync(confData).thenApply(r -> new ReaderV1Impl((org.apache.pulsar.shade.client.api.v2.Reader<byte[]>)r));
    }

    @Override
    public void shutdown() throws PulsarClientException {
        this.client.shutdown();
    }

    @Override
    public Consumer subscribe(String topic, String subscriptionName) throws PulsarClientException {
        return this.subscribe(topic, subscriptionName, new ConsumerConfiguration());
    }

    @Override
    public CompletableFuture<Consumer> subscribeAsync(String topic, String subscription, ConsumerConfiguration conf) {
        if (conf == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Invalid null configuration"));
        }
        ConsumerConfigurationData confData = conf.getConfigurationData().clone();
        confData.getTopicNames().add(topic);
        confData.setSubscriptionName(subscription);
        return this.client.subscribeAsync(confData).thenApply(c -> new ConsumerV1Impl((org.apache.pulsar.shade.client.api.v2.Consumer<byte[]>)c));
    }

    @Override
    public CompletableFuture<Consumer> subscribeAsync(String topic, String subscriptionName) {
        return this.subscribeAsync(topic, subscriptionName, new ConsumerConfiguration());
    }

    @Override
    public Consumer subscribe(String topic, String subscription, ConsumerConfiguration conf) throws PulsarClientException {
        try {
            return this.subscribeAsync(topic, subscription, conf).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException((Throwable)e);
        }
    }
}

