/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.LinkedHashSet;
import org.apache.pulsar.client.admin.utils.ReflectionUtils;
import org.apache.pulsar.client.api.ProxyProtocol;

public interface ClusterData {
    public String getServiceUrl();

    public String getServiceUrlTls();

    public String getBrokerServiceUrl();

    public String getBrokerServiceUrlTls();

    public String getProxyServiceUrl();

    public ProxyProtocol getProxyProtocol();

    public LinkedHashSet<String> getPeerClusterNames();

    public String getAuthenticationPlugin();

    public String getAuthenticationParameters();

    public boolean isBrokerClientTlsEnabled();

    public boolean isTlsAllowInsecureConnection();

    public boolean isBrokerClientTlsEnabledWithKeyStore();

    public String getBrokerClientTlsTrustStoreType();

    public String getBrokerClientTlsTrustStore();

    public String getBrokerClientTlsTrustStorePassword();

    public String getBrokerClientTrustCertsFilePath();

    public String getBrokerClientCertificateFilePath();

    public String getBrokerClientKeyFilePath();

    public String getBrokerClientTlsKeyStoreType();

    public String getBrokerClientTlsKeyStorePassword();

    public String getBrokerClientTlsKeyStore();

    public String getListenerName();

    public boolean isMigrated();

    public ClusterUrl getMigratedClusterUrl();

    public Builder clone();

    public static Builder builder() {
        return (Builder)ReflectionUtils.newBuilder("org.apache.pulsar.common.policies.data.ClusterDataImpl");
    }

    public static interface Builder {
        public Builder serviceUrl(String var1);

        public Builder serviceUrlTls(String var1);

        public Builder brokerServiceUrl(String var1);

        public Builder brokerServiceUrlTls(String var1);

        public Builder proxyServiceUrl(String var1);

        public Builder proxyProtocol(ProxyProtocol var1);

        public Builder authenticationPlugin(String var1);

        public Builder authenticationParameters(String var1);

        public Builder peerClusterNames(LinkedHashSet<String> var1);

        public Builder brokerClientTlsEnabled(boolean var1);

        public Builder tlsAllowInsecureConnection(boolean var1);

        public Builder brokerClientTlsEnabledWithKeyStore(boolean var1);

        public Builder brokerClientTlsTrustStoreType(String var1);

        public Builder brokerClientTlsTrustStore(String var1);

        public Builder brokerClientTlsTrustStorePassword(String var1);

        public Builder brokerClientTrustCertsFilePath(String var1);

        public Builder brokerClientCertificateFilePath(String var1);

        public Builder brokerClientKeyFilePath(String var1);

        public Builder brokerClientTlsKeyStoreType(String var1);

        public Builder brokerClientTlsKeyStorePassword(String var1);

        public Builder brokerClientTlsKeyStore(String var1);

        public Builder listenerName(String var1);

        public Builder migrated(boolean var1);

        public Builder migratedClusterUrl(ClusterUrl var1);

        public ClusterData build();
    }

    public static class ClusterUrl {
        String brokerServiceUrl;
        String brokerServiceUrlTls;

        public boolean isEmpty() {
            return this.brokerServiceUrl == null && this.brokerServiceUrlTls == null;
        }

        public String getBrokerServiceUrl() {
            return this.brokerServiceUrl;
        }

        public String getBrokerServiceUrlTls() {
            return this.brokerServiceUrlTls;
        }

        public void setBrokerServiceUrl(String brokerServiceUrl) {
            this.brokerServiceUrl = brokerServiceUrl;
        }

        public void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
            this.brokerServiceUrlTls = brokerServiceUrlTls;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterUrl)) {
                return false;
            }
            ClusterUrl other = (ClusterUrl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$brokerServiceUrl = this.getBrokerServiceUrl();
            String other$brokerServiceUrl = other.getBrokerServiceUrl();
            if (this$brokerServiceUrl == null ? other$brokerServiceUrl != null : !this$brokerServiceUrl.equals(other$brokerServiceUrl)) {
                return false;
            }
            String this$brokerServiceUrlTls = this.getBrokerServiceUrlTls();
            String other$brokerServiceUrlTls = other.getBrokerServiceUrlTls();
            return !(this$brokerServiceUrlTls == null ? other$brokerServiceUrlTls != null : !this$brokerServiceUrlTls.equals(other$brokerServiceUrlTls));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClusterUrl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $brokerServiceUrl = this.getBrokerServiceUrl();
            result = result * 59 + ($brokerServiceUrl == null ? 43 : $brokerServiceUrl.hashCode());
            String $brokerServiceUrlTls = this.getBrokerServiceUrlTls();
            result = result * 59 + ($brokerServiceUrlTls == null ? 43 : $brokerServiceUrlTls.hashCode());
            return result;
        }

        public String toString() {
            return "ClusterData.ClusterUrl(brokerServiceUrl=" + this.getBrokerServiceUrl() + ", brokerServiceUrlTls=" + this.getBrokerServiceUrlTls() + ")";
        }

        public ClusterUrl() {
        }

        public ClusterUrl(String brokerServiceUrl, String brokerServiceUrlTls) {
            this.brokerServiceUrl = brokerServiceUrl;
            this.brokerServiceUrlTls = brokerServiceUrlTls;
        }
    }
}

