/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Schemas;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetAllVersionsSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.IsCompatibilityResponse;
import org.apache.pulsar.common.protocol.schema.LongSchemaVersionResponse;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaInfoWithVersion;
import org.apache.pulsar.common.schema.SchemaType;

public class SchemasImpl
extends BaseResource
implements Schemas {
    private final WebTarget adminV2;
    private final WebTarget adminV1;

    public SchemasImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminV1 = web.path("/admin/schemas");
        this.adminV2 = web.path("/admin/v2/schemas");
    }

    public SchemaInfo getSchemaInfo(String topic) throws PulsarAdminException {
        try {
            return this.getSchemaInfoAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<SchemaInfo> getSchemaInfoAsync(String topic) {
        final TopicName tn = TopicName.get((String)topic);
        final CompletableFuture<SchemaInfo> future = new CompletableFuture<SchemaInfo>();
        this.asyncGetRequest(this.schemaPath(tn), new InvocationCallback<GetSchemaResponse>(){

            public void completed(GetSchemaResponse response) {
                future.complete(SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response));
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(SchemasImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public SchemaInfoWithVersion getSchemaInfoWithVersion(String topic) throws PulsarAdminException {
        try {
            return this.getSchemaInfoWithVersionAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<SchemaInfoWithVersion> getSchemaInfoWithVersionAsync(String topic) {
        final TopicName tn = TopicName.get((String)topic);
        final CompletableFuture<SchemaInfoWithVersion> future = new CompletableFuture<SchemaInfoWithVersion>();
        this.asyncGetRequest(this.schemaPath(tn), new InvocationCallback<GetSchemaResponse>(){

            public void completed(GetSchemaResponse response) {
                future.complete(SchemasImpl.convertGetSchemaResponseToSchemaInfoWithVersion(tn, response));
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(SchemasImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public SchemaInfo getSchemaInfo(String topic, long version) throws PulsarAdminException {
        try {
            return this.getSchemaInfoAsync(topic, version).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<SchemaInfo> getSchemaInfoAsync(String topic, long version) {
        final TopicName tn = TopicName.get((String)topic);
        WebTarget path = this.schemaPath(tn).path(Long.toString(version));
        final CompletableFuture<SchemaInfo> future = new CompletableFuture<SchemaInfo>();
        this.asyncGetRequest(path, new InvocationCallback<GetSchemaResponse>(){

            public void completed(GetSchemaResponse response) {
                future.complete(SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response));
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(SchemasImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void deleteSchema(String topic) throws PulsarAdminException {
        try {
            this.deleteSchemaAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteSchemaAsync(String topic) {
        TopicName tn = TopicName.get((String)topic);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(this.schemaPath(tn)).async().delete((InvocationCallback)new InvocationCallback<DeleteSchemaResponse>(){

                public void completed(DeleteSchemaResponse deleteSchemaResponse) {
                    future.complete(null);
                }

                public void failed(Throwable throwable) {
                    future.completeExceptionally(SchemasImpl.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public void createSchema(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        this.createSchema(topic, SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo));
    }

    public CompletableFuture<Void> createSchemaAsync(String topic, SchemaInfo schemaInfo) {
        return this.createSchemaAsync(topic, SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo));
    }

    public void createSchema(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        try {
            this.createSchemaAsync(topic, payload).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createSchemaAsync(String topic, PostSchemaPayload payload) {
        TopicName tn = TopicName.get((String)topic);
        return this.asyncPostRequest(this.schemaPath(tn), Entity.json((Object)payload));
    }

    public IsCompatibilityResponse testCompatibility(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        try {
            return this.testCompatibilityAsync(topic, payload).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<IsCompatibilityResponse> testCompatibilityAsync(String topic, PostSchemaPayload payload) {
        TopicName tn = TopicName.get((String)topic);
        final CompletableFuture<IsCompatibilityResponse> future = new CompletableFuture<IsCompatibilityResponse>();
        try {
            this.request(this.compatibilityPath(tn)).async().post(Entity.json((Object)payload), (InvocationCallback)new InvocationCallback<IsCompatibilityResponse>(){

                public void completed(IsCompatibilityResponse isCompatibilityResponse) {
                    future.complete(isCompatibilityResponse);
                }

                public void failed(Throwable throwable) {
                    future.completeExceptionally(SchemasImpl.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public Long getVersionBySchema(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        try {
            return this.getVersionBySchemaAsync(topic, payload).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Long> getVersionBySchemaAsync(String topic, PostSchemaPayload payload) {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            this.request(this.versionPath(TopicName.get((String)topic))).async().post(Entity.json((Object)payload), (InvocationCallback)new InvocationCallback<LongSchemaVersionResponse>(){

                public void completed(LongSchemaVersionResponse longSchemaVersionResponse) {
                    future.complete(longSchemaVersionResponse.getVersion());
                }

                public void failed(Throwable throwable) {
                    future.completeExceptionally(SchemasImpl.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public IsCompatibilityResponse testCompatibility(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        try {
            return this.testCompatibilityAsync(topic, schemaInfo).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<IsCompatibilityResponse> testCompatibilityAsync(String topic, SchemaInfo schemaInfo) {
        final CompletableFuture<IsCompatibilityResponse> future = new CompletableFuture<IsCompatibilityResponse>();
        try {
            this.request(this.compatibilityPath(TopicName.get((String)topic))).async().post(Entity.json((Object)SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo)), (InvocationCallback)new InvocationCallback<IsCompatibilityResponse>(){

                public void completed(IsCompatibilityResponse isCompatibilityResponse) {
                    future.complete(isCompatibilityResponse);
                }

                public void failed(Throwable throwable) {
                    future.completeExceptionally(SchemasImpl.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public Long getVersionBySchema(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        try {
            return this.getVersionBySchemaAsync(topic, schemaInfo).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Long> getVersionBySchemaAsync(String topic, SchemaInfo schemaInfo) {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            this.request(this.versionPath(TopicName.get((String)topic))).async().post(Entity.json((Object)SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo)), (InvocationCallback)new InvocationCallback<LongSchemaVersionResponse>(){

                public void completed(LongSchemaVersionResponse longSchemaVersionResponse) {
                    future.complete(longSchemaVersionResponse.getVersion());
                }

                public void failed(Throwable throwable) {
                    future.completeExceptionally(SchemasImpl.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public List<SchemaInfo> getAllSchemas(String topic) throws PulsarAdminException {
        try {
            return this.getAllSchemasAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<SchemaInfo>> getAllSchemasAsync(String topic) {
        WebTarget path = this.schemasPath(TopicName.get((String)topic));
        final TopicName topicName = TopicName.get((String)topic);
        final CompletableFuture<List<SchemaInfo>> future = new CompletableFuture<List<SchemaInfo>>();
        this.asyncGetRequest(path, new InvocationCallback<GetAllVersionsSchemaResponse>(){

            public void completed(GetAllVersionsSchemaResponse response) {
                future.complete(response.getGetSchemaResponses().stream().map(getSchemaResponse -> SchemasImpl.convertGetSchemaResponseToSchemaInfo(topicName, getSchemaResponse)).collect(Collectors.toList()));
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(SchemasImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    private WebTarget schemaPath(TopicName topicName) {
        return this.topicPath(topicName, "schema");
    }

    private WebTarget versionPath(TopicName topicName) {
        return this.topicPath(topicName, "version");
    }

    private WebTarget schemasPath(TopicName topicName) {
        return this.topicPath(topicName, "schemas");
    }

    private WebTarget compatibilityPath(TopicName topicName) {
        return this.topicPath(topicName, "compatibility");
    }

    private WebTarget topicPath(TopicName topic, String ... parts) {
        WebTarget base = topic.isV2() ? this.adminV2 : this.adminV1;
        WebTarget topicPath = base.path(topic.getRestPath(false));
        topicPath = WebTargets.addParts(topicPath, parts);
        return topicPath;
    }

    static SchemaInfo convertGetSchemaResponseToSchemaInfo(TopicName tn, GetSchemaResponse response) {
        byte[] schema = response.getType() == SchemaType.KEY_VALUE ? DefaultImplementation.convertKeyValueDataStringToSchemaInfoSchema((byte[])response.getData().getBytes(StandardCharsets.UTF_8)) : response.getData().getBytes(StandardCharsets.UTF_8);
        return SchemaInfoImpl.builder().schema(schema).type(response.getType()).properties(response.getProperties()).name(tn.getLocalName()).build();
    }

    static SchemaInfoWithVersion convertGetSchemaResponseToSchemaInfoWithVersion(TopicName tn, GetSchemaResponse response) {
        return SchemaInfoWithVersion.builder().schemaInfo(SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response)).version(response.getVersion()).build();
    }

    static String convertSchemaDataToStringLegacy(SchemaInfo schemaInfo) {
        byte[] schemaData = schemaInfo.getSchema();
        if (null == schemaInfo.getSchema()) {
            return "";
        }
        if (schemaInfo.getType() == SchemaType.KEY_VALUE) {
            return DefaultImplementation.convertKeyValueSchemaInfoDataToString((KeyValue)DefaultImplementation.decodeKeyValueSchemaInfo((SchemaInfo)schemaInfo));
        }
        return new String(schemaData, StandardCharsets.UTF_8);
    }

    static PostSchemaPayload convertSchemaInfoToPostSchemaPayload(SchemaInfo schemaInfo) {
        PostSchemaPayload payload = new PostSchemaPayload();
        payload.setType(schemaInfo.getType().name());
        payload.setProperties(schemaInfo.getProperties());
        payload.setSchema(SchemasImpl.convertSchemaDataToStringLegacy(schemaInfo));
        return payload;
    }
}

