/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;

class LastCumulativeAck {
    public static final FastThreadLocal<LastCumulativeAck> LOCAL_LAST_CUMULATIVE_ACK = new FastThreadLocal<LastCumulativeAck>(){

        @Override
        protected LastCumulativeAck initialValue() {
            return new LastCumulativeAck();
        }
    };
    public static final MessageIdImpl DEFAULT_MESSAGE_ID = (MessageIdImpl)MessageIdImpl.earliest;
    private volatile MessageIdImpl messageId = DEFAULT_MESSAGE_ID;
    private BitSetRecyclable bitSetRecyclable = null;
    private boolean flushRequired = false;

    LastCumulativeAck() {
    }

    public synchronized void update(MessageIdImpl messageId, BitSetRecyclable bitSetRecyclable) {
        if (messageId.compareTo(this.messageId) > 0) {
            if (this.bitSetRecyclable != null && this.bitSetRecyclable != bitSetRecyclable) {
                this.bitSetRecyclable.recycle();
            }
            this.set(messageId, bitSetRecyclable);
            this.flushRequired = true;
        }
    }

    public synchronized LastCumulativeAck flush() {
        if (this.flushRequired) {
            LastCumulativeAck localLastCumulativeAck = LOCAL_LAST_CUMULATIVE_ACK.get();
            if (this.bitSetRecyclable != null) {
                localLastCumulativeAck.set(this.messageId, BitSetRecyclable.valueOf(this.bitSetRecyclable.toLongArray()));
            } else {
                localLastCumulativeAck.set(this.messageId, null);
            }
            this.flushRequired = false;
            return localLastCumulativeAck;
        }
        return null;
    }

    public synchronized void reset() {
        if (this.bitSetRecyclable != null) {
            this.bitSetRecyclable.recycle();
        }
        this.messageId = DEFAULT_MESSAGE_ID;
        this.bitSetRecyclable = null;
        this.flushRequired = false;
    }

    private synchronized void set(MessageIdImpl messageId, BitSetRecyclable bitSetRecyclable) {
        this.messageId = messageId;
        this.bitSetRecyclable = bitSetRecyclable;
    }

    public String toString() {
        String s = this.messageId.toString();
        if (this.bitSetRecyclable != null) {
            s = s + " (bit set: " + this.bitSetRecyclable + ")";
        }
        return s;
    }

    public MessageIdImpl getMessageId() {
        return this.messageId;
    }

    public BitSetRecyclable getBitSetRecyclable() {
        return this.bitSetRecyclable;
    }

    public boolean isFlushRequired() {
        return this.flushRequired;
    }
}

