/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Schemas;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetAllVersionsSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.IsCompatibilityResponse;
import org.apache.pulsar.common.protocol.schema.LongSchemaVersionResponse;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaInfoWithVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class SchemasImpl
extends BaseResource
implements Schemas {
    private final WebTarget target;

    public SchemasImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.target = web.path("/admin/v2/schemas");
    }

    @Override
    public SchemaInfo getSchemaInfo(String topic) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            GetSchemaResponse response = this.request(this.schemaPath(tn)).get(GetSchemaResponse.class);
            return SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SchemaInfoWithVersion getSchemaInfoWithVersion(String topic) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            GetSchemaResponse response = this.request(this.schemaPath(tn)).get(GetSchemaResponse.class);
            return SchemasImpl.convertGetSchemaResponseToSchemaInfoWithVersion(tn, response);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SchemaInfo getSchemaInfo(String topic, long version) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            GetSchemaResponse response = this.request(this.schemaPath(tn).path(Long.toString(version))).get(GetSchemaResponse.class);
            return SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteSchema(String topic) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            this.request(this.schemaPath(tn)).delete(DeleteSchemaResponse.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createSchema(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        this.createSchema(topic, SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo));
    }

    @Override
    public void createSchema(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            this.request(this.schemaPath(tn)).post(Entity.json(payload), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public IsCompatibilityResponse testCompatibility(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            return this.request(this.compatibilityPath(tn)).post(Entity.json(payload), IsCompatibilityResponse.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Long getVersionBySchema(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        try {
            return this.request(this.versionPath(TopicName.get(topic))).post(Entity.json(payload), LongSchemaVersionResponse.class).getVersion();
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public IsCompatibilityResponse testCompatibility(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        try {
            return this.request(this.compatibilityPath(TopicName.get(topic))).post(Entity.json(SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo)), IsCompatibilityResponse.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Long getVersionBySchema(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        try {
            return this.request(this.versionPath(TopicName.get(topic))).post(Entity.json(SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo)), LongSchemaVersionResponse.class).getVersion();
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<SchemaInfo> getAllSchemas(String topic) throws PulsarAdminException {
        try {
            TopicName topicName = TopicName.get(topic);
            return this.request(this.schemasPath(TopicName.get(topic))).get(GetAllVersionsSchemaResponse.class).getGetSchemaResponses().stream().map(getSchemaResponse -> SchemasImpl.convertGetSchemaResponseToSchemaInfo(topicName, getSchemaResponse)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    private WebTarget schemaPath(TopicName topicName) {
        return this.target.path(topicName.getTenant()).path(topicName.getNamespacePortion()).path(topicName.getEncodedLocalName()).path("schema");
    }

    private WebTarget versionPath(TopicName topicName) {
        return this.target.path(topicName.getTenant()).path(topicName.getNamespacePortion()).path(topicName.getEncodedLocalName()).path("version");
    }

    private WebTarget schemasPath(TopicName topicName) {
        return this.target.path(topicName.getTenant()).path(topicName.getNamespacePortion()).path(topicName.getEncodedLocalName()).path("schemas");
    }

    private WebTarget compatibilityPath(TopicName topicName) {
        return this.target.path(topicName.getTenant()).path(topicName.getNamespacePortion()).path(topicName.getEncodedLocalName()).path("compatibility");
    }

    static SchemaInfo convertGetSchemaResponseToSchemaInfo(TopicName tn, GetSchemaResponse response) {
        SchemaInfo info = new SchemaInfo();
        byte[] schema = response.getType() == SchemaType.KEY_VALUE ? DefaultImplementation.convertKeyValueDataStringToSchemaInfoSchema((byte[])response.getData().getBytes(StandardCharsets.UTF_8)) : response.getData().getBytes(StandardCharsets.UTF_8);
        info.setSchema(schema);
        info.setType(response.getType());
        info.setProperties(response.getProperties());
        info.setName(tn.getLocalName());
        return info;
    }

    static SchemaInfoWithVersion convertGetSchemaResponseToSchemaInfoWithVersion(TopicName tn, GetSchemaResponse response) {
        return SchemaInfoWithVersion.builder().schemaInfo(SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response)).version(response.getVersion()).build();
    }

    static String convertSchemaDataToStringLegacy(byte[] schemaData) {
        if (null == schemaData) {
            return "";
        }
        return new String(schemaData, StandardCharsets.UTF_8);
    }

    static PostSchemaPayload convertSchemaInfoToPostSchemaPayload(SchemaInfo schemaInfo) {
        PostSchemaPayload payload = new PostSchemaPayload();
        payload.setType(schemaInfo.getType().name());
        payload.setProperties(schemaInfo.getProperties());
        payload.setSchema(SchemasImpl.convertSchemaDataToStringLegacy(schemaInfo.getSchema()));
        return payload;
    }
}

