/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.com.google.common.collect.Sets;

public class ProducerConfigurationData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String topicName = null;
    private String producerName = null;
    private long sendTimeoutMs = 30000L;
    private boolean blockIfQueueFull = false;
    private int maxPendingMessages = 1000;
    private int maxPendingMessagesAcrossPartitions = 50000;
    private MessageRoutingMode messageRoutingMode = null;
    private HashingScheme hashingScheme = HashingScheme.JavaStringHash;
    private ProducerCryptoFailureAction cryptoFailureAction = ProducerCryptoFailureAction.FAIL;
    @JsonIgnore
    private MessageRouter customMessageRouter = null;
    private long batchingMaxPublishDelayMicros = TimeUnit.MILLISECONDS.toMicros(1L);
    private int batchingMaxMessages = 1000;
    private boolean batchingEnabled = true;
    @JsonIgnore
    private BatcherBuilder batcherBuilder = BatcherBuilder.DEFAULT;
    @JsonIgnore
    private CryptoKeyReader cryptoKeyReader;
    @JsonIgnore
    private Set<String> encryptionKeys = new TreeSet<String>();
    private CompressionType compressionType = CompressionType.NONE;
    private Long initialSequenceId = null;
    private boolean autoUpdatePartitions = true;
    private SortedMap<String, String> properties = new TreeMap<String, String>();

    @JsonIgnore
    public boolean isEncryptionEnabled() {
        return this.encryptionKeys != null && !this.encryptionKeys.isEmpty() && this.cryptoKeyReader != null;
    }

    public ProducerConfigurationData clone() {
        try {
            ProducerConfigurationData c = (ProducerConfigurationData)super.clone();
            c.encryptionKeys = Sets.newTreeSet(this.encryptionKeys);
            c.properties = Maps.newTreeMap(this.properties);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ProducerConfigurationData", e);
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public long getSendTimeoutMs() {
        return this.sendTimeoutMs;
    }

    public boolean isBlockIfQueueFull() {
        return this.blockIfQueueFull;
    }

    public int getMaxPendingMessages() {
        return this.maxPendingMessages;
    }

    public int getMaxPendingMessagesAcrossPartitions() {
        return this.maxPendingMessagesAcrossPartitions;
    }

    public MessageRoutingMode getMessageRoutingMode() {
        return this.messageRoutingMode;
    }

    public HashingScheme getHashingScheme() {
        return this.hashingScheme;
    }

    public ProducerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public MessageRouter getCustomMessageRouter() {
        return this.customMessageRouter;
    }

    public long getBatchingMaxPublishDelayMicros() {
        return this.batchingMaxPublishDelayMicros;
    }

    public int getBatchingMaxMessages() {
        return this.batchingMaxMessages;
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public BatcherBuilder getBatcherBuilder() {
        return this.batcherBuilder;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public Set<String> getEncryptionKeys() {
        return this.encryptionKeys;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public Long getInitialSequenceId() {
        return this.initialSequenceId;
    }

    public boolean isAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public void setSendTimeoutMs(long sendTimeoutMs) {
        this.sendTimeoutMs = sendTimeoutMs;
    }

    public void setBlockIfQueueFull(boolean blockIfQueueFull) {
        this.blockIfQueueFull = blockIfQueueFull;
    }

    public void setMaxPendingMessages(int maxPendingMessages) {
        this.maxPendingMessages = maxPendingMessages;
    }

    public void setMaxPendingMessagesAcrossPartitions(int maxPendingMessagesAcrossPartitions) {
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
    }

    public void setMessageRoutingMode(MessageRoutingMode messageRoutingMode) {
        this.messageRoutingMode = messageRoutingMode;
    }

    public void setHashingScheme(HashingScheme hashingScheme) {
        this.hashingScheme = hashingScheme;
    }

    public void setCryptoFailureAction(ProducerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public void setCustomMessageRouter(MessageRouter customMessageRouter) {
        this.customMessageRouter = customMessageRouter;
    }

    public void setBatchingMaxPublishDelayMicros(long batchingMaxPublishDelayMicros) {
        this.batchingMaxPublishDelayMicros = batchingMaxPublishDelayMicros;
    }

    public void setBatchingMaxMessages(int batchingMaxMessages) {
        this.batchingMaxMessages = batchingMaxMessages;
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    public void setBatcherBuilder(BatcherBuilder batcherBuilder) {
        this.batcherBuilder = batcherBuilder;
    }

    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    public void setEncryptionKeys(Set<String> encryptionKeys) {
        this.encryptionKeys = encryptionKeys;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public void setInitialSequenceId(Long initialSequenceId) {
        this.initialSequenceId = initialSequenceId;
    }

    public void setAutoUpdatePartitions(boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    public void setProperties(SortedMap<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerConfigurationData)) {
            return false;
        }
        ProducerConfigurationData other = (ProducerConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        String this$producerName = this.getProducerName();
        String other$producerName = other.getProducerName();
        if (this$producerName == null ? other$producerName != null : !this$producerName.equals(other$producerName)) {
            return false;
        }
        if (this.getSendTimeoutMs() != other.getSendTimeoutMs()) {
            return false;
        }
        if (this.isBlockIfQueueFull() != other.isBlockIfQueueFull()) {
            return false;
        }
        if (this.getMaxPendingMessages() != other.getMaxPendingMessages()) {
            return false;
        }
        if (this.getMaxPendingMessagesAcrossPartitions() != other.getMaxPendingMessagesAcrossPartitions()) {
            return false;
        }
        MessageRoutingMode this$messageRoutingMode = this.getMessageRoutingMode();
        MessageRoutingMode other$messageRoutingMode = other.getMessageRoutingMode();
        if (this$messageRoutingMode == null ? other$messageRoutingMode != null : !this$messageRoutingMode.equals(other$messageRoutingMode)) {
            return false;
        }
        HashingScheme this$hashingScheme = this.getHashingScheme();
        HashingScheme other$hashingScheme = other.getHashingScheme();
        if (this$hashingScheme == null ? other$hashingScheme != null : !this$hashingScheme.equals(other$hashingScheme)) {
            return false;
        }
        ProducerCryptoFailureAction this$cryptoFailureAction = this.getCryptoFailureAction();
        ProducerCryptoFailureAction other$cryptoFailureAction = other.getCryptoFailureAction();
        if (this$cryptoFailureAction == null ? other$cryptoFailureAction != null : !this$cryptoFailureAction.equals(other$cryptoFailureAction)) {
            return false;
        }
        MessageRouter this$customMessageRouter = this.getCustomMessageRouter();
        MessageRouter other$customMessageRouter = other.getCustomMessageRouter();
        if (this$customMessageRouter == null ? other$customMessageRouter != null : !this$customMessageRouter.equals(other$customMessageRouter)) {
            return false;
        }
        if (this.getBatchingMaxPublishDelayMicros() != other.getBatchingMaxPublishDelayMicros()) {
            return false;
        }
        if (this.getBatchingMaxMessages() != other.getBatchingMaxMessages()) {
            return false;
        }
        if (this.isBatchingEnabled() != other.isBatchingEnabled()) {
            return false;
        }
        BatcherBuilder this$batcherBuilder = this.getBatcherBuilder();
        BatcherBuilder other$batcherBuilder = other.getBatcherBuilder();
        if (this$batcherBuilder == null ? other$batcherBuilder != null : !this$batcherBuilder.equals(other$batcherBuilder)) {
            return false;
        }
        CryptoKeyReader this$cryptoKeyReader = this.getCryptoKeyReader();
        CryptoKeyReader other$cryptoKeyReader = other.getCryptoKeyReader();
        if (this$cryptoKeyReader == null ? other$cryptoKeyReader != null : !this$cryptoKeyReader.equals(other$cryptoKeyReader)) {
            return false;
        }
        Set<String> this$encryptionKeys = this.getEncryptionKeys();
        Set<String> other$encryptionKeys = other.getEncryptionKeys();
        if (this$encryptionKeys == null ? other$encryptionKeys != null : !((Object)this$encryptionKeys).equals(other$encryptionKeys)) {
            return false;
        }
        CompressionType this$compressionType = this.getCompressionType();
        CompressionType other$compressionType = other.getCompressionType();
        if (this$compressionType == null ? other$compressionType != null : !this$compressionType.equals(other$compressionType)) {
            return false;
        }
        Long this$initialSequenceId = this.getInitialSequenceId();
        Long other$initialSequenceId = other.getInitialSequenceId();
        if (this$initialSequenceId == null ? other$initialSequenceId != null : !((Object)this$initialSequenceId).equals(other$initialSequenceId)) {
            return false;
        }
        if (this.isAutoUpdatePartitions() != other.isAutoUpdatePartitions()) {
            return false;
        }
        SortedMap<String, String> this$properties = this.getProperties();
        SortedMap<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProducerConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        String $producerName = this.getProducerName();
        result = result * 59 + ($producerName == null ? 43 : $producerName.hashCode());
        long $sendTimeoutMs = this.getSendTimeoutMs();
        result = result * 59 + (int)($sendTimeoutMs >>> 32 ^ $sendTimeoutMs);
        result = result * 59 + (this.isBlockIfQueueFull() ? 79 : 97);
        result = result * 59 + this.getMaxPendingMessages();
        result = result * 59 + this.getMaxPendingMessagesAcrossPartitions();
        MessageRoutingMode $messageRoutingMode = this.getMessageRoutingMode();
        result = result * 59 + ($messageRoutingMode == null ? 43 : $messageRoutingMode.hashCode());
        HashingScheme $hashingScheme = this.getHashingScheme();
        result = result * 59 + ($hashingScheme == null ? 43 : $hashingScheme.hashCode());
        ProducerCryptoFailureAction $cryptoFailureAction = this.getCryptoFailureAction();
        result = result * 59 + ($cryptoFailureAction == null ? 43 : $cryptoFailureAction.hashCode());
        MessageRouter $customMessageRouter = this.getCustomMessageRouter();
        result = result * 59 + ($customMessageRouter == null ? 43 : $customMessageRouter.hashCode());
        long $batchingMaxPublishDelayMicros = this.getBatchingMaxPublishDelayMicros();
        result = result * 59 + (int)($batchingMaxPublishDelayMicros >>> 32 ^ $batchingMaxPublishDelayMicros);
        result = result * 59 + this.getBatchingMaxMessages();
        result = result * 59 + (this.isBatchingEnabled() ? 79 : 97);
        BatcherBuilder $batcherBuilder = this.getBatcherBuilder();
        result = result * 59 + ($batcherBuilder == null ? 43 : $batcherBuilder.hashCode());
        CryptoKeyReader $cryptoKeyReader = this.getCryptoKeyReader();
        result = result * 59 + ($cryptoKeyReader == null ? 43 : $cryptoKeyReader.hashCode());
        Set<String> $encryptionKeys = this.getEncryptionKeys();
        result = result * 59 + ($encryptionKeys == null ? 43 : ((Object)$encryptionKeys).hashCode());
        CompressionType $compressionType = this.getCompressionType();
        result = result * 59 + ($compressionType == null ? 43 : $compressionType.hashCode());
        Long $initialSequenceId = this.getInitialSequenceId();
        result = result * 59 + ($initialSequenceId == null ? 43 : ((Object)$initialSequenceId).hashCode());
        result = result * 59 + (this.isAutoUpdatePartitions() ? 79 : 97);
        SortedMap<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    public String toString() {
        return "ProducerConfigurationData(topicName=" + this.getTopicName() + ", producerName=" + this.getProducerName() + ", sendTimeoutMs=" + this.getSendTimeoutMs() + ", blockIfQueueFull=" + this.isBlockIfQueueFull() + ", maxPendingMessages=" + this.getMaxPendingMessages() + ", maxPendingMessagesAcrossPartitions=" + this.getMaxPendingMessagesAcrossPartitions() + ", messageRoutingMode=" + this.getMessageRoutingMode() + ", hashingScheme=" + this.getHashingScheme() + ", cryptoFailureAction=" + this.getCryptoFailureAction() + ", customMessageRouter=" + this.getCustomMessageRouter() + ", batchingMaxPublishDelayMicros=" + this.getBatchingMaxPublishDelayMicros() + ", batchingMaxMessages=" + this.getBatchingMaxMessages() + ", batchingEnabled=" + this.isBatchingEnabled() + ", batcherBuilder=" + this.getBatcherBuilder() + ", cryptoKeyReader=" + this.getCryptoKeyReader() + ", encryptionKeys=" + this.getEncryptionKeys() + ", compressionType=" + this.getCompressionType() + ", initialSequenceId=" + this.getInitialSequenceId() + ", autoUpdatePartitions=" + this.isAutoUpdatePartitions() + ", properties=" + this.getProperties() + ")";
    }

    public ProducerConfigurationData() {
    }

    public ProducerConfigurationData(String topicName, String producerName, long sendTimeoutMs, boolean blockIfQueueFull, int maxPendingMessages, int maxPendingMessagesAcrossPartitions, MessageRoutingMode messageRoutingMode, HashingScheme hashingScheme, ProducerCryptoFailureAction cryptoFailureAction, MessageRouter customMessageRouter, long batchingMaxPublishDelayMicros, int batchingMaxMessages, boolean batchingEnabled, BatcherBuilder batcherBuilder, CryptoKeyReader cryptoKeyReader, Set<String> encryptionKeys, CompressionType compressionType, Long initialSequenceId, boolean autoUpdatePartitions, SortedMap<String, String> properties) {
        this.topicName = topicName;
        this.producerName = producerName;
        this.sendTimeoutMs = sendTimeoutMs;
        this.blockIfQueueFull = blockIfQueueFull;
        this.maxPendingMessages = maxPendingMessages;
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
        this.messageRoutingMode = messageRoutingMode;
        this.hashingScheme = hashingScheme;
        this.cryptoFailureAction = cryptoFailureAction;
        this.customMessageRouter = customMessageRouter;
        this.batchingMaxPublishDelayMicros = batchingMaxPublishDelayMicros;
        this.batchingMaxMessages = batchingMaxMessages;
        this.batchingEnabled = batchingEnabled;
        this.batcherBuilder = batcherBuilder;
        this.cryptoKeyReader = cryptoKeyReader;
        this.encryptionKeys = encryptionKeys;
        this.compressionType = compressionType;
        this.initialSequenceId = initialSequenceId;
        this.autoUpdatePartitions = autoUpdatePartitions;
        this.properties = properties;
    }
}

