/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.pulsar.client.api.schema.FieldSchemaBuilder;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.api.schema.RecordSchemaBuilder;
import org.apache.pulsar.client.impl.schema.FieldSchemaBuilderImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class RecordSchemaBuilderImpl
implements RecordSchemaBuilder {
    public static final String NAMESPACE = "org.apache.pulsar.schema.record";
    public static final String DEFAULT_SCHEMA_NAME = "PulsarDefault";
    private final String name;
    private final Map<String, String> properties;
    private final List<FieldSchemaBuilderImpl> fields = new ArrayList<FieldSchemaBuilderImpl>();
    private String doc;

    public RecordSchemaBuilderImpl(String name) {
        this.name = name;
        this.properties = new HashMap<String, String>();
    }

    public RecordSchemaBuilder property(String name, String val) {
        this.properties.put(name, val);
        return this;
    }

    public FieldSchemaBuilder field(String fieldName) {
        FieldSchemaBuilderImpl field = new FieldSchemaBuilderImpl(fieldName);
        this.fields.add(field);
        return field;
    }

    public FieldSchemaBuilder field(String fieldName, GenericSchema genericSchema) {
        FieldSchemaBuilderImpl field = new FieldSchemaBuilderImpl(fieldName, genericSchema);
        this.fields.add(field);
        return field;
    }

    public RecordSchemaBuilder doc(String doc) {
        this.doc = doc;
        return this;
    }

    public SchemaInfo build(SchemaType schemaType) {
        switch (schemaType) {
            case JSON: 
            case AVRO: {
                break;
            }
            default: {
                throw new RuntimeException("Currently only AVRO and JSON record schema is supported");
            }
        }
        String schemaNs = NAMESPACE;
        String schemaName = DEFAULT_SCHEMA_NAME;
        if (this.name != null) {
            String[] split = RecordSchemaBuilderImpl.splitName(this.name);
            schemaNs = split[0];
            schemaName = split[1];
        }
        Schema baseSchema = Schema.createRecord((String)(schemaName != null ? schemaName : DEFAULT_SCHEMA_NAME), (String)this.doc, (String)schemaNs, (boolean)false);
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (FieldSchemaBuilderImpl field : this.fields) {
            avroFields.add(field.build());
        }
        baseSchema.setFields(avroFields);
        return new SchemaInfo(this.name, baseSchema.toString().getBytes(StandardCharsets.UTF_8), schemaType, this.properties);
    }

    private static String[] splitName(String fullName) {
        String[] result = new String[2];
        int indexLastDot = fullName.lastIndexOf(46);
        if (indexLastDot >= 0) {
            result[0] = fullName.substring(0, indexLastDot);
            result[1] = fullName.substring(indexLastDot + 1);
        } else {
            result[0] = null;
            result[1] = fullName;
        }
        return result;
    }
}

