/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import org.apache.pulsar.client.admin.BrokerStats;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.stats.AllocatorStats;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.com.google.gson.JsonArray;
import org.apache.pulsar.shade.com.google.gson.JsonObject;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;

public class BrokerStatsImpl
extends BaseResource
implements BrokerStats {
    private final WebTarget adminBrokerStats;
    private final WebTarget adminV2BrokerStats;

    public BrokerStatsImpl(WebTarget target, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminBrokerStats = target.path("/admin/broker-stats");
        this.adminV2BrokerStats = target.path("/admin/v2/broker-stats");
    }

    @Override
    public JsonArray getMetrics() throws PulsarAdminException {
        try {
            String json = this.request(this.adminV2BrokerStats.path("/metrics")).get(String.class);
            return new Gson().fromJson(json, JsonArray.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public AllocatorStats getAllocatorStats(String allocatorName) throws PulsarAdminException {
        try {
            return this.request(this.adminV2BrokerStats.path("/allocator-stats").path(allocatorName)).get(AllocatorStats.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public JsonArray getMBeans() throws PulsarAdminException {
        try {
            String json = this.request(this.adminV2BrokerStats.path("/mbeans")).get(String.class);
            return new Gson().fromJson(json, JsonArray.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public JsonObject getTopics() throws PulsarAdminException {
        try {
            String json = this.request(this.adminV2BrokerStats.path("/topics")).get(String.class);
            return new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public LoadManagerReport getLoadReport() throws PulsarAdminException {
        try {
            return this.request(this.adminV2BrokerStats.path("/load-report")).get(LocalBrokerData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public JsonObject getPendingBookieOpsStats() throws PulsarAdminException {
        try {
            String json = this.request(this.adminV2BrokerStats.path("/bookieops")).get(String.class);
            return new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public JsonObject getBrokerResourceAvailability(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget admin = ns.isV2() ? this.adminV2BrokerStats : this.adminBrokerStats;
            String json = this.request(admin.path("/broker-resource-availability").path(ns.toString())).get(String.class);
            return new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

