/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.client.admin.Clusters;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;

public class ClustersImpl
extends BaseResource
implements Clusters {
    private final WebTarget adminClusters;

    public ClustersImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminClusters = web.path("/admin/v2/clusters");
    }

    @Override
    public List<String> getClusters() throws PulsarAdminException {
        try {
            return this.request(this.adminClusters).get(new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public ClusterData getCluster(String cluster) throws PulsarAdminException {
        try {
            return this.request(this.adminClusters.path(cluster)).get(ClusterData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        try {
            this.request(this.adminClusters.path(cluster)).put(Entity.entity(clusterData, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        try {
            this.request(this.adminClusters.path(cluster)).post(Entity.entity(clusterData, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updatePeerClusterNames(String cluster, LinkedHashSet<String> peerClusterNames) throws PulsarAdminException {
        try {
            this.request(this.adminClusters.path(cluster).path("peers")).post(Entity.entity(peerClusterNames, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Set<String> getPeerClusterNames(String cluster) throws PulsarAdminException {
        try {
            return this.request(this.adminClusters.path(cluster).path("peers")).get(LinkedHashSet.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteCluster(String cluster) throws PulsarAdminException {
        try {
            this.request(this.adminClusters.path(cluster)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Map<String, NamespaceIsolationData> getNamespaceIsolationPolicies(String cluster) throws PulsarAdminException {
        try {
            return this.request(this.adminClusters.path(cluster).path("namespaceIsolationPolicies")).get(new GenericType<Map<String, NamespaceIsolationData>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<BrokerNamespaceIsolationData> getBrokersWithNamespaceIsolationPolicy(String cluster) throws PulsarAdminException {
        try {
            return this.request(this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers")).get(new GenericType<List<BrokerNamespaceIsolationData>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public BrokerNamespaceIsolationData getBrokerWithNamespaceIsolationPolicy(String cluster, String broker) throws PulsarAdminException {
        try {
            return this.request(this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers").path(broker)).get(BrokerNamespaceIsolationData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public void updateNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public void deleteNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        this.request(this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName)).delete(ErrorData.class);
    }

    private void setNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        try {
            this.request(this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName)).post(Entity.entity(namespaceIsolationData, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public NamespaceIsolationData getNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        try {
            return this.request(this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName)).get(NamespaceIsolationData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    @Override
    public void updateFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    @Override
    public void deleteFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        this.request(this.adminClusters.path(cluster).path("failureDomains").path(domainName)).delete(ErrorData.class);
    }

    @Override
    public Map<String, FailureDomain> getFailureDomains(String cluster) throws PulsarAdminException {
        try {
            return this.request(this.adminClusters.path(cluster).path("failureDomains")).get(new GenericType<Map<String, FailureDomain>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public FailureDomain getFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        try {
            return this.request(this.adminClusters.path(cluster).path("failureDomains").path(domainName)).get(FailureDomain.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    private void setDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        try {
            this.request(this.adminClusters.path(cluster).path("failureDomains").path(domainName)).post(Entity.entity(domain, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

