/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.File;
import java.util.List;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Sink;
import org.apache.pulsar.client.admin.Sinks;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.SinkStatus;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.Dsl;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.Response;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.FilePart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.StringPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinksImpl
extends ComponentResource
implements Sinks,
Sink {
    private static final Logger log = LoggerFactory.getLogger(SinksImpl.class);
    private final WebTarget sink;
    private final AsyncHttpClient asyncHttpClient;

    public SinksImpl(WebTarget web, Authentication auth, AsyncHttpClient asyncHttpClient, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.sink = web.path("/admin/v3/sink");
        this.asyncHttpClient = asyncHttpClient;
    }

    @Override
    public List<String> listSinks(String tenant, String namespace) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.sink.path(tenant).path(namespace)).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SinkConfig getSink(String tenant, String namespace, String sinkName) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.sink.path(tenant).path(namespace).path(sinkName)).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(SinkConfig.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SinkStatus getSinkStatus(String tenant, String namespace, String sinkName) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.sink.path(tenant).path(namespace).path(sinkName).path("status")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(SinkStatus.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SinkStatus.SinkInstanceStatus.SinkInstanceStatusData getSinkStatus(String tenant, String namespace, String sinkName, int id) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.sink.path(tenant).path(namespace).path(sinkName).path(Integer.toString(id)).path("status")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(SinkStatus.SinkInstanceStatus.SinkInstanceStatusData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createSink(SinkConfig sinkConfig, String fileName) throws PulsarAdminException {
        try {
            Response response;
            RequestBuilder builder = (RequestBuilder)Dsl.post(this.sink.path(sinkConfig.getTenant()).path(sinkConfig.getNamespace()).path(sinkConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sinkConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(sinkConfig), "application/json"));
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            if ((response = (Response)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.sink, builder).build()).get()).getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw this.getApiException(org.apache.pulsar.shade.javax.ws.rs.core.Response.status(response.getStatusCode()).entity(response.getResponseBody()).build());
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createSinkWithUrl(SinkConfig sinkConfig, String pkgUrl) throws PulsarAdminException {
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("sinkConfig", (Object)new Gson().toJson(sinkConfig), MediaType.APPLICATION_JSON_TYPE));
            this.request(this.sink.path(sinkConfig.getTenant()).path(sinkConfig.getNamespace()).path(sinkConfig.getName())).post(Entity.entity(mp, "multipart/form-data"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteSink(String cluster, String namespace, String function) throws PulsarAdminException {
        try {
            this.request(this.sink.path(cluster).path(namespace).path(function)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateSink(SinkConfig sinkConfig, String fileName, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            Response response;
            RequestBuilder builder = (RequestBuilder)Dsl.put(this.sink.path(sinkConfig.getTenant()).path(sinkConfig.getNamespace()).path(sinkConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sinkConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(sinkConfig), "application/json"));
            if (updateOptions != null) {
                builder.addBodyPart(new StringPart("updateOptions", ObjectMapperFactory.getThreadLocal().writeValueAsString(updateOptions), "application/json"));
            }
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            if ((response = (Response)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.sink, builder).build()).get()).getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw this.getApiException(org.apache.pulsar.shade.javax.ws.rs.core.Response.status(response.getStatusCode()).entity(response.getResponseBody()).build());
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateSink(SinkConfig sinkConfig, String fileName) throws PulsarAdminException {
        this.updateSink(sinkConfig, fileName, null);
    }

    @Override
    public void updateSinkWithUrl(SinkConfig sinkConfig, String pkgUrl, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("sinkConfig", (Object)new Gson().toJson(sinkConfig), MediaType.APPLICATION_JSON_TYPE));
            if (updateOptions != null) {
                mp.bodyPart(new FormDataBodyPart("updateOptions", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString(updateOptions), MediaType.APPLICATION_JSON_TYPE));
            }
            this.request(this.sink.path(sinkConfig.getTenant()).path(sinkConfig.getNamespace()).path(sinkConfig.getName())).put(Entity.entity(mp, "multipart/form-data"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateSinkWithUrl(SinkConfig sinkConfig, String pkgUrl) throws PulsarAdminException {
        this.updateSinkWithUrl(sinkConfig, pkgUrl, null);
    }

    @Override
    public void restartSink(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.request(this.sink.path(tenant).path(namespace).path(functionName).path(Integer.toString(instanceId)).path("restart")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void restartSink(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.request(this.sink.path(tenant).path(namespace).path(functionName).path("restart")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void stopSink(String tenant, String namespace, String sinkName, int instanceId) throws PulsarAdminException {
        try {
            this.request(this.sink.path(tenant).path(namespace).path(sinkName).path(Integer.toString(instanceId)).path("stop")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void stopSink(String tenant, String namespace, String sinkName) throws PulsarAdminException {
        try {
            this.request(this.sink.path(tenant).path(namespace).path(sinkName).path("stop")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void startSink(String tenant, String namespace, String sinkName, int instanceId) throws PulsarAdminException {
        try {
            this.request(this.sink.path(tenant).path(namespace).path(sinkName).path(Integer.toString(instanceId)).path("start")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void startSink(String tenant, String namespace, String sinkName) throws PulsarAdminException {
        try {
            this.request(this.sink.path(tenant).path(namespace).path(sinkName).path("start")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<ConnectorDefinition> getBuiltInSinks() throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.javax.ws.rs.core.Response response = this.request(this.sink.path("builtinsinks")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(new GenericType<List<ConnectorDefinition>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void reloadBuiltInSinks() throws PulsarAdminException {
        try {
            this.request(this.sink.path("reloadBuiltInSinks")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

