/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.Lookup;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class LookupImpl
extends BaseResource
implements Lookup {
    private final WebTarget v2lookup;
    private final boolean useTls;

    public LookupImpl(WebTarget web, Authentication auth, boolean useTls, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.useTls = useTls;
        this.v2lookup = web.path("/lookup/v2");
    }

    @Override
    public String lookupTopic(String topic) throws PulsarAdminException {
        try {
            return this.lookupTopicAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<String> lookupTopicAsync(String topic) {
        TopicName topicName = TopicName.get(topic);
        String prefix = topicName.isV2() ? "/topic" : "/destination";
        WebTarget path = this.v2lookup.path(prefix).path(topicName.getLookupName());
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<LookupData>(){

            @Override
            public void completed(LookupData lookupData) {
                if (LookupImpl.this.useTls) {
                    future.complete(lookupData.getBrokerUrlTls());
                } else {
                    future.complete(lookupData.getBrokerUrl());
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(LookupImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public String getBundleRange(String topic) throws PulsarAdminException {
        try {
            return this.getBundleRangeAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<String> getBundleRangeAsync(String topic) {
        TopicName topicName = TopicName.get(topic);
        String prefix = topicName.isV2() ? "/topic" : "/destination";
        WebTarget path = this.v2lookup.path(prefix).path(topicName.getLookupName()).path("bundle");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String bundleRange) {
                future.complete(bundleRange);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(LookupImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }
}

