/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.Map;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.shade.com.google.common.collect.Maps;

public class TopicPolicies {
    private Map<String, BacklogQuota> backLogQuotaMap = Maps.newHashMap();
    private PersistencePolicies persistence = null;
    private RetentionPolicies retentionPolicies = null;
    private Boolean deduplicationEnabled = null;
    private Integer messageTTLInSeconds = null;
    private Integer maxProducerPerTopic = null;
    private Integer maxConsumerPerTopic = null;
    private Integer maxConsumersPerSubscription = null;

    public boolean isBacklogQuotaSet() {
        return !this.backLogQuotaMap.isEmpty();
    }

    public boolean isPersistentPolicySet() {
        return this.persistence != null;
    }

    public boolean isRetentionSet() {
        return this.retentionPolicies != null;
    }

    public boolean isDeduplicationSet() {
        return this.deduplicationEnabled != null;
    }

    public boolean isMessageTTLSet() {
        return this.messageTTLInSeconds != null;
    }

    public boolean isMaxProducerPerTopicSet() {
        return this.maxProducerPerTopic != null;
    }

    public boolean isMaxConsumerPerTopicSet() {
        return this.maxConsumerPerTopic != null;
    }

    public boolean isMaxConsumersPerSubscriptionSet() {
        return this.maxConsumersPerSubscription != null;
    }

    public static TopicPoliciesBuilder builder() {
        return new TopicPoliciesBuilder();
    }

    public Map<String, BacklogQuota> getBackLogQuotaMap() {
        return this.backLogQuotaMap;
    }

    public PersistencePolicies getPersistence() {
        return this.persistence;
    }

    public RetentionPolicies getRetentionPolicies() {
        return this.retentionPolicies;
    }

    public Boolean getDeduplicationEnabled() {
        return this.deduplicationEnabled;
    }

    public Integer getMessageTTLInSeconds() {
        return this.messageTTLInSeconds;
    }

    public Integer getMaxProducerPerTopic() {
        return this.maxProducerPerTopic;
    }

    public Integer getMaxConsumerPerTopic() {
        return this.maxConsumerPerTopic;
    }

    public Integer getMaxConsumersPerSubscription() {
        return this.maxConsumersPerSubscription;
    }

    public void setBackLogQuotaMap(Map<String, BacklogQuota> backLogQuotaMap) {
        this.backLogQuotaMap = backLogQuotaMap;
    }

    public void setPersistence(PersistencePolicies persistence) {
        this.persistence = persistence;
    }

    public void setRetentionPolicies(RetentionPolicies retentionPolicies) {
        this.retentionPolicies = retentionPolicies;
    }

    public void setDeduplicationEnabled(Boolean deduplicationEnabled) {
        this.deduplicationEnabled = deduplicationEnabled;
    }

    public void setMessageTTLInSeconds(Integer messageTTLInSeconds) {
        this.messageTTLInSeconds = messageTTLInSeconds;
    }

    public void setMaxProducerPerTopic(Integer maxProducerPerTopic) {
        this.maxProducerPerTopic = maxProducerPerTopic;
    }

    public void setMaxConsumerPerTopic(Integer maxConsumerPerTopic) {
        this.maxConsumerPerTopic = maxConsumerPerTopic;
    }

    public void setMaxConsumersPerSubscription(Integer maxConsumersPerSubscription) {
        this.maxConsumersPerSubscription = maxConsumersPerSubscription;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicPolicies)) {
            return false;
        }
        TopicPolicies other = (TopicPolicies)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, BacklogQuota> this$backLogQuotaMap = this.getBackLogQuotaMap();
        Map<String, BacklogQuota> other$backLogQuotaMap = other.getBackLogQuotaMap();
        if (this$backLogQuotaMap == null ? other$backLogQuotaMap != null : !((Object)this$backLogQuotaMap).equals(other$backLogQuotaMap)) {
            return false;
        }
        PersistencePolicies this$persistence = this.getPersistence();
        PersistencePolicies other$persistence = other.getPersistence();
        if (this$persistence == null ? other$persistence != null : !((Object)this$persistence).equals(other$persistence)) {
            return false;
        }
        RetentionPolicies this$retentionPolicies = this.getRetentionPolicies();
        RetentionPolicies other$retentionPolicies = other.getRetentionPolicies();
        if (this$retentionPolicies == null ? other$retentionPolicies != null : !((Object)this$retentionPolicies).equals(other$retentionPolicies)) {
            return false;
        }
        Boolean this$deduplicationEnabled = this.getDeduplicationEnabled();
        Boolean other$deduplicationEnabled = other.getDeduplicationEnabled();
        if (this$deduplicationEnabled == null ? other$deduplicationEnabled != null : !((Object)this$deduplicationEnabled).equals(other$deduplicationEnabled)) {
            return false;
        }
        Integer this$messageTTLInSeconds = this.getMessageTTLInSeconds();
        Integer other$messageTTLInSeconds = other.getMessageTTLInSeconds();
        if (this$messageTTLInSeconds == null ? other$messageTTLInSeconds != null : !((Object)this$messageTTLInSeconds).equals(other$messageTTLInSeconds)) {
            return false;
        }
        Integer this$maxProducerPerTopic = this.getMaxProducerPerTopic();
        Integer other$maxProducerPerTopic = other.getMaxProducerPerTopic();
        if (this$maxProducerPerTopic == null ? other$maxProducerPerTopic != null : !((Object)this$maxProducerPerTopic).equals(other$maxProducerPerTopic)) {
            return false;
        }
        Integer this$maxConsumerPerTopic = this.getMaxConsumerPerTopic();
        Integer other$maxConsumerPerTopic = other.getMaxConsumerPerTopic();
        if (this$maxConsumerPerTopic == null ? other$maxConsumerPerTopic != null : !((Object)this$maxConsumerPerTopic).equals(other$maxConsumerPerTopic)) {
            return false;
        }
        Integer this$maxConsumersPerSubscription = this.getMaxConsumersPerSubscription();
        Integer other$maxConsumersPerSubscription = other.getMaxConsumersPerSubscription();
        return !(this$maxConsumersPerSubscription == null ? other$maxConsumersPerSubscription != null : !((Object)this$maxConsumersPerSubscription).equals(other$maxConsumersPerSubscription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopicPolicies;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, BacklogQuota> $backLogQuotaMap = this.getBackLogQuotaMap();
        result = result * 59 + ($backLogQuotaMap == null ? 43 : ((Object)$backLogQuotaMap).hashCode());
        PersistencePolicies $persistence = this.getPersistence();
        result = result * 59 + ($persistence == null ? 43 : ((Object)$persistence).hashCode());
        RetentionPolicies $retentionPolicies = this.getRetentionPolicies();
        result = result * 59 + ($retentionPolicies == null ? 43 : ((Object)$retentionPolicies).hashCode());
        Boolean $deduplicationEnabled = this.getDeduplicationEnabled();
        result = result * 59 + ($deduplicationEnabled == null ? 43 : ((Object)$deduplicationEnabled).hashCode());
        Integer $messageTTLInSeconds = this.getMessageTTLInSeconds();
        result = result * 59 + ($messageTTLInSeconds == null ? 43 : ((Object)$messageTTLInSeconds).hashCode());
        Integer $maxProducerPerTopic = this.getMaxProducerPerTopic();
        result = result * 59 + ($maxProducerPerTopic == null ? 43 : ((Object)$maxProducerPerTopic).hashCode());
        Integer $maxConsumerPerTopic = this.getMaxConsumerPerTopic();
        result = result * 59 + ($maxConsumerPerTopic == null ? 43 : ((Object)$maxConsumerPerTopic).hashCode());
        Integer $maxConsumersPerSubscription = this.getMaxConsumersPerSubscription();
        result = result * 59 + ($maxConsumersPerSubscription == null ? 43 : ((Object)$maxConsumersPerSubscription).hashCode());
        return result;
    }

    public String toString() {
        return "TopicPolicies(backLogQuotaMap=" + this.getBackLogQuotaMap() + ", persistence=" + this.getPersistence() + ", retentionPolicies=" + this.getRetentionPolicies() + ", deduplicationEnabled=" + this.getDeduplicationEnabled() + ", messageTTLInSeconds=" + this.getMessageTTLInSeconds() + ", maxProducerPerTopic=" + this.getMaxProducerPerTopic() + ", maxConsumerPerTopic=" + this.getMaxConsumerPerTopic() + ", maxConsumersPerSubscription=" + this.getMaxConsumersPerSubscription() + ")";
    }

    public TopicPolicies() {
    }

    public TopicPolicies(Map<String, BacklogQuota> backLogQuotaMap, PersistencePolicies persistence, RetentionPolicies retentionPolicies, Boolean deduplicationEnabled, Integer messageTTLInSeconds, Integer maxProducerPerTopic, Integer maxConsumerPerTopic, Integer maxConsumersPerSubscription) {
        this.backLogQuotaMap = backLogQuotaMap;
        this.persistence = persistence;
        this.retentionPolicies = retentionPolicies;
        this.deduplicationEnabled = deduplicationEnabled;
        this.messageTTLInSeconds = messageTTLInSeconds;
        this.maxProducerPerTopic = maxProducerPerTopic;
        this.maxConsumerPerTopic = maxConsumerPerTopic;
        this.maxConsumersPerSubscription = maxConsumersPerSubscription;
    }

    public static class TopicPoliciesBuilder {
        private Map<String, BacklogQuota> backLogQuotaMap;
        private PersistencePolicies persistence;
        private RetentionPolicies retentionPolicies;
        private Boolean deduplicationEnabled;
        private Integer messageTTLInSeconds;
        private Integer maxProducerPerTopic;
        private Integer maxConsumerPerTopic;
        private Integer maxConsumersPerSubscription;

        TopicPoliciesBuilder() {
        }

        public TopicPoliciesBuilder backLogQuotaMap(Map<String, BacklogQuota> backLogQuotaMap) {
            this.backLogQuotaMap = backLogQuotaMap;
            return this;
        }

        public TopicPoliciesBuilder persistence(PersistencePolicies persistence) {
            this.persistence = persistence;
            return this;
        }

        public TopicPoliciesBuilder retentionPolicies(RetentionPolicies retentionPolicies) {
            this.retentionPolicies = retentionPolicies;
            return this;
        }

        public TopicPoliciesBuilder deduplicationEnabled(Boolean deduplicationEnabled) {
            this.deduplicationEnabled = deduplicationEnabled;
            return this;
        }

        public TopicPoliciesBuilder messageTTLInSeconds(Integer messageTTLInSeconds) {
            this.messageTTLInSeconds = messageTTLInSeconds;
            return this;
        }

        public TopicPoliciesBuilder maxProducerPerTopic(Integer maxProducerPerTopic) {
            this.maxProducerPerTopic = maxProducerPerTopic;
            return this;
        }

        public TopicPoliciesBuilder maxConsumerPerTopic(Integer maxConsumerPerTopic) {
            this.maxConsumerPerTopic = maxConsumerPerTopic;
            return this;
        }

        public TopicPoliciesBuilder maxConsumersPerSubscription(Integer maxConsumersPerSubscription) {
            this.maxConsumersPerSubscription = maxConsumersPerSubscription;
            return this;
        }

        public TopicPolicies build() {
            return new TopicPolicies(this.backLogQuotaMap, this.persistence, this.retentionPolicies, this.deduplicationEnabled, this.messageTTLInSeconds, this.maxProducerPerTopic, this.maxConsumerPerTopic, this.maxConsumersPerSubscription);
        }

        public String toString() {
            return "TopicPolicies.TopicPoliciesBuilder(backLogQuotaMap=" + this.backLogQuotaMap + ", persistence=" + this.persistence + ", retentionPolicies=" + this.retentionPolicies + ", deduplicationEnabled=" + this.deduplicationEnabled + ", messageTTLInSeconds=" + this.messageTTLInSeconds + ", maxProducerPerTopic=" + this.maxProducerPerTopic + ", maxConsumerPerTopic=" + this.maxConsumerPerTopic + ", maxConsumersPerSubscription=" + this.maxConsumersPerSubscription + ")";
        }
    }
}

