/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.transaction;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TransactionBuilder;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionCoordinatorClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBuilderImpl
implements TransactionBuilder {
    private static final Logger log = LoggerFactory.getLogger(TransactionBuilderImpl.class);
    private final PulsarClientImpl client;
    private final TransactionCoordinatorClientImpl transactionCoordinatorClient;
    private long txnTimeoutMs = 60000L;
    private static final long txnRequestTimeoutMs = 30000L;

    public TransactionBuilderImpl(PulsarClientImpl client, TransactionCoordinatorClientImpl tcClient) {
        this.client = client;
        this.transactionCoordinatorClient = tcClient;
    }

    public TransactionBuilder withTransactionTimeout(long timeout, TimeUnit timeoutUnit) {
        this.txnTimeoutMs = timeoutUnit.toMillis(timeout);
        return this;
    }

    public CompletableFuture<Transaction> build() {
        CompletableFuture<Transaction> future = new CompletableFuture<Transaction>();
        this.transactionCoordinatorClient.newTransactionAsync(30000L, TimeUnit.MILLISECONDS).whenComplete((txnID, throwable) -> {
            if (log.isDebugEnabled()) {
                log.debug("Success to new txn. txnID: {}", txnID);
            }
            if (throwable != null) {
                log.error("New transaction error.", throwable);
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            future.complete(new TransactionImpl(this.client, this.txnTimeoutMs, txnID.getLeastSigBits(), txnID.getMostSigBits()));
        });
        return future;
    }
}

