/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.Namespaces;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class NamespacesImpl
extends BaseResource
implements Namespaces {
    private final WebTarget adminNamespaces;
    private final WebTarget adminV2Namespaces;

    public NamespacesImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminNamespaces = web.path("/admin/namespaces");
        this.adminV2Namespaces = web.path("/admin/v2/namespaces");
    }

    public List<String> getNamespaces(String tenant) throws PulsarAdminException {
        try {
            return this.getNamespacesAsync(tenant).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<String>> getNamespacesAsync(String tenant) {
        WebTarget path = this.adminV2Namespaces.path(tenant);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> namespaces) {
                future.complete(namespaces);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public List<String> getNamespaces(String tenant, String cluster) throws PulsarAdminException {
        WebTarget path = this.adminNamespaces.path(tenant).path(cluster);
        final CompletableFuture future = new CompletableFuture();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> namespaces) {
                future.complete(namespaces);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        try {
            return (List)future.get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public List<String> getTopics(String namespace) throws PulsarAdminException {
        try {
            return this.getTopicsAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public BundlesData getBundles(String namespace) throws PulsarAdminException {
        try {
            return this.getBundlesAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<BundlesData> getBundlesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        String action = "bundles";
        WebTarget path = this.namespacePath(ns, action);
        final CompletableFuture<BundlesData> future = new CompletableFuture<BundlesData>();
        this.asyncGetRequest(path, new InvocationCallback<BundlesData>(){

            @Override
            public void completed(BundlesData bundles) {
                future.complete(bundles);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<List<String>> getTopicsAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        String action = ns.isV2() ? "topics" : "destinations";
        WebTarget path = this.namespacePath(ns, action);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> topics) {
                future.complete(topics);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Policies getPolicies(String namespace) throws PulsarAdminException {
        try {
            return this.getPoliciesAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Policies> getPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        final CompletableFuture<Policies> future = new CompletableFuture<Policies>();
        this.asyncGetRequest(path, new InvocationCallback<Policies>(){

            @Override
            public void completed(Policies policies) {
                future.complete(policies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void createNamespace(String namespace, Set<String> clusters) throws PulsarAdminException {
        try {
            this.createNamespaceAsync(namespace, clusters).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace, Set<String> clusters) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        if (ns.isV2()) {
            Policies policies = new Policies();
            policies.replication_clusters = clusters;
            return this.asyncPutRequest(path, Entity.entity(policies, "application/json"));
        }
        return this.asyncPutRequest(path, Entity.entity("", "application/json")).thenAccept(ignore -> this.setNamespaceReplicationClustersAsync(namespace, clusters));
    }

    public void createNamespace(String namespace, int numBundles) throws PulsarAdminException {
        this.createNamespace(namespace, BundlesData.builder().numBundles(numBundles).build());
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace, int numBundles) {
        return this.createNamespaceAsync(namespace, BundlesData.builder().numBundles(numBundles).build());
    }

    public void createNamespace(String namespace, Policies policies) throws PulsarAdminException {
        try {
            this.createNamespaceAsync(namespace, policies).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace, Policies policies) {
        NamespaceName ns = NamespaceName.get(namespace);
        Preconditions.checkArgument(ns.isV2(), "Create namespace with policies is only supported on newer namespaces");
        WebTarget path = this.namespacePath(ns, new String[0]);
        return this.asyncPutRequest(path, Entity.entity(policies, "application/json"));
    }

    public void createNamespace(String namespace, BundlesData bundlesData) throws PulsarAdminException {
        try {
            this.createNamespaceAsync(namespace, bundlesData).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace, BundlesData bundlesData) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        if (ns.isV2()) {
            Policies policies = new Policies();
            policies.bundles = bundlesData;
            return this.asyncPutRequest(path, Entity.entity(policies, "application/json"));
        }
        return this.asyncPutRequest(path, Entity.entity(bundlesData, "application/json"));
    }

    public void createNamespace(String namespace) throws PulsarAdminException {
        try {
            this.createNamespaceAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public void deleteNamespace(String namespace) throws PulsarAdminException {
        try {
            this.deleteNamespaceAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public void deleteNamespace(String namespace, boolean force) throws PulsarAdminException {
        try {
            this.deleteNamespaceAsync(namespace, force).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteNamespaceAsync(String namespace) {
        return this.deleteNamespaceAsync(namespace, false);
    }

    public CompletableFuture<Void> deleteNamespaceAsync(String namespace, boolean force) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    public void deleteNamespaceBundle(String namespace, String bundleRange) throws PulsarAdminException {
        try {
            this.deleteNamespaceBundleAsync(namespace, bundleRange).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public void deleteNamespaceBundle(String namespace, String bundleRange, boolean force) throws PulsarAdminException {
        try {
            this.deleteNamespaceBundleAsync(namespace, bundleRange, force).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteNamespaceBundleAsync(String namespace, String bundleRange) {
        return this.deleteNamespaceBundleAsync(namespace, bundleRange, false);
    }

    public CompletableFuture<Void> deleteNamespaceBundleAsync(String namespace, String bundleRange, boolean force) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundleRange);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    public Map<String, Set<AuthAction>> getPermissions(String namespace) throws PulsarAdminException {
        try {
            return this.getPermissionsAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions");
        final CompletableFuture<Map<String, Set<AuthAction>>> future = new CompletableFuture<Map<String, Set<AuthAction>>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, Set<AuthAction>>>(){

            @Override
            public void completed(Map<String, Set<AuthAction>> permissions) {
                future.complete(permissions);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void grantPermissionOnNamespace(String namespace, String role, Set<AuthAction> actions) throws PulsarAdminException {
        try {
            this.grantPermissionOnNamespaceAsync(namespace, role, actions).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> grantPermissionOnNamespaceAsync(String namespace, String role, Set<AuthAction> actions) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", role);
        return this.asyncPostRequest(path, Entity.entity(actions, "application/json"));
    }

    public void revokePermissionsOnNamespace(String namespace, String role) throws PulsarAdminException {
        try {
            this.revokePermissionsOnNamespaceAsync(namespace, role).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> revokePermissionsOnNamespaceAsync(String namespace, String role) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", role);
        return this.asyncDeleteRequest(path);
    }

    public void grantPermissionOnSubscription(String namespace, String subscription, Set<String> roles) throws PulsarAdminException {
        try {
            this.grantPermissionOnSubscriptionAsync(namespace, subscription, roles).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> grantPermissionOnSubscriptionAsync(String namespace, String subscription, Set<String> roles) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", "subscription", subscription);
        return this.asyncPostRequest(path, Entity.entity(roles, "application/json"));
    }

    public void revokePermissionOnSubscription(String namespace, String subscription, String role) throws PulsarAdminException {
        try {
            this.revokePermissionOnSubscriptionAsync(namespace, subscription, role).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> revokePermissionOnSubscriptionAsync(String namespace, String subscription, String role) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", subscription, role);
        return this.asyncDeleteRequest(path);
    }

    public List<String> getNamespaceReplicationClusters(String namespace) throws PulsarAdminException {
        try {
            return this.getNamespaceReplicationClustersAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<String>> getNamespaceReplicationClustersAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replication");
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> clusters) {
                future.complete(clusters);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setNamespaceReplicationClusters(String namespace, Set<String> clusterIds) throws PulsarAdminException {
        try {
            this.setNamespaceReplicationClustersAsync(namespace, clusterIds).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setNamespaceReplicationClustersAsync(String namespace, Set<String> clusterIds) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replication");
        return this.asyncPostRequest(path, Entity.entity(clusterIds, "application/json"));
    }

    public Integer getNamespaceMessageTTL(String namespace) throws PulsarAdminException {
        try {
            return this.getNamespaceMessageTTLAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getNamespaceMessageTTLAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "messageTTL");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer ttl) {
                future.complete(ttl);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setNamespaceMessageTTL(String namespace, int ttlInSeconds) throws PulsarAdminException {
        try {
            this.setNamespaceMessageTTLAsync(namespace, ttlInSeconds).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setNamespaceMessageTTLAsync(String namespace, int ttlInSeconds) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "messageTTL");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(ttlInSeconds), "application/json"));
    }

    public void removeNamespaceMessageTTL(String namespace) throws PulsarAdminException {
        try {
            this.removeNamespaceMessageTTLAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeNamespaceMessageTTLAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "messageTTL");
        return this.asyncDeleteRequest(path);
    }

    public Integer getSubscriptionExpirationTime(String namespace) throws PulsarAdminException {
        try {
            return this.getSubscriptionExpirationTimeAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getSubscriptionExpirationTimeAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionExpirationTime");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer expirationTime) {
                future.complete(expirationTime);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setSubscriptionExpirationTime(String namespace, int expirationTime) throws PulsarAdminException {
        try {
            this.setSubscriptionExpirationTimeAsync(namespace, expirationTime).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSubscriptionExpirationTimeAsync(String namespace, int expirationTime) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionExpirationTime");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(expirationTime), "application/json"));
    }

    public void removeSubscriptionExpirationTime(String namespace) throws PulsarAdminException {
        try {
            this.removeSubscriptionExpirationTimeAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeSubscriptionExpirationTimeAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionExpirationTime");
        return this.asyncDeleteRequest(path);
    }

    public void setNamespaceAntiAffinityGroup(String namespace, String namespaceAntiAffinityGroup) throws PulsarAdminException {
        try {
            this.setNamespaceAntiAffinityGroupAsync(namespace, namespaceAntiAffinityGroup).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setNamespaceAntiAffinityGroupAsync(String namespace, String namespaceAntiAffinityGroup) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "antiAffinity");
        return this.asyncPostRequest(path, Entity.entity(namespaceAntiAffinityGroup, "application/json"));
    }

    public String getNamespaceAntiAffinityGroup(String namespace) throws PulsarAdminException {
        try {
            return this.getNamespaceAntiAffinityGroupAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<String> getNamespaceAntiAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "antiAffinity");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String s) {
                future.complete(s);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public List<String> getAntiAffinityNamespaces(String tenant, String cluster, String namespaceAntiAffinityGroup) throws PulsarAdminException {
        try {
            return this.getAntiAffinityNamespacesAsync(tenant, cluster, namespaceAntiAffinityGroup).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<String>> getAntiAffinityNamespacesAsync(String tenant, String cluster, String namespaceAntiAffinityGroup) {
        WebTarget path = this.adminNamespaces.path(cluster).path("antiAffinity").path(namespaceAntiAffinityGroup).queryParam("property", tenant);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> antiNamespaces) {
                future.complete(antiNamespaces);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void deleteNamespaceAntiAffinityGroup(String namespace) throws PulsarAdminException {
        try {
            this.deleteNamespaceAntiAffinityGroupAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteNamespaceAntiAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "antiAffinity");
        return this.asyncDeleteRequest(path);
    }

    public void removeDeduplicationStatus(String namespace) throws PulsarAdminException {
        try {
            this.removeDeduplicationStatusAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeDeduplicationStatusAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplication");
        return this.asyncDeleteRequest(path);
    }

    public Boolean getDeduplicationStatus(String namespace) throws PulsarAdminException {
        try {
            return this.getDeduplicationStatusAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplication");
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncGetRequest(path, new InvocationCallback<Boolean>(){

            @Override
            public void completed(Boolean enabled) {
                future.complete(enabled);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setDeduplicationStatus(String namespace, boolean enableDeduplication) throws PulsarAdminException {
        try {
            this.setDeduplicationStatusAsync(namespace, enableDeduplication).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setDeduplicationStatusAsync(String namespace, boolean enableDeduplication) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplication");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(enableDeduplication), "application/json"));
    }

    public void setAutoTopicCreation(String namespace, AutoTopicCreationOverride autoTopicCreationOverride) throws PulsarAdminException {
        try {
            this.setAutoTopicCreationAsync(namespace, autoTopicCreationOverride).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setAutoTopicCreationAsync(String namespace, AutoTopicCreationOverride autoTopicCreationOverride) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoTopicCreation");
        return this.asyncPostRequest(path, Entity.entity(autoTopicCreationOverride, "application/json"));
    }

    public void removeAutoTopicCreation(String namespace) throws PulsarAdminException {
        try {
            this.removeAutoTopicCreationAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeAutoTopicCreationAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoTopicCreation");
        return this.asyncDeleteRequest(path);
    }

    public void setAutoSubscriptionCreation(String namespace, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) throws PulsarAdminException {
        try {
            this.setAutoSubscriptionCreationAsync(namespace, autoSubscriptionCreationOverride).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setAutoSubscriptionCreationAsync(String namespace, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoSubscriptionCreation");
        return this.asyncPostRequest(path, Entity.entity(autoSubscriptionCreationOverride, "application/json"));
    }

    public void setSubscriptionTypesEnabled(String namespace, Set<SubscriptionType> subscriptionTypesEnabled) throws PulsarAdminException {
        try {
            this.setSubscriptionTypesEnabledAsync(namespace, subscriptionTypesEnabled).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSubscriptionTypesEnabledAsync(String namespace, Set<SubscriptionType> subscriptionTypes) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionTypesEnabled");
        return this.asyncPostRequest(path, Entity.entity(subscriptionTypes, "application/json"));
    }

    public Set<SubscriptionType> getSubscriptionTypesEnabled(String namespace) throws PulsarAdminException {
        try {
            return this.getSubscriptionTypesEnabledAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Set<SubscriptionType>> getSubscriptionTypesEnabledAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionTypesEnabled");
        final CompletableFuture<Set<SubscriptionType>> future = new CompletableFuture<Set<SubscriptionType>>();
        this.asyncGetRequest(path, new InvocationCallback<Set<SubscriptionType>>(){

            @Override
            public void completed(Set<SubscriptionType> subscriptionTypesEnabled) {
                future.complete(subscriptionTypesEnabled);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void removeAutoSubscriptionCreation(String namespace) throws PulsarAdminException {
        try {
            this.removeAutoSubscriptionCreationAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeAutoSubscriptionCreationAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoSubscriptionCreation");
        return this.asyncDeleteRequest(path);
    }

    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String namespace) throws PulsarAdminException {
        try {
            return this.getBacklogQuotaMapAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>> getBacklogQuotaMapAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "backlogQuotaMap");
        final CompletableFuture<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>> future = new CompletableFuture<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>(){

            @Override
            public void completed(Map<BacklogQuota.BacklogQuotaType, BacklogQuota> quotaMap) {
                future.complete(quotaMap);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setBacklogQuota(String namespace, BacklogQuota backlogQuota, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        try {
            this.setBacklogQuotaAsync(namespace, backlogQuota, backlogQuotaType).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setBacklogQuotaAsync(String namespace, BacklogQuota backlogQuota, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "backlogQuota");
        return this.asyncPostRequest(path.queryParam("backlogQuotaType", backlogQuotaType.toString()), Entity.entity(backlogQuota, "application/json"));
    }

    public void removeBacklogQuota(String namespace, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        try {
            this.removeBacklogQuotaAsync(namespace, backlogQuotaType).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public void removeInactiveTopicPolicies(String namespace) throws PulsarAdminException {
        try {
            this.removeInactiveTopicPoliciesAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeInactiveTopicPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "inactiveTopicPolicies");
        return this.asyncDeleteRequest(path);
    }

    public CompletableFuture<Void> removeBacklogQuotaAsync(String namespace, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "backlogQuota").queryParam("backlogQuotaType", backlogQuotaType.toString());
        return this.asyncDeleteRequest(path);
    }

    public void removePersistence(String namespace) throws PulsarAdminException {
        try {
            this.removePersistenceAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removePersistenceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence");
        return this.asyncDeleteRequest(path);
    }

    public void setPersistence(String namespace, PersistencePolicies persistence) throws PulsarAdminException {
        try {
            this.setPersistenceAsync(namespace, persistence).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setPersistenceAsync(String namespace, PersistencePolicies persistence) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence");
        return this.asyncPostRequest(path, Entity.entity(persistence, "application/json"));
    }

    public void setBookieAffinityGroup(String namespace, BookieAffinityGroupData bookieAffinityGroup) throws PulsarAdminException {
        try {
            this.setBookieAffinityGroupAsync(namespace, bookieAffinityGroup).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setBookieAffinityGroupAsync(String namespace, BookieAffinityGroupData bookieAffinityGroup) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
        return this.asyncPostRequest(path, Entity.entity(bookieAffinityGroup, "application/json"));
    }

    public void deleteBookieAffinityGroup(String namespace) throws PulsarAdminException {
        try {
            this.deleteBookieAffinityGroupAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteBookieAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
        return this.asyncDeleteRequest(path);
    }

    public BookieAffinityGroupData getBookieAffinityGroup(String namespace) throws PulsarAdminException {
        try {
            return this.getBookieAffinityGroupAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<BookieAffinityGroupData> getBookieAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
        final CompletableFuture<BookieAffinityGroupData> future = new CompletableFuture<BookieAffinityGroupData>();
        this.asyncGetRequest(path, new InvocationCallback<BookieAffinityGroupData>(){

            @Override
            public void completed(BookieAffinityGroupData bookieAffinityGroupData) {
                future.complete(bookieAffinityGroupData);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public PersistencePolicies getPersistence(String namespace) throws PulsarAdminException {
        try {
            return this.getPersistenceAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence");
        final CompletableFuture<PersistencePolicies> future = new CompletableFuture<PersistencePolicies>();
        this.asyncGetRequest(path, new InvocationCallback<PersistencePolicies>(){

            @Override
            public void completed(PersistencePolicies persistencePolicies) {
                future.complete(persistencePolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setRetention(String namespace, RetentionPolicies retention) throws PulsarAdminException {
        try {
            this.setRetentionAsync(namespace, retention).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setRetentionAsync(String namespace, RetentionPolicies retention) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "retention");
        return this.asyncPostRequest(path, Entity.entity(retention, "application/json"));
    }

    public void removeRetention(String namespace) throws PulsarAdminException {
        try {
            this.removeRetentionAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeRetentionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "retention");
        return this.asyncDeleteRequest(path);
    }

    public RetentionPolicies getRetention(String namespace) throws PulsarAdminException {
        try {
            return this.getRetentionAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<RetentionPolicies> getRetentionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "retention");
        final CompletableFuture<RetentionPolicies> future = new CompletableFuture<RetentionPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<RetentionPolicies>(){

            @Override
            public void completed(RetentionPolicies retentionPolicies) {
                future.complete(retentionPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void unload(String namespace) throws PulsarAdminException {
        try {
            this.unloadAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> unloadAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public String getReplicationConfigVersion(String namespace) throws PulsarAdminException {
        try {
            return this.getReplicationConfigVersionAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<String> getReplicationConfigVersionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "configversion");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String s) {
                future.complete(s);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void unloadNamespaceBundle(String namespace, String bundle) throws PulsarAdminException {
        try {
            this.unloadNamespaceBundleAsync(namespace, bundle).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> unloadNamespaceBundleAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public void splitNamespaceBundle(String namespace, String bundle, boolean unloadSplitBundles, String splitAlgorithmName) throws PulsarAdminException {
        try {
            this.splitNamespaceBundleAsync(namespace, bundle, unloadSplitBundles, splitAlgorithmName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> splitNamespaceBundleAsync(String namespace, String bundle, boolean unloadSplitBundles, String splitAlgorithmName) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "split").queryParam("unload", Boolean.toString(unloadSplitBundles)).queryParam("splitAlgorithmName", splitAlgorithmName);
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public void setPublishRate(String namespace, PublishRate publishMsgRate) throws PulsarAdminException {
        try {
            this.setPublishRateAsync(namespace, publishMsgRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public void removePublishRate(String namespace) throws PulsarAdminException {
        try {
            this.removePublishRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setPublishRateAsync(String namespace, PublishRate publishMsgRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "publishRate");
        return this.asyncPostRequest(path, Entity.entity(publishMsgRate, "application/json"));
    }

    public CompletableFuture<Void> removePublishRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "publishRate");
        return this.asyncDeleteRequest(path);
    }

    public PublishRate getPublishRate(String namespace) throws PulsarAdminException {
        try {
            return this.getPublishRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<PublishRate> getPublishRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "publishRate");
        final CompletableFuture<PublishRate> future = new CompletableFuture<PublishRate>();
        this.asyncGetRequest(path, new InvocationCallback<PublishRate>(){

            @Override
            public void completed(PublishRate publishRate) {
                future.complete(publishRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void removeDispatchRate(String namespace) throws PulsarAdminException {
        try {
            this.removeDispatchRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "dispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public void setDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        try {
            this.setDispatchRateAsync(namespace, dispatchRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setDispatchRateAsync(String namespace, DispatchRate dispatchRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "dispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public DispatchRate getDispatchRate(String namespace) throws PulsarAdminException {
        try {
            return this.getDispatchRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<DispatchRate> getDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "dispatchRate");
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            @Override
            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setSubscribeRate(String namespace, SubscribeRate subscribeRate) throws PulsarAdminException {
        try {
            this.setSubscribeRateAsync(namespace, subscribeRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSubscribeRateAsync(String namespace, SubscribeRate subscribeRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscribeRate");
        return this.asyncPostRequest(path, Entity.entity(subscribeRate, "application/json"));
    }

    public void removeSubscribeRate(String namespace) throws PulsarAdminException {
        try {
            this.removeSubscribeRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeSubscribeRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscribeRate");
        return this.asyncDeleteRequest(path);
    }

    public SubscribeRate getSubscribeRate(String namespace) throws PulsarAdminException {
        try {
            return this.getSubscribeRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscribeRate");
        final CompletableFuture<SubscribeRate> future = new CompletableFuture<SubscribeRate>();
        this.asyncGetRequest(path, new InvocationCallback<SubscribeRate>(){

            @Override
            public void completed(SubscribeRate subscribeRate) {
                future.complete(subscribeRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void removeSubscriptionDispatchRate(String namespace) throws PulsarAdminException {
        try {
            this.removeSubscriptionDispatchRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeSubscriptionDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public void setSubscriptionDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        try {
            this.setSubscriptionDispatchRateAsync(namespace, dispatchRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSubscriptionDispatchRateAsync(String namespace, DispatchRate dispatchRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public DispatchRate getSubscriptionDispatchRate(String namespace) throws PulsarAdminException {
        try {
            return this.getSubscriptionDispatchRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            @Override
            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setReplicatorDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        try {
            this.setReplicatorDispatchRateAsync(namespace, dispatchRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setReplicatorDispatchRateAsync(String namespace, DispatchRate dispatchRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public void removeReplicatorDispatchRate(String namespace) throws PulsarAdminException {
        try {
            this.removeReplicatorDispatchRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeReplicatorDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getReplicatorDispatchRate(String namespace) throws PulsarAdminException {
        try {
            return this.getReplicatorDispatchRateAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            @Override
            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void clearNamespaceBacklog(String namespace) throws PulsarAdminException {
        try {
            this.clearNamespaceBacklogAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> clearNamespaceBacklogAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "clearBacklog");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void clearNamespaceBacklogForSubscription(String namespace, String subscription) throws PulsarAdminException {
        try {
            this.clearNamespaceBacklogForSubscriptionAsync(namespace, subscription).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> clearNamespaceBacklogForSubscriptionAsync(String namespace, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "clearBacklog", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void clearNamespaceBundleBacklog(String namespace, String bundle) throws PulsarAdminException {
        try {
            this.clearNamespaceBundleBacklogAsync(namespace, bundle).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> clearNamespaceBundleBacklogAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "clearBacklog");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void clearNamespaceBundleBacklogForSubscription(String namespace, String bundle, String subscription) throws PulsarAdminException {
        try {
            this.clearNamespaceBundleBacklogForSubscriptionAsync(namespace, bundle, subscription).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> clearNamespaceBundleBacklogForSubscriptionAsync(String namespace, String bundle, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "clearBacklog", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void unsubscribeNamespace(String namespace, String subscription) throws PulsarAdminException {
        try {
            this.unsubscribeNamespaceAsync(namespace, subscription).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> unsubscribeNamespaceAsync(String namespace, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "unsubscribe", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void unsubscribeNamespaceBundle(String namespace, String bundle, String subscription) throws PulsarAdminException {
        try {
            this.unsubscribeNamespaceBundleAsync(namespace, bundle, subscription).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> unsubscribeNamespaceBundleAsync(String namespace, String bundle, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "unsubscribe", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void setSubscriptionAuthMode(String namespace, SubscriptionAuthMode subscriptionAuthMode) throws PulsarAdminException {
        try {
            this.setSubscriptionAuthModeAsync(namespace, subscriptionAuthMode).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSubscriptionAuthModeAsync(String namespace, SubscriptionAuthMode subscriptionAuthMode) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionAuthMode");
        return this.asyncPostRequest(path, Entity.entity(subscriptionAuthMode, "application/json"));
    }

    public void setEncryptionRequiredStatus(String namespace, boolean encryptionRequired) throws PulsarAdminException {
        try {
            this.setEncryptionRequiredStatusAsync(namespace, encryptionRequired).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setEncryptionRequiredStatusAsync(String namespace, boolean encryptionRequired) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "encryptionRequired");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(encryptionRequired), "application/json"));
    }

    public DelayedDeliveryPolicies getDelayedDelivery(String namespace) throws PulsarAdminException {
        try {
            return this.getDelayedDeliveryAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "delayedDelivery");
        final CompletableFuture<DelayedDeliveryPolicies> future = new CompletableFuture<DelayedDeliveryPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<DelayedDeliveryPolicies>(){

            @Override
            public void completed(DelayedDeliveryPolicies delayedDeliveryPolicies) {
                future.complete(delayedDeliveryPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setDelayedDeliveryMessages(String namespace, DelayedDeliveryPolicies delayedDeliveryPolicies) throws PulsarAdminException {
        try {
            this.setDelayedDeliveryMessagesAsync(namespace, delayedDeliveryPolicies).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setDelayedDeliveryMessagesAsync(String namespace, DelayedDeliveryPolicies delayedDeliveryPolicies) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "delayedDelivery");
        return this.asyncPostRequest(path, Entity.entity(delayedDeliveryPolicies, "application/json"));
    }

    public void removeDelayedDeliveryMessages(String namespace) throws PulsarAdminException {
        try {
            this.removeDelayedDeliveryMessagesAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeDelayedDeliveryMessagesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "delayedDelivery");
        return this.asyncDeleteRequest(path);
    }

    public InactiveTopicPolicies getInactiveTopicPolicies(String namespace) throws PulsarAdminException {
        try {
            return this.getInactiveTopicPoliciesAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "inactiveTopicPolicies");
        final CompletableFuture<InactiveTopicPolicies> future = new CompletableFuture<InactiveTopicPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<InactiveTopicPolicies>(){

            @Override
            public void completed(InactiveTopicPolicies inactiveTopicPolicies) {
                future.complete(inactiveTopicPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setInactiveTopicPolicies(String namespace, InactiveTopicPolicies inactiveTopicPolicies) throws PulsarAdminException {
        try {
            this.setInactiveTopicPoliciesAsync(namespace, inactiveTopicPolicies).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setInactiveTopicPoliciesAsync(String namespace, InactiveTopicPolicies inactiveTopicPolicies) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "inactiveTopicPolicies");
        return this.asyncPostRequest(path, Entity.entity(inactiveTopicPolicies, "application/json"));
    }

    public Integer getDeduplicationSnapshotInterval(String namespace) throws PulsarAdminException {
        try {
            return this.getDeduplicationSnapshotIntervalAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getDeduplicationSnapshotIntervalAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplicationSnapshotInterval");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer interval) {
                future.complete(interval);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setDeduplicationSnapshotInterval(String namespace, Integer interval) throws PulsarAdminException {
        try {
            this.setDeduplicationSnapshotIntervalAsync(namespace, interval).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setDeduplicationSnapshotIntervalAsync(String namespace, Integer interval) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplicationSnapshotInterval");
        return this.asyncPostRequest(path, Entity.entity(interval, "application/json"));
    }

    public void removeDeduplicationSnapshotInterval(String namespace) throws PulsarAdminException {
        this.setDeduplicationSnapshotInterval(namespace, null);
    }

    public CompletableFuture<Void> removeDeduplicationSnapshotIntervalAsync(String namespace) {
        return this.setDeduplicationSnapshotIntervalAsync(namespace, null);
    }

    public Integer getMaxSubscriptionsPerTopic(String namespace) throws PulsarAdminException {
        try {
            return this.getMaxSubscriptionsPerTopicAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxSubscriptionsPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxSubscriptionsPerTopic");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxSubscriptionsPerTopic) {
                future.complete(maxSubscriptionsPerTopic);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxSubscriptionsPerTopic(String namespace, int maxSubscriptionsPerTopic) throws PulsarAdminException {
        try {
            this.setMaxSubscriptionsPerTopicAsync(namespace, maxSubscriptionsPerTopic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxSubscriptionsPerTopicAsync(String namespace, int maxSubscriptionsPerTopic) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxSubscriptionsPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxSubscriptionsPerTopic), "application/json"));
    }

    public void removeMaxSubscriptionsPerTopic(String namespace) throws PulsarAdminException {
        try {
            this.removeMaxSubscriptionsPerTopicAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxSubscriptionsPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxSubscriptionsPerTopic");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxProducersPerTopic(String namespace) throws PulsarAdminException {
        try {
            return this.getMaxProducersPerTopicAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxProducersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxProducersPerTopic(String namespace, int maxProducersPerTopic) throws PulsarAdminException {
        try {
            this.setMaxProducersPerTopicAsync(namespace, maxProducersPerTopic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxProducersPerTopicAsync(String namespace, int maxProducersPerTopic) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxProducersPerTopic), "application/json"));
    }

    public void removeMaxProducersPerTopic(String namespace) throws PulsarAdminException {
        try {
            this.removeMaxProducersPerTopicAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxProducersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumersPerTopic(String namespace) throws PulsarAdminException {
        try {
            return this.getMaxConsumersPerTopicAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxConsumersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxConsumersPerTopic(String namespace, int maxConsumersPerTopic) throws PulsarAdminException {
        try {
            this.setMaxConsumersPerTopicAsync(namespace, maxConsumersPerTopic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxConsumersPerTopicAsync(String namespace, int maxConsumersPerTopic) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumersPerTopic), "application/json"));
    }

    public void removeMaxConsumersPerTopic(String namespace) throws PulsarAdminException {
        try {
            this.removeMaxConsumersPerTopicAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxConsumersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumersPerSubscription(String namespace) throws PulsarAdminException {
        try {
            return this.getMaxConsumersPerSubscriptionAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxConsumersPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxConsumersPerSubscription(String namespace, int maxConsumersPerSubscription) throws PulsarAdminException {
        try {
            this.setMaxConsumersPerSubscriptionAsync(namespace, maxConsumersPerSubscription).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxConsumersPerSubscriptionAsync(String namespace, int maxConsumersPerSubscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumersPerSubscription), "application/json"));
    }

    public void removeMaxConsumersPerSubscription(String namespace) throws PulsarAdminException {
        try {
            this.removeMaxConsumersPerSubscriptionAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxConsumersPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxUnackedMessagesPerConsumer(String namespace) throws PulsarAdminException {
        try {
            return this.getMaxUnackedMessagesPerConsumerAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesPerConsumerAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerConsumer");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxUnackedMessagesPerConsumer(String namespace, int maxUnackedMessagesPerConsumer) throws PulsarAdminException {
        try {
            this.setMaxUnackedMessagesPerConsumerAsync(namespace, maxUnackedMessagesPerConsumer).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxUnackedMessagesPerConsumerAsync(String namespace, int maxUnackedMessagesPerConsumer) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerConsumer");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxUnackedMessagesPerConsumer), "application/json"));
    }

    public void removeMaxUnackedMessagesPerConsumer(String namespace) throws PulsarAdminException {
        try {
            this.removeMaxUnackedMessagesPerConsumerAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesPerConsumerAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerConsumer");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxUnackedMessagesPerSubscription(String namespace) throws PulsarAdminException {
        try {
            return this.getMaxUnackedMessagesPerSubscriptionAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerSubscription");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxUnackedMessagesPerSubscription(String namespace, int maxUnackedMessagesPerSubscription) throws PulsarAdminException {
        try {
            this.setMaxUnackedMessagesPerSubscriptionAsync(namespace, maxUnackedMessagesPerSubscription).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxUnackedMessagesPerSubscriptionAsync(String namespace, int maxUnackedMessagesPerSubscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxUnackedMessagesPerSubscription), "application/json"));
    }

    public void removeMaxUnackedMessagesPerSubscription(String namespace) throws PulsarAdminException {
        try {
            this.removeMaxUnackedMessagesPerSubscriptionAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerSubscription");
        return this.asyncDeleteRequest(path);
    }

    public Long getCompactionThreshold(String namespace) throws PulsarAdminException {
        try {
            return this.getCompactionThresholdAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Long> getCompactionThresholdAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "compactionThreshold");
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.asyncGetRequest(path, new InvocationCallback<Long>(){

            @Override
            public void completed(Long threshold) {
                future.complete(threshold);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setCompactionThreshold(String namespace, long compactionThreshold) throws PulsarAdminException {
        try {
            this.setCompactionThresholdAsync(namespace, compactionThreshold).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setCompactionThresholdAsync(String namespace, long compactionThreshold) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "compactionThreshold");
        return this.asyncPutRequest(path, Entity.entity(Long.valueOf(compactionThreshold), "application/json"));
    }

    public void removeCompactionThreshold(String namespace) throws PulsarAdminException {
        try {
            this.removeCompactionThresholdAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeCompactionThresholdAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "compactionThreshold");
        return this.asyncDeleteRequest(path);
    }

    public long getOffloadThreshold(String namespace) throws PulsarAdminException {
        try {
            return this.getOffloadThresholdAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Long> getOffloadThresholdAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadThreshold");
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.asyncGetRequest(path, new InvocationCallback<Long>(){

            @Override
            public void completed(Long threshold) {
                future.complete(threshold);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setOffloadThreshold(String namespace, long offloadThreshold) throws PulsarAdminException {
        try {
            this.setOffloadThresholdAsync(namespace, offloadThreshold).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setOffloadThresholdAsync(String namespace, long offloadThreshold) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadThreshold");
        return this.asyncPutRequest(path, Entity.entity(Long.valueOf(offloadThreshold), "application/json"));
    }

    public Long getOffloadDeleteLagMs(String namespace) throws PulsarAdminException {
        try {
            return this.getOffloadDeleteLagMsAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Long> getOffloadDeleteLagMsAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.asyncGetRequest(path, new InvocationCallback<Long>(){

            @Override
            public void completed(Long lag) {
                future.complete(lag);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setOffloadDeleteLag(String namespace, long lag, TimeUnit unit) throws PulsarAdminException {
        try {
            this.setOffloadDeleteLagAsync(namespace, lag, unit).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setOffloadDeleteLagAsync(String namespace, long lag, TimeUnit unit) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
        return this.asyncPutRequest(path, Entity.entity(Long.valueOf(TimeUnit.MILLISECONDS.convert(lag, unit)), "application/json"));
    }

    public void clearOffloadDeleteLag(String namespace) throws PulsarAdminException {
        try {
            this.clearOffloadDeleteLagAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> clearOffloadDeleteLagAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
        return this.asyncDeleteRequest(path);
    }

    public SchemaAutoUpdateCompatibilityStrategy getSchemaAutoUpdateCompatibilityStrategy(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaAutoUpdateCompatibilityStrategy");
            return this.request(path).get(SchemaAutoUpdateCompatibilityStrategy.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public void setSchemaAutoUpdateCompatibilityStrategy(String namespace, SchemaAutoUpdateCompatibilityStrategy strategy) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaAutoUpdateCompatibilityStrategy");
            this.request(path).put(Entity.entity(strategy, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public boolean getSchemaValidationEnforced(String namespace) throws PulsarAdminException {
        return this.getSchemaValidationEnforced(namespace, false);
    }

    public CompletableFuture<Boolean> getSchemaValidationEnforcedAsync(String namespace) {
        return this.getSchemaValidationEnforcedAsync(namespace, false);
    }

    public boolean getSchemaValidationEnforced(String namespace, boolean applied) throws PulsarAdminException {
        try {
            return this.getSchemaValidationEnforcedAsync(namespace, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> getSchemaValidationEnforcedAsync(String namespace, boolean applied) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaValidationEnforced");
        path = path.queryParam("applied", applied);
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncGetRequest(path, new InvocationCallback<Boolean>(){

            @Override
            public void completed(Boolean enforced) {
                future.complete(enforced);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setSchemaValidationEnforced(String namespace, boolean schemaValidationEnforced) throws PulsarAdminException {
        try {
            this.setSchemaValidationEnforcedAsync(namespace, schemaValidationEnforced).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSchemaValidationEnforcedAsync(String namespace, boolean schemaValidationEnforced) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaValidationEnforced");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(schemaValidationEnforced), "application/json"));
    }

    public SchemaCompatibilityStrategy getSchemaCompatibilityStrategy(String namespace) throws PulsarAdminException {
        try {
            return this.getSchemaCompatibilityStrategyAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<SchemaCompatibilityStrategy> getSchemaCompatibilityStrategyAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaCompatibilityStrategy");
        final CompletableFuture<SchemaCompatibilityStrategy> future = new CompletableFuture<SchemaCompatibilityStrategy>();
        this.asyncGetRequest(path, new InvocationCallback<SchemaCompatibilityStrategy>(){

            @Override
            public void completed(SchemaCompatibilityStrategy schemaCompatibilityStrategy) {
                future.complete(schemaCompatibilityStrategy);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setSchemaCompatibilityStrategy(String namespace, SchemaCompatibilityStrategy strategy) throws PulsarAdminException {
        try {
            this.setSchemaCompatibilityStrategyAsync(namespace, strategy).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSchemaCompatibilityStrategyAsync(String namespace, SchemaCompatibilityStrategy strategy) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaCompatibilityStrategy");
        return this.asyncPutRequest(path, Entity.entity(strategy, "application/json"));
    }

    public boolean getIsAllowAutoUpdateSchema(String namespace) throws PulsarAdminException {
        try {
            return this.getIsAllowAutoUpdateSchemaAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> getIsAllowAutoUpdateSchemaAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "isAllowAutoUpdateSchema");
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncGetRequest(path, new InvocationCallback<Boolean>(){

            @Override
            public void completed(Boolean allowAutoUpdate) {
                future.complete(allowAutoUpdate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setIsAllowAutoUpdateSchema(String namespace, boolean isAllowAutoUpdateSchema) throws PulsarAdminException {
        try {
            this.setIsAllowAutoUpdateSchemaAsync(namespace, isAllowAutoUpdateSchema).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setIsAllowAutoUpdateSchemaAsync(String namespace, boolean isAllowAutoUpdateSchema) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "isAllowAutoUpdateSchema");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(isAllowAutoUpdateSchema), "application/json"));
    }

    public void setOffloadPolicies(String namespace, OffloadPolicies offloadPolicies) throws PulsarAdminException {
        try {
            this.setOffloadPoliciesAsync(namespace, offloadPolicies).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public void removeOffloadPolicies(String namespace) throws PulsarAdminException {
        try {
            this.removeOffloadPoliciesAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setOffloadPoliciesAsync(String namespace, OffloadPolicies offloadPolicies) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadPolicies");
        return this.asyncPostRequest(path, Entity.entity(offloadPolicies, "application/json"));
    }

    public CompletableFuture<Void> removeOffloadPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "removeOffloadPolicies");
        return this.asyncDeleteRequest(path);
    }

    public OffloadPolicies getOffloadPolicies(String namespace) throws PulsarAdminException {
        try {
            return this.getOffloadPoliciesAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadPolicies");
        final CompletableFuture<OffloadPolicies> future = new CompletableFuture<OffloadPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<OffloadPoliciesImpl>(){

            @Override
            public void completed(OffloadPoliciesImpl offloadPolicies) {
                future.complete(offloadPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public int getMaxTopicsPerNamespace(String namespace) throws PulsarAdminException {
        try {
            return this.getMaxTopicsPerNamespaceAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxTopicsPerNamespaceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxTopicsPerNamespace");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxTopicsPerNamespace) {
                future.complete(maxTopicsPerNamespace);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxTopicsPerNamespace(String namespace, int maxTopicsPerNamespace) throws PulsarAdminException {
        try {
            this.setMaxTopicsPerNamespaceAsync(namespace, maxTopicsPerNamespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxTopicsPerNamespaceAsync(String namespace, int maxTopicsPerNamespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxTopicsPerNamespace");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxTopicsPerNamespace), "application/json"));
    }

    public void removeMaxTopicsPerNamespace(String namespace) throws PulsarAdminException {
        try {
            this.removeMaxTopicsPerNamespaceAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxTopicsPerNamespaceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxTopicsPerNamespace");
        return this.asyncDeleteRequest(path);
    }

    public CompletableFuture<Void> setPropertyAsync(String namespace, String key, String value) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "property", key, value);
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public void setProperty(String namespace, String key, String value) throws PulsarAdminException {
        try {
            this.setPropertyAsync(namespace, key, value).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setPropertiesAsync(String namespace, Map<String, String> properties) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "properties");
        return this.asyncPutRequest(path, Entity.entity(properties, "application/json"));
    }

    public void setProperties(String namespace, Map<String, String> properties) throws PulsarAdminException {
        try {
            this.setPropertiesAsync(namespace, properties).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public String getNamespaceResourceGroup(String namespace) throws PulsarAdminException {
        try {
            return this.getNamespaceResourceGroupAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<String> getPropertyAsync(String namespace, String key) {
        NamespaceName ns = NamespaceName.get(namespace);
        final CompletableFuture<String> future = new CompletableFuture<String>();
        WebTarget path = this.namespacePath(ns, "property", key);
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String value) {
                future.complete(StringUtils.isEmpty(value) ? null : value);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public String getProperty(String namespace, String key) throws PulsarAdminException {
        try {
            return this.getPropertyAsync(namespace, key).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Map<String, String>> getPropertiesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        final CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        WebTarget path = this.namespacePath(ns, "properties");
        this.asyncGetRequest(path, new InvocationCallback<Map<String, String>>(){

            @Override
            public void completed(Map<String, String> value) {
                future.complete(value);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<String> getNamespaceResourceGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "resourcegroup");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String rgName) {
                future.complete(rgName);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Map<String, String> getProperties(String namespace) throws PulsarAdminException {
        try {
            return this.getPropertiesAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public void setNamespaceResourceGroup(String namespace, String resourcegroupname) throws PulsarAdminException {
        try {
            this.setNamespaceResourceGroupAsync(namespace, resourcegroupname).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<String> removePropertyAsync(String namespace, String key) {
        NamespaceName ns = NamespaceName.get(namespace);
        final CompletableFuture<String> future = new CompletableFuture<String>();
        WebTarget path = this.namespacePath(ns, "property", key);
        this.asyncDeleteRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String value) {
                future.complete(StringUtils.isEmpty(value) ? null : value);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public String removeProperty(String namespace, String key) throws PulsarAdminException {
        try {
            return this.removePropertyAsync(namespace, key).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setNamespaceResourceGroupAsync(String namespace, String resourcegroupname) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "resourcegroup");
        return this.asyncPostRequest(path, Entity.entity(resourcegroupname, "application/json"));
    }

    public void removeNamespaceResourceGroup(String namespace) throws PulsarAdminException {
        try {
            this.removeNamespaceResourceGroupAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> clearPropertiesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        CompletableFuture future = new CompletableFuture();
        WebTarget path = this.namespacePath(ns, "properties");
        return this.asyncDeleteRequest(path);
    }

    public void clearProperties(String namespace) throws PulsarAdminException {
        try {
            this.clearPropertiesAsync(namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeNamespaceResourceGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "resourcegroup");
        return this.asyncDeleteRequest(path);
    }

    private WebTarget namespacePath(NamespaceName namespace, String ... parts) {
        WebTarget base = namespace.isV2() ? this.adminV2Namespaces : this.adminNamespaces;
        WebTarget namespacePath = base.path(namespace.toString());
        namespacePath = WebTargets.addParts(namespacePath, parts);
        return namespacePath;
    }
}

