/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.util;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class SchemaUtil {
    public static boolean getJsr310ConversionEnabledFromSchemaInfo(SchemaInfo schemaInfo) {
        if (schemaInfo != null) {
            return Boolean.parseBoolean(schemaInfo.getProperties().getOrDefault("__jsr310ConversionEnabled", "false"));
        }
        return false;
    }

    public static Schema parseAvroSchema(String schemaJson) {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser.parse(schemaJson);
    }

    public static <T> SchemaInfo parseSchemaInfo(SchemaDefinition<T> schemaDefinition, SchemaType schemaType) {
        return SchemaInfoImpl.builder().schema(SchemaUtil.createAvroSchema(schemaDefinition).toString().getBytes(StandardCharsets.UTF_8)).properties(schemaDefinition.getProperties()).name("").type(schemaType).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema createAvroSchema(SchemaDefinition schemaDefinition) {
        Class pojo = schemaDefinition.getPojo();
        if (StringUtils.isNotBlank(schemaDefinition.getJsonDef())) {
            return SchemaUtil.parseAvroSchema(schemaDefinition.getJsonDef());
        }
        if (pojo != null) {
            ThreadLocal validateDefaults = null;
            try {
                Field validateDefaultsField = Schema.class.getDeclaredField("VALIDATE_DEFAULTS");
                validateDefaultsField.setAccessible(true);
                validateDefaults = (ThreadLocal)validateDefaultsField.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Cannot disable validation of default values", e);
            }
            boolean savedValidateDefaults = (Boolean)validateDefaults.get();
            try {
                validateDefaults.set(false);
                Schema schema = SchemaUtil.extractAvroSchema(schemaDefinition, pojo);
                return schema;
            }
            finally {
                validateDefaults.set(savedValidateDefaults);
            }
        }
        throw new RuntimeException("Schema definition must specify pojo class or schema json definition");
    }

    public static Schema extractAvroSchema(SchemaDefinition schemaDefinition, Class pojo) {
        try {
            return SchemaUtil.parseAvroSchema(pojo.getDeclaredField("SCHEMA$").get(null).toString());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ignored) {
            ReflectData.AllowNull reflectData = schemaDefinition.getAlwaysAllowNull() ? new ReflectData.AllowNull() : new ReflectData();
            AvroSchema.addLogicalTypeConversions((ReflectData)reflectData, schemaDefinition.isJsr310ConversionEnabled(), false);
            return reflectData.getSchema((Type)pojo);
        }
    }
}

