/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pulsar.client.admin.Functions;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.policies.data.FunctionStatus;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHandler;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.Dsl;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseBodyPart;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseStatus;
import org.apache.pulsar.shade.org.asynchttpclient.ListenableFuture;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.FilePart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.StringPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsImpl
extends ComponentResource
implements Functions {
    private static final Logger log = LoggerFactory.getLogger(FunctionsImpl.class);
    private final WebTarget functions;
    private final AsyncHttpClient asyncHttpClient;

    public FunctionsImpl(WebTarget web, Authentication auth, AsyncHttpClient asyncHttpClient, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.functions = web.path("/admin/v3/functions");
        this.asyncHttpClient = asyncHttpClient;
    }

    @Override
    public List<String> getFunctions(String tenant, String namespace) throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path(tenant).path(namespace)).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public FunctionConfig getFunction(String tenant, String namespace, String function) throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path(tenant).path(namespace).path(function)).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(FunctionConfig.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public FunctionStatus getFunctionStatus(String tenant, String namespace, String function) throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path(tenant).path(namespace).path(function).path("status")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(FunctionStatus.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData getFunctionStatus(String tenant, String namespace, String function, int id) throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(id)).path("status")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData getFunctionStats(String tenant, String namespace, String function, int id) throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(id)).path("stats")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public FunctionStats getFunctionStats(String tenant, String namespace, String function) throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path(tenant).path(namespace).path(function).path("stats")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(FunctionStats.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createFunction(FunctionConfig functionConfig, String fileName) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.org.asynchttpclient.Response response;
            RequestBuilder builder = (RequestBuilder)Dsl.post(this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("functionConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(functionConfig), "application/json"));
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            if ((response = (org.apache.pulsar.shade.org.asynchttpclient.Response)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).get()).getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build());
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl) throws PulsarAdminException {
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("functionConfig", (Object)new Gson().toJson(functionConfig), MediaType.APPLICATION_JSON_TYPE));
            this.request(this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName())).post(Entity.entity(mp, "multipart/form-data"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteFunction(String cluster, String namespace, String function) throws PulsarAdminException {
        try {
            this.request(this.functions.path(cluster).path(namespace).path(function)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateFunction(FunctionConfig functionConfig, String fileName) throws PulsarAdminException {
        this.updateFunction(functionConfig, fileName, null);
    }

    @Override
    public void updateFunction(FunctionConfig functionConfig, String fileName, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            org.apache.pulsar.shade.org.asynchttpclient.Response response;
            RequestBuilder builder = (RequestBuilder)Dsl.put(this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("functionConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(functionConfig), "application/json"));
            if (updateOptions != null) {
                builder.addBodyPart(new StringPart("updateOptions", ObjectMapperFactory.getThreadLocal().writeValueAsString(updateOptions), "application/json"));
            }
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            if ((response = (org.apache.pulsar.shade.org.asynchttpclient.Response)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).get()).getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build());
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("functionConfig", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString(functionConfig), MediaType.APPLICATION_JSON_TYPE));
            if (updateOptions != null) {
                mp.bodyPart(new FormDataBodyPart("updateOptions", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString(updateOptions), MediaType.APPLICATION_JSON_TYPE));
            }
            this.request(this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName())).put(Entity.entity(mp, "multipart/form-data"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl) throws PulsarAdminException {
        this.updateFunctionWithUrl(functionConfig, pkgUrl, null);
    }

    @Override
    public String triggerFunction(String tenant, String namespace, String functionName, String topic, String triggerValue, String triggerFile) throws PulsarAdminException {
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            if (triggerFile != null) {
                mp.bodyPart(new FileDataBodyPart("dataStream", new File(triggerFile), MediaType.APPLICATION_OCTET_STREAM_TYPE));
            }
            if (triggerValue != null) {
                mp.bodyPart(new FormDataBodyPart("data", (Object)triggerValue, MediaType.TEXT_PLAIN_TYPE));
            }
            if (topic != null && !topic.isEmpty()) {
                mp.bodyPart(new FormDataBodyPart("topic", (Object)topic, MediaType.TEXT_PLAIN_TYPE));
            }
            return this.request(this.functions.path(tenant).path(namespace).path(functionName).path("trigger")).post(Entity.entity(mp, "multipart/form-data"), String.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void restartFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.request(this.functions.path(tenant).path(namespace).path(functionName).path(Integer.toString(instanceId)).path("restart")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void restartFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.request(this.functions.path(tenant).path(namespace).path(functionName).path("restart")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void stopFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.request(this.functions.path(tenant).path(namespace).path(functionName).path(Integer.toString(instanceId)).path("stop")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void stopFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.request(this.functions.path(tenant).path(namespace).path(functionName).path("stop")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void startFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.request(this.functions.path(tenant).path(namespace).path(functionName).path(Integer.toString(instanceId)).path("start")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void startFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.request(this.functions.path(tenant).path(namespace).path(functionName).path("start")).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void uploadFunction(String sourceFile, String path) throws PulsarAdminException {
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.post(this.functions.path("upload").getUri().toASCIIString()).addBodyPart(new FilePart("data", new File(sourceFile), "application/octet-stream"))).addBodyPart(new StringPart("path", path, "text/plain"));
            org.apache.pulsar.shade.org.asynchttpclient.Response response = (org.apache.pulsar.shade.org.asynchttpclient.Response)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).get();
            if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build());
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void downloadFunction(String destinationPath, String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.downloadFile(destinationPath, this.functions.path(tenant).path(namespace).path(functionName).path("download"));
    }

    @Override
    public void downloadFunction(String destinationPath, String path) throws PulsarAdminException {
        this.downloadFile(destinationPath, this.functions.path("download").queryParam("path", path));
    }

    private void downloadFile(String destinationPath, WebTarget target) throws PulsarAdminException {
        try {
            File file = new File(destinationPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            final FileChannel os = new FileOutputStream(new File(destinationPath)).getChannel();
            RequestBuilder builder = Dsl.get(target.getUri().toASCIIString());
            ListenableFuture<HttpResponseStatus> whenStatusCode = this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build(), new AsyncHandler<HttpResponseStatus>(){
                private HttpResponseStatus status;

                @Override
                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    if (this.status.getStatusCode() != Response.Status.OK.getStatusCode()) {
                        return AsyncHandler.State.ABORT;
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    os.write(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public HttpResponseStatus onCompleted() throws Exception {
                    return this.status;
                }

                @Override
                public void onThrowable(Throwable t) {
                }
            });
            HttpResponseStatus status = (HttpResponseStatus)whenStatusCode.get();
            os.close();
            if (status.getStatusCode() < 200 || status.getStatusCode() >= 300) {
                throw this.getApiException(Response.status(status.getStatusCode()).entity(status.getStatusText()).build());
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<ConnectorDefinition> getConnectorsList() throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path("connectors")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(new GenericType<List<ConnectorDefinition>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Set<String> getSources() throws PulsarAdminException {
        return this.getConnectorsList().stream().filter(c -> !StringUtils.isEmpty(c.getSourceClass())).map(ConnectorDefinition::getName).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getSinks() throws PulsarAdminException {
        return this.getConnectorsList().stream().filter(c -> !StringUtils.isEmpty(c.getSinkClass())).map(ConnectorDefinition::getName).collect(Collectors.toSet());
    }

    public List<WorkerInfo> getCluster() throws PulsarAdminException {
        try {
            return this.request(this.functions.path("cluster")).get(new GenericType<List<WorkerInfo>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public FunctionState getFunctionState(String tenant, String namespace, String function, String key) throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path(tenant).path(namespace).path(function).path("state").path(key)).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return response.readEntity(FunctionState.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void putFunctionState(String tenant, String namespace, String function, FunctionState state) throws PulsarAdminException {
        try {
            RequestBuilder builder = Dsl.post(this.functions.path(tenant).path(namespace).path(function).path("state").path(state.getKey()).getUri().toASCIIString());
            builder.addBodyPart(new StringPart("state", ObjectMapperFactory.getThreadLocal().writeValueAsString(state), "application/json"));
            org.apache.pulsar.shade.org.asynchttpclient.Response response = (org.apache.pulsar.shade.org.asynchttpclient.Response)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).get();
            if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build());
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

