/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerEventListener;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.util.ConsumerName;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.GrowableArrayBlockingQueue;
import org.apache.pulsar.shade.com.google.common.collect.Queues;

public abstract class ConsumerBase<T>
extends HandlerState
implements Consumer<T> {
    protected final String subscription;
    protected final ConsumerConfigurationData<T> conf;
    protected final String consumerName;
    protected final CompletableFuture<Consumer<T>> subscribeFuture;
    protected final MessageListener<T> listener;
    protected final ConsumerEventListener consumerEventListener;
    protected final ExecutorService listenerExecutor;
    final BlockingQueue<Message<T>> incomingMessages;
    protected final ConcurrentLinkedQueue<CompletableFuture<Message<T>>> pendingReceives;
    protected int maxReceiverQueueSize;
    protected final Schema<T> schema;
    protected final ConsumerInterceptors<T> interceptors;

    protected ConsumerBase(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, int receiverQueueSize, ExecutorService listenerExecutor, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors interceptors) {
        super(client, topic);
        this.maxReceiverQueueSize = receiverQueueSize;
        this.subscription = conf.getSubscriptionName();
        this.conf = conf;
        this.consumerName = conf.getConsumerName() == null ? ConsumerName.generateRandomName() : conf.getConsumerName();
        this.subscribeFuture = subscribeFuture;
        this.listener = conf.getMessageListener();
        this.consumerEventListener = conf.getConsumerEventListener();
        this.incomingMessages = new GrowableArrayBlockingQueue<Message<T>>();
        this.listenerExecutor = listenerExecutor;
        this.pendingReceives = Queues.newConcurrentLinkedQueue();
        this.schema = schema;
        this.interceptors = interceptors;
    }

    public Message<T> receive() throws PulsarClientException {
        if (this.listener != null) {
            throw new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set");
        }
        switch (this.getState()) {
            case Ready: 
            case Connecting: {
                break;
            }
            case Closing: 
            case Closed: {
                throw new PulsarClientException.AlreadyClosedException("Consumer already closed");
            }
            case Terminated: {
                throw new PulsarClientException.AlreadyClosedException("Topic was terminated");
            }
            case Failed: 
            case Uninitialized: {
                throw new PulsarClientException.NotConnectedException();
            }
        }
        return this.internalReceive();
    }

    public CompletableFuture<Message<T>> receiveAsync() {
        if (this.listener != null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set"));
        }
        switch (this.getState()) {
            case Ready: 
            case Connecting: {
                break;
            }
            case Closing: 
            case Closed: {
                return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Consumer already closed"));
            }
            case Terminated: {
                return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topic was terminated"));
            }
            case Failed: 
            case Uninitialized: {
                return FutureUtil.failedFuture((Throwable)new PulsarClientException.NotConnectedException());
            }
        }
        return this.internalReceiveAsync();
    }

    protected abstract Message<T> internalReceive() throws PulsarClientException;

    protected abstract CompletableFuture<Message<T>> internalReceiveAsync();

    public Message<T> receive(int timeout, TimeUnit unit) throws PulsarClientException {
        if (this.conf.getReceiverQueueSize() == 0) {
            throw new PulsarClientException.InvalidConfigurationException("Can't use receive with timeout, if the queue size is 0");
        }
        if (this.listener != null) {
            throw new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set");
        }
        switch (this.getState()) {
            case Ready: 
            case Connecting: {
                break;
            }
            case Closing: 
            case Closed: {
                throw new PulsarClientException.AlreadyClosedException("Consumer already closed");
            }
            case Terminated: {
                throw new PulsarClientException.AlreadyClosedException("Topic was terminated");
            }
            case Failed: 
            case Uninitialized: {
                throw new PulsarClientException.NotConnectedException();
            }
        }
        return this.internalReceive(timeout, unit);
    }

    protected abstract Message<T> internalReceive(int var1, TimeUnit var2) throws PulsarClientException;

    public void acknowledge(Message<?> message) throws PulsarClientException {
        try {
            this.acknowledge(message.getMessageId());
        }
        catch (NullPointerException npe) {
            throw new PulsarClientException.InvalidMessageException(npe.getMessage());
        }
    }

    public void acknowledge(MessageId messageId) throws PulsarClientException {
        try {
            this.acknowledgeAsync(messageId).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void acknowledgeCumulative(Message<?> message) throws PulsarClientException {
        try {
            this.acknowledgeCumulative(message.getMessageId());
        }
        catch (NullPointerException npe) {
            throw new PulsarClientException.InvalidMessageException(npe.getMessage());
        }
    }

    public void acknowledgeCumulative(MessageId messageId) throws PulsarClientException {
        try {
            this.acknowledgeCumulativeAsync(messageId).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> acknowledgeAsync(Message<?> message) {
        try {
            return this.acknowledgeAsync(message.getMessageId());
        }
        catch (NullPointerException npe) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidMessageException(npe.getMessage()));
        }
    }

    public CompletableFuture<Void> acknowledgeCumulativeAsync(Message<?> message) {
        try {
            return this.acknowledgeCumulativeAsync(message.getMessageId());
        }
        catch (NullPointerException npe) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidMessageException(npe.getMessage()));
        }
    }

    public CompletableFuture<Void> acknowledgeAsync(MessageId messageId) {
        return this.doAcknowledge(messageId, PulsarApi.CommandAck.AckType.Individual, Collections.emptyMap());
    }

    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId messageId) {
        if (!this.isCumulativeAcknowledgementAllowed(this.conf.getSubscriptionType())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Cannot use cumulative acks on a non-exclusive subscription"));
        }
        return this.doAcknowledge(messageId, PulsarApi.CommandAck.AckType.Cumulative, Collections.emptyMap());
    }

    public void negativeAcknowledge(Message<?> message) {
        this.negativeAcknowledge(message.getMessageId());
    }

    protected abstract CompletableFuture<Void> doAcknowledge(MessageId var1, PulsarApi.CommandAck.AckType var2, Map<String, Long> var3);

    public void unsubscribe() throws PulsarClientException {
        try {
            this.unsubscribeAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public abstract CompletableFuture<Void> unsubscribeAsync();

    public void close() throws PulsarClientException {
        try {
            this.closeAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public abstract CompletableFuture<Void> closeAsync();

    public MessageId getLastMessageId() throws PulsarClientException {
        try {
            return this.getLastMessageIdAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public abstract CompletableFuture<MessageId> getLastMessageIdAsync();

    private boolean isCumulativeAcknowledgementAllowed(SubscriptionType type) {
        return SubscriptionType.Shared != type;
    }

    protected PulsarApi.CommandSubscribe.SubType getSubType() {
        SubscriptionType type = this.conf.getSubscriptionType();
        switch (type) {
            case Exclusive: {
                return PulsarApi.CommandSubscribe.SubType.Exclusive;
            }
            case Shared: {
                return PulsarApi.CommandSubscribe.SubType.Shared;
            }
            case Failover: {
                return PulsarApi.CommandSubscribe.SubType.Failover;
            }
            case Key_Shared: {
                return PulsarApi.CommandSubscribe.SubType.Key_Shared;
            }
        }
        return null;
    }

    public abstract int getAvailablePermits();

    public abstract int numMessagesInQueue();

    public CompletableFuture<Consumer<T>> subscribeFuture() {
        return this.subscribeFuture;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    protected abstract void redeliverUnacknowledgedMessages(Set<MessageId> var1);

    public String toString() {
        return "ConsumerBase{subscription='" + this.subscription + '\'' + ", consumerName='" + this.consumerName + '\'' + ", topic='" + this.topic + '\'' + '}';
    }

    protected void setMaxReceiverQueueSize(int newSize) {
        this.maxReceiverQueueSize = newSize;
    }

    protected Message<T> beforeConsume(Message<T> message) {
        if (this.interceptors != null) {
            return this.interceptors.beforeConsume(this, message);
        }
        return message;
    }

    protected void onAcknowledge(MessageId messageId, Throwable exception) {
        if (this.interceptors != null) {
            this.interceptors.onAcknowledge(this, messageId, exception);
        }
    }

    protected void onAcknowledgeCumulative(MessageId messageId, Throwable exception) {
        if (this.interceptors != null) {
            this.interceptors.onAcknowledgeCumulative(this, messageId, exception);
        }
    }

    protected void onNegativeAcksSend(Set<MessageId> messageIds) {
        if (this.interceptors != null) {
            this.interceptors.onNegativeAcksSend(this, messageIds);
        }
    }

    protected void onAckTimeoutSend(Set<MessageId> messageIds) {
        if (this.interceptors != null) {
            this.interceptors.onAckTimeoutSend(this, messageIds);
        }
    }

    static enum ConsumerType {
        PARTITIONED,
        NON_PARTITIONED;

    }
}

