/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class LongSchema
implements Schema<Long> {
    private static final LongSchema INSTANCE = new LongSchema();
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("INT64").setType(SchemaType.INT64).setSchema(new byte[0]);

    public static LongSchema of() {
        return INSTANCE;
    }

    public void validate(byte[] message) {
        if (message.length != 8) {
            throw new SchemaSerializationException("Size of data received by LongSchema is not 8");
        }
    }

    public byte[] encode(Long data) {
        if (null == data) {
            return null;
        }
        return new byte[]{(byte)(data >>> 56), (byte)(data >>> 48), (byte)(data >>> 40), (byte)(data >>> 32), (byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), data.byteValue()};
    }

    public Long decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        long value = 0L;
        for (byte b : bytes) {
            value <<= 8;
            value |= (long)(b & 0xFF);
        }
        return value;
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

