/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonRecord;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class GenericJsonReader
implements SchemaReader<GenericRecord> {
    private final ObjectMapper objectMapper;
    private final byte[] schemaVersion;
    private final List<Field> fields;

    public GenericJsonReader(List<Field> fields) {
        this.fields = fields;
        this.schemaVersion = null;
        this.objectMapper = new ObjectMapper();
    }

    public GenericJsonReader(byte[] schemaVersion, List<Field> fields) {
        this.objectMapper = new ObjectMapper();
        this.fields = fields;
        this.schemaVersion = schemaVersion;
    }

    public GenericJsonRecord read(byte[] bytes) {
        try {
            JsonNode jn = this.objectMapper.readTree(new String(bytes, StandardCharsets.UTF_8));
            return new GenericJsonRecord(this.schemaVersion, this.fields, jn);
        }
        catch (IOException ioe) {
            throw new SchemaSerializationException((Throwable)ioe);
        }
    }
}

