/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSslContextRefresher {
    private volatile SslContext sslContext;
    private boolean tlsAllowInsecureConnection;
    private String tlsTrustCertsFilePath;
    private AuthenticationDataProvider authData;
    private static final Logger LOG = LoggerFactory.getLogger(ClientSslContextRefresher.class);

    public ClientSslContextRefresher(boolean allowInsecure, String trustCertsFilePath, AuthenticationDataProvider authData) throws IOException, GeneralSecurityException {
        this.tlsAllowInsecureConnection = allowInsecure;
        this.tlsTrustCertsFilePath = trustCertsFilePath;
        this.authData = authData;
        this.sslContext = authData != null && authData.hasDataForTls() ? SecurityUtility.createNettySslContextForClient(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath, (X509Certificate[])authData.getTlsCertificates(), authData.getTlsPrivateKey()) : SecurityUtility.createNettySslContextForClient(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath);
    }

    public SslContext get() {
        if (this.authData != null && this.authData.hasDataForTls()) {
            try {
                this.sslContext = SecurityUtility.createNettySslContextForClient(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath, (X509Certificate[])this.authData.getTlsCertificates(), this.authData.getTlsPrivateKey());
            }
            catch (IOException | GeneralSecurityException e) {
                LOG.error("Exception occured while trying to refresh sslContext: ", (Throwable)e);
            }
        }
        return this.sslContext;
    }
}

