/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.Namespaces;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;

public class NamespacesImpl
extends BaseResource
implements Namespaces {
    private final WebTarget adminNamespaces;
    private final WebTarget adminV2Namespaces;

    public NamespacesImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminNamespaces = web.path("/admin/namespaces");
        this.adminV2Namespaces = web.path("/admin/v2/namespaces");
    }

    @Override
    public List<String> getNamespaces(String tenant) throws PulsarAdminException {
        try {
            WebTarget path = this.adminV2Namespaces.path(tenant);
            return this.request(path).get(new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<String> getNamespaces(String tenant, String cluster) throws PulsarAdminException {
        try {
            WebTarget path = this.adminNamespaces.path(tenant).path(cluster);
            return this.request(path).get(new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<String> getTopics(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            String action = ns.isV2() ? "topics" : "destinations";
            WebTarget path = this.namespacePath(ns, action);
            return this.request(path).get(new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Policies getPolicies(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, new String[0]);
            return this.request(path).get(Policies.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createNamespace(String namespace, Set<String> clusters) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, new String[0]);
            if (ns.isV2()) {
                Policies policies = new Policies();
                policies.replication_clusters = clusters;
                this.request(path).put(Entity.entity(policies, "application/json"), ErrorData.class);
            } else {
                this.request(path).put(Entity.entity("", "application/json"), ErrorData.class);
                this.setNamespaceReplicationClusters(namespace, clusters);
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createNamespace(String namespace, int numBundles) throws PulsarAdminException {
        this.createNamespace(namespace, new BundlesData(numBundles));
    }

    @Override
    public void createNamespace(String namespace, Policies policies) throws PulsarAdminException {
        NamespaceName ns = NamespaceName.get(namespace);
        Preconditions.checkArgument(ns.isV2(), "Create namespace with policies is only supported on newer namespaces");
        try {
            WebTarget path = this.namespacePath(ns, new String[0]);
            this.request(path).put(Entity.entity(policies, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createNamespace(String namespace, BundlesData bundlesData) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, new String[0]);
            if (ns.isV2()) {
                Policies policies = new Policies();
                policies.bundles = bundlesData;
                this.request(path).put(Entity.entity(policies, "application/json"), ErrorData.class);
            } else {
                this.request(path).put(Entity.entity(bundlesData, "application/json"), ErrorData.class);
            }
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createNamespace(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, new String[0]);
            this.request(path).put(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteNamespace(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, new String[0]);
            this.request(path).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteNamespaceBundle(String namespace, String bundleRange) throws PulsarAdminException {
        try {
            this.deleteNamespaceBundleAsync(namespace, bundleRange).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteNamespaceBundleAsync(String namespace, String bundleRange) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundleRange);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<String, Set<AuthAction>> getPermissions(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "permissions");
            return this.request(path).get(new GenericType<Map<String, Set<AuthAction>>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void grantPermissionOnNamespace(String namespace, String role, Set<AuthAction> actions) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "permissions", role);
            this.request(path).post(Entity.entity(actions, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void revokePermissionsOnNamespace(String namespace, String role) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "permissions", role);
            this.request(path).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void grantPermissionOnSubscription(String namespace, String subscription, Set<String> roles) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "permissions", "subscription", subscription);
            this.request(path).post(Entity.entity(roles, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void revokePermissionOnSubscription(String namespace, String subscription, String role) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "permissions", subscription, role);
            this.request(path).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<String> getNamespaceReplicationClusters(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "replication");
            return this.request(path).get(new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setNamespaceReplicationClusters(String namespace, Set<String> clusterIds) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "replication");
            this.request(path).post(Entity.entity(clusterIds, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public int getNamespaceMessageTTL(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "messageTTL");
            return this.request(path).get(new GenericType<Integer>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setNamespaceMessageTTL(String namespace, int ttlInSeconds) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "messageTTL");
            this.request(path).post(Entity.entity(Integer.valueOf(ttlInSeconds), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setNamespaceAntiAffinityGroup(String namespace, String namespaceAntiAffinityGroup) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "antiAffinity");
            this.request(path).post(Entity.entity(namespaceAntiAffinityGroup, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public String getNamespaceAntiAffinityGroup(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "antiAffinity");
            return this.request(path).get(new GenericType<String>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<String> getAntiAffinityNamespaces(String tenant, String cluster, String namespaceAntiAffinityGroup) throws PulsarAdminException {
        try {
            WebTarget path = this.adminNamespaces.path(cluster).path("antiAffinity").path(namespaceAntiAffinityGroup);
            return this.request(path.queryParam("property", tenant)).get(new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteNamespaceAntiAffinityGroup(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "antiAffinity");
            this.request(path).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setDeduplicationStatus(String namespace, boolean enableDeduplication) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "deduplication");
            this.request(path).post(Entity.entity(Boolean.valueOf(enableDeduplication), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "backlogQuotaMap");
            return this.request(path).get(new GenericType<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setBacklogQuota(String namespace, BacklogQuota backlogQuota) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "backlogQuota");
            this.request(path).post(Entity.entity(backlogQuota, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void removeBacklogQuota(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "backlogQuota");
            this.request(path.queryParam("backlogQuotaType", BacklogQuota.BacklogQuotaType.destination_storage.toString())).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setPersistence(String namespace, PersistencePolicies persistence) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "persistence");
            this.request(path).post(Entity.entity(persistence, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setBookieAffinityGroup(String namespace, BookieAffinityGroupData bookieAffinityGroup) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
            this.request(path).post(Entity.entity(bookieAffinityGroup, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteBookieAffinityGroup(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
            this.request(path).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public BookieAffinityGroupData getBookieAffinityGroup(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
            return this.request(path).get(BookieAffinityGroupData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public PersistencePolicies getPersistence(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "persistence");
            return this.request(path).get(PersistencePolicies.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setRetention(String namespace, RetentionPolicies retention) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "retention");
            this.request(path).post(Entity.entity(retention, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public RetentionPolicies getRetention(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "retention");
            return this.request(path).get(RetentionPolicies.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void unload(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "unload");
            this.request(path).put(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public String getReplicationConfigVersion(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "configversion");
            return this.request(path).get(String.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void unloadNamespaceBundle(String namespace, String bundle) throws PulsarAdminException {
        try {
            this.unloadNamespaceBundleAsync(namespace, bundle).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
    }

    @Override
    public CompletableFuture<Void> unloadNamespaceBundleAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void splitNamespaceBundle(String namespace, String bundle, boolean unloadSplitBundles, String splitAlgorithmName) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, bundle, "split");
            this.request(path.queryParam("unload", Boolean.toString(unloadSplitBundles)).queryParam("splitAlgorithmName", splitAlgorithmName)).put(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setPublishRate(String namespace, PublishRate publishMsgRate) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "publishRate");
            this.request(path).post(Entity.entity(publishMsgRate, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public PublishRate getPublishRate(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "publishRate");
            return this.request(path).get(PublishRate.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "dispatchRate");
            this.request(path).post(Entity.entity(dispatchRate, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public DispatchRate getDispatchRate(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "dispatchRate");
            return this.request(path).get(DispatchRate.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setSubscribeRate(String namespace, SubscribeRate subscribeRate) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "subscribeRate");
            this.request(path).post(Entity.entity(subscribeRate, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SubscribeRate getSubscribeRate(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "subscribeRate");
            return this.request(path).get(SubscribeRate.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setSubscriptionDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
            this.request(path).post(Entity.entity(dispatchRate, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public DispatchRate getSubscriptionDispatchRate(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
            return this.request(path).get(DispatchRate.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setReplicatorDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
            this.request(path).post(Entity.entity(dispatchRate, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public DispatchRate getReplicatorDispatchRate(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
            return this.request(path).get(DispatchRate.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void clearNamespaceBacklog(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "clearBacklog");
            this.request(path).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void clearNamespaceBacklogForSubscription(String namespace, String subscription) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "clearBacklog", subscription);
            this.request(path).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void clearNamespaceBundleBacklog(String namespace, String bundle) throws PulsarAdminException {
        try {
            this.clearNamespaceBundleBacklogAsync(namespace, bundle).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
    }

    @Override
    public CompletableFuture<Void> clearNamespaceBundleBacklogAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "clearBacklog");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void clearNamespaceBundleBacklogForSubscription(String namespace, String bundle, String subscription) throws PulsarAdminException {
        try {
            this.clearNamespaceBundleBacklogForSubscriptionAsync(namespace, bundle, subscription).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
    }

    @Override
    public CompletableFuture<Void> clearNamespaceBundleBacklogForSubscriptionAsync(String namespace, String bundle, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "clearBacklog", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void unsubscribeNamespace(String namespace, String subscription) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "unsubscribe", subscription);
            this.request(path).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void unsubscribeNamespaceBundle(String namespace, String bundle, String subscription) throws PulsarAdminException {
        try {
            this.unsubscribeNamespaceBundleAsync(namespace, bundle, subscription).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
    }

    @Override
    public CompletableFuture<Void> unsubscribeNamespaceBundleAsync(String namespace, String bundle, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "unsubscribe", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void setSubscriptionAuthMode(String namespace, SubscriptionAuthMode subscriptionAuthMode) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "subscriptionAuthMode");
            this.request(path).post(Entity.entity(subscriptionAuthMode, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setEncryptionRequiredStatus(String namespace, boolean encryptionRequired) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "encryptionRequired");
            this.request(path).post(Entity.entity(Boolean.valueOf(encryptionRequired), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public DelayedDeliveryPolicies getDelayedDelivery(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "delayedDelivery");
            return this.request(path).get(DelayedDeliveryPolicies.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setDelayedDeliveryMessages(String namespace, DelayedDeliveryPolicies delayedDeliveryPolicies) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "delayedDelivery");
            this.request(path).post(Entity.entity(delayedDeliveryPolicies, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public int getMaxProducersPerTopic(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
            return this.request(path).get(Integer.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setMaxProducersPerTopic(String namespace, int maxProducersPerTopic) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
            this.request(path).post(Entity.entity(Integer.valueOf(maxProducersPerTopic), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public int getMaxConsumersPerTopic(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
            return this.request(path).get(Integer.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setMaxConsumersPerTopic(String namespace, int maxConsumersPerTopic) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
            this.request(path).post(Entity.entity(Integer.valueOf(maxConsumersPerTopic), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public int getMaxConsumersPerSubscription(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
            return this.request(path).get(Integer.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setMaxConsumersPerSubscription(String namespace, int maxConsumersPerSubscription) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
            this.request(path).post(Entity.entity(Integer.valueOf(maxConsumersPerSubscription), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public long getCompactionThreshold(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "compactionThreshold");
            return this.request(path).get(Long.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setCompactionThreshold(String namespace, long compactionThreshold) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "compactionThreshold");
            this.request(path).put(Entity.entity(Long.valueOf(compactionThreshold), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public long getOffloadThreshold(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "offloadThreshold");
            return this.request(path).get(Long.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setOffloadThreshold(String namespace, long offloadThreshold) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "offloadThreshold");
            this.request(path).put(Entity.entity(Long.valueOf(offloadThreshold), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Long getOffloadDeleteLagMs(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
            return this.request(path).get(Long.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setOffloadDeleteLag(String namespace, long lag, TimeUnit unit) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
            this.request(path).put(Entity.entity(Long.valueOf(TimeUnit.MILLISECONDS.convert(lag, unit)), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void clearOffloadDeleteLag(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
            this.request(path).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SchemaAutoUpdateCompatibilityStrategy getSchemaAutoUpdateCompatibilityStrategy(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaAutoUpdateCompatibilityStrategy");
            return this.request(path).get(SchemaAutoUpdateCompatibilityStrategy.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setSchemaAutoUpdateCompatibilityStrategy(String namespace, SchemaAutoUpdateCompatibilityStrategy strategy) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaAutoUpdateCompatibilityStrategy");
            this.request(path).put(Entity.entity(strategy, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public boolean getSchemaValidationEnforced(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaValidationEnforced");
            return this.request(path).get(Boolean.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setSchemaValidationEnforced(String namespace, boolean schemaValidationEnforced) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaValidationEnforced");
            this.request(path).post(Entity.entity(Boolean.valueOf(schemaValidationEnforced), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SchemaCompatibilityStrategy getSchemaCompatibilityStrategy(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaCompatibilityStrategy");
            return this.request(path).get(SchemaCompatibilityStrategy.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setSchemaCompatibilityStrategy(String namespace, SchemaCompatibilityStrategy strategy) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaCompatibilityStrategy");
            this.request(path).put(Entity.entity(strategy, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public boolean getIsAllowAutoUpdateSchema(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "isAllowAutoUpdateSchema");
            return this.request(path).get(Boolean.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setIsAllowAutoUpdateSchema(String namespace, boolean isAllowAutoUpdateSchema) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "isAllowAutoUpdateSchema");
            this.request(path).post(Entity.entity(Boolean.valueOf(isAllowAutoUpdateSchema), "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setOffloadPolicies(String namespace, OffloadPolicies offloadPolicies) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "offloadPolicies");
            this.request(path).post(Entity.entity(offloadPolicies, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public OffloadPolicies getOffloadPolicies(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "offloadPolicies");
            return this.request(path).get(OffloadPolicies.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    private WebTarget namespacePath(NamespaceName namespace, String ... parts) {
        WebTarget base = namespace.isV2() ? this.adminV2Namespaces : this.adminNamespaces;
        WebTarget namespacePath = base.path(namespace.toString());
        namespacePath = WebTargets.addParts(namespacePath, parts);
        return namespacePath;
    }
}

