/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import org.apache.pulsar.client.admin.Bookies;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class BookiesImpl
extends BaseResource
implements Bookies {
    private final WebTarget adminBookies;

    public BookiesImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminBookies = web.path("/admin/v2/bookies");
    }

    @Override
    public BookiesRackConfiguration getBookiesRackInfo() throws PulsarAdminException {
        try {
            return this.request(this.adminBookies.path("racks-info")).get(BookiesRackConfiguration.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public BookieInfo getBookieRackInfo(String bookieAddress) throws PulsarAdminException {
        try {
            return this.request(this.adminBookies.path("racks-info").path(bookieAddress)).get(BookieInfo.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteBookieRackInfo(String bookieAddress) throws PulsarAdminException {
        try {
            this.request(this.adminBookies.path("racks-info").path(bookieAddress)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateBookieRackInfo(String bookieAddress, String group, BookieInfo bookieInfo) throws PulsarAdminException {
        try {
            this.request(this.adminBookies.path("racks-info").path(bookieAddress).queryParam("group", group)).post(Entity.entity(bookieInfo, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

