/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.ResourceQuotas;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class ResourceQuotasImpl
extends BaseResource
implements ResourceQuotas {
    private final WebTarget adminQuotas;
    private final WebTarget adminV2Quotas;

    public ResourceQuotasImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminQuotas = web.path("/admin/resource-quotas");
        this.adminV2Quotas = web.path("/admin/v2/resource-quotas");
    }

    @Override
    public ResourceQuota getDefaultResourceQuota() throws PulsarAdminException {
        try {
            return this.request(this.adminV2Quotas).get(ResourceQuota.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setDefaultResourceQuota(ResourceQuota quota) throws PulsarAdminException {
        try {
            this.request(this.adminV2Quotas).post(Entity.entity(quota, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public ResourceQuota getNamespaceBundleResourceQuota(String namespace, String bundle) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, bundle);
            return this.request(path).get(ResourceQuota.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setNamespaceBundleResourceQuota(String namespace, String bundle, ResourceQuota quota) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, bundle);
            this.request(path).post(Entity.entity(quota, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void resetNamespaceBundleResourceQuota(String namespace, String bundle) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, bundle);
            this.request(path).delete();
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    private WebTarget namespacePath(NamespaceName namespace, String ... parts) {
        WebTarget base = namespace.isV2() ? this.adminV2Quotas : this.adminQuotas;
        WebTarget namespacePath = base.path(namespace.toString());
        namespacePath = WebTargets.addParts(namespacePath, parts);
        return namespacePath;
    }
}

