/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.time.Clock;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class ClientBuilderImpl
implements ClientBuilder {
    ClientConfigurationData conf;

    public ClientBuilderImpl() {
        this(new ClientConfigurationData());
    }

    public ClientBuilderImpl(ClientConfigurationData conf) {
        this.conf = conf;
    }

    public PulsarClient build() throws PulsarClientException {
        if (StringUtils.isBlank(this.conf.getServiceUrl()) && this.conf.getServiceUrlProvider() == null) {
            throw new IllegalArgumentException("service URL or service URL provider needs to be specified on the ClientBuilder object.");
        }
        if (StringUtils.isNotBlank(this.conf.getServiceUrl()) && this.conf.getServiceUrlProvider() != null) {
            throw new IllegalArgumentException("Can only chose one way service URL or service URL provider.");
        }
        if (this.conf.getServiceUrlProvider() != null) {
            if (StringUtils.isBlank(this.conf.getServiceUrlProvider().getServiceUrl())) {
                throw new IllegalArgumentException("Cannot get service url from service url provider.");
            }
            this.conf.setServiceUrl(this.conf.getServiceUrlProvider().getServiceUrl());
        }
        PulsarClientImpl client = new PulsarClientImpl(this.conf);
        if (this.conf.getServiceUrlProvider() != null) {
            this.conf.getServiceUrlProvider().initialize((PulsarClient)client);
        }
        return client;
    }

    public ClientBuilder clone() {
        return new ClientBuilderImpl(this.conf.clone());
    }

    public ClientBuilder loadConf(Map<String, Object> config) {
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, ClientConfigurationData.class);
        return this;
    }

    public ClientBuilder serviceUrl(String serviceUrl) {
        if (StringUtils.isBlank(serviceUrl)) {
            throw new IllegalArgumentException("Param serviceUrl must not be blank.");
        }
        this.conf.setServiceUrl(serviceUrl);
        if (!this.conf.isUseTls()) {
            this.enableTls(serviceUrl.startsWith("pulsar+ssl") || serviceUrl.startsWith("https"));
        }
        return this;
    }

    public ClientBuilder serviceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        if (serviceUrlProvider == null) {
            throw new IllegalArgumentException("Param serviceUrlProvider must not be null.");
        }
        this.conf.setServiceUrlProvider(serviceUrlProvider);
        return this;
    }

    public ClientBuilder listenerName(String listenerName) {
        if (StringUtils.isBlank(listenerName)) {
            throw new IllegalArgumentException("Param listenerName must not be blank.");
        }
        this.conf.setListenerName(StringUtils.trim(listenerName));
        return this;
    }

    public ClientBuilder authentication(Authentication authentication) {
        this.conf.setAuthentication(authentication);
        return this;
    }

    public ClientBuilder authentication(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthPluginClassName(authPluginClassName);
        this.conf.setAuthParams(authParamsString);
        this.conf.setAuthParamMap(null);
        this.conf.setAuthentication(AuthenticationFactory.create((String)authPluginClassName, (String)authParamsString));
        return this;
    }

    public ClientBuilder authentication(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthPluginClassName(authPluginClassName);
        this.conf.setAuthParamMap(authParams);
        this.conf.setAuthParams(null);
        this.conf.setAuthentication(AuthenticationFactory.create((String)authPluginClassName, authParams));
        return this;
    }

    public ClientBuilder operationTimeout(int operationTimeout, TimeUnit unit) {
        this.conf.setOperationTimeoutMs(unit.toMillis(operationTimeout));
        return this;
    }

    public ClientBuilder ioThreads(int numIoThreads) {
        this.conf.setNumIoThreads(numIoThreads);
        return this;
    }

    public ClientBuilder listenerThreads(int numListenerThreads) {
        this.conf.setNumListenerThreads(numListenerThreads);
        return this;
    }

    public ClientBuilder connectionsPerBroker(int connectionsPerBroker) {
        this.conf.setConnectionsPerBroker(connectionsPerBroker);
        return this;
    }

    public ClientBuilder enableTcpNoDelay(boolean useTcpNoDelay) {
        this.conf.setUseTcpNoDelay(useTcpNoDelay);
        return this;
    }

    public ClientBuilder enableTls(boolean useTls) {
        this.conf.setUseTls(useTls);
        return this;
    }

    public ClientBuilder enableTlsHostnameVerification(boolean enableTlsHostnameVerification) {
        this.conf.setTlsHostnameVerificationEnable(enableTlsHostnameVerification);
        return this;
    }

    public ClientBuilder tlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.conf.setTlsTrustCertsFilePath(tlsTrustCertsFilePath);
        return this;
    }

    public ClientBuilder allowTlsInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.conf.setTlsAllowInsecureConnection(tlsAllowInsecureConnection);
        return this;
    }

    public ClientBuilder useKeyStoreTls(boolean useKeyStoreTls) {
        this.conf.setUseKeyStoreTls(useKeyStoreTls);
        return this;
    }

    public ClientBuilder sslProvider(String sslProvider) {
        this.conf.setSslProvider(sslProvider);
        return this;
    }

    public ClientBuilder tlsTrustStoreType(String tlsTrustStoreType) {
        this.conf.setTlsTrustStoreType(tlsTrustStoreType);
        return this;
    }

    public ClientBuilder tlsTrustStorePath(String tlsTrustStorePath) {
        this.conf.setTlsTrustStorePath(tlsTrustStorePath);
        return this;
    }

    public ClientBuilder tlsTrustStorePassword(String tlsTrustStorePassword) {
        this.conf.setTlsTrustStorePassword(tlsTrustStorePassword);
        return this;
    }

    public ClientBuilder tlsCiphers(Set<String> tlsCiphers) {
        this.conf.setTlsCiphers(tlsCiphers);
        return this;
    }

    public ClientBuilder tlsProtocols(Set<String> tlsProtocols) {
        this.conf.setTlsProtocols(tlsProtocols);
        return this;
    }

    public ClientBuilder statsInterval(long statsInterval, TimeUnit unit) {
        this.conf.setStatsIntervalSeconds(unit.toSeconds(statsInterval));
        return this;
    }

    public ClientBuilder maxConcurrentLookupRequests(int concurrentLookupRequests) {
        this.conf.setConcurrentLookupRequest(concurrentLookupRequests);
        return this;
    }

    public ClientBuilder maxLookupRequests(int maxLookupRequests) {
        this.conf.setMaxLookupRequest(maxLookupRequests);
        return this;
    }

    public ClientBuilder maxLookupRedirects(int maxLookupRedirects) {
        this.conf.setMaxLookupRedirects(maxLookupRedirects);
        return this;
    }

    public ClientBuilder maxNumberOfRejectedRequestPerConnection(int maxNumberOfRejectedRequestPerConnection) {
        this.conf.setMaxNumberOfRejectedRequestPerConnection(maxNumberOfRejectedRequestPerConnection);
        return this;
    }

    public ClientBuilder keepAliveInterval(int keepAliveInterval, TimeUnit unit) {
        this.conf.setKeepAliveIntervalSeconds((int)unit.toSeconds(keepAliveInterval));
        return this;
    }

    public ClientBuilder connectionTimeout(int duration, TimeUnit unit) {
        this.conf.setConnectionTimeoutMs((int)unit.toMillis(duration));
        return this;
    }

    public ClientBuilder startingBackoffInterval(long duration, TimeUnit unit) {
        this.conf.setInitialBackoffIntervalNanos(unit.toNanos(duration));
        return this;
    }

    public ClientBuilder maxBackoffInterval(long duration, TimeUnit unit) {
        this.conf.setMaxBackoffIntervalNanos(unit.toNanos(duration));
        return this;
    }

    public ClientBuilder enableBusyWait(boolean enableBusyWait) {
        this.conf.setEnableBusyWait(enableBusyWait);
        return this;
    }

    public ClientConfigurationData getClientConfigurationData() {
        return this.conf;
    }

    public ClientBuilder memoryLimit(long memoryLimit, SizeUnit unit) {
        this.conf.setMemoryLimitBytes(unit.toBytes(memoryLimit));
        return this;
    }

    public ClientBuilder clock(Clock clock) {
        this.conf.setClock(clock);
        return this;
    }

    public ClientBuilder proxyServiceUrl(String proxyServiceUrl, ProxyProtocol proxyProtocol) {
        if (StringUtils.isNotBlank(proxyServiceUrl) && proxyProtocol == null) {
            throw new IllegalArgumentException("proxyProtocol must be present with proxyServiceUrl");
        }
        this.conf.setProxyServiceUrl(proxyServiceUrl);
        this.conf.setProxyProtocol(proxyProtocol);
        return this;
    }

    public ClientBuilder enableTransaction(boolean enableTransaction) {
        this.conf.setEnableTransaction(enableTransaction);
        return this;
    }
}

