/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.shade.org.asynchttpclient.HostStats;

public class ClientStats {
    private final Map<String, HostStats> statsPerHost;

    public ClientStats(Map<String, HostStats> statsPerHost) {
        this.statsPerHost = Collections.unmodifiableMap(statsPerHost);
    }

    public Map<String, HostStats> getStatsPerHost() {
        return this.statsPerHost;
    }

    public long getTotalConnectionCount() {
        return this.statsPerHost.values().stream().mapToLong(HostStats::getHostConnectionCount).sum();
    }

    public long getTotalActiveConnectionCount() {
        return this.statsPerHost.values().stream().mapToLong(HostStats::getHostActiveConnectionCount).sum();
    }

    public long getTotalIdleConnectionCount() {
        return this.statsPerHost.values().stream().mapToLong(HostStats::getHostIdleConnectionCount).sum();
    }

    public String toString() {
        return "There are " + this.getTotalConnectionCount() + " total connections, " + this.getTotalActiveConnectionCount() + " are active and " + this.getTotalIdleConnectionCount() + " are idle.";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientStats that = (ClientStats)o;
        return Objects.equals(this.statsPerHost, that.statsPerHost);
    }

    public int hashCode() {
        return Objects.hashCode(this.statsPerHost);
    }
}

