/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pulsar.client.impl.AbstractBatchMessageContainer;
import org.apache.pulsar.client.impl.BatchMessageContainerImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchMessageKeyBasedContainer
extends AbstractBatchMessageContainer {
    private final Map<String, BatchMessageContainerImpl> batches = new HashMap<String, BatchMessageContainerImpl>();
    private static final Logger log = LoggerFactory.getLogger(BatchMessageKeyBasedContainer.class);

    BatchMessageKeyBasedContainer() {
    }

    @Override
    public boolean add(MessageImpl<?> msg, SendCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] add message to batch, num messages in batch so far is {}", new Object[]{this.topicName, this.producer.getProducerName(), this.numMessagesInBatch});
        }
        String key = this.getKey(msg);
        BatchMessageContainerImpl batchMessageContainer = this.batches.computeIfAbsent(key, __ -> new BatchMessageContainerImpl(this.producer));
        batchMessageContainer.add(msg, callback);
        if (!batchMessageContainer.isEmpty()) {
            ++this.numMessagesInBatch;
            this.currentBatchSizeBytes += (long)msg.getDataBuffer().readableBytes();
        }
        this.tryUpdateTimestamp();
        return this.isBatchFull();
    }

    public void clear() {
        this.clearTimestamp();
        this.numMessagesInBatch = 0;
        this.currentBatchSizeBytes = 0L;
        this.batches.clear();
        this.currentTxnidMostBits = -1L;
        this.currentTxnidLeastBits = -1L;
        this.batchAllocatedSizeBytes = 0;
    }

    public boolean isEmpty() {
        return this.batches.isEmpty();
    }

    public void discard(Exception ex) {
        this.batches.forEach((k, v) -> v.discard(ex));
        this.clear();
    }

    public boolean isMultiBatches() {
        return true;
    }

    @Override
    public int getBatchAllocatedSizeBytes() {
        return this.batches.values().stream().mapToInt(AbstractBatchMessageContainer::getBatchAllocatedSizeBytes).sum();
    }

    @Override
    public List<ProducerImpl.OpSendMsg> createOpSendMsgs() throws IOException {
        try {
            this.batches.values().forEach(batchMessageContainer -> batchMessageContainer.setLowestSequenceId(batchMessageContainer.getHighestSequenceId()));
            return this.batches.values().stream().sorted((o1, o2) -> (int)(o1.getLowestSequenceId() - o2.getLowestSequenceId())).map(batchMessageContainer -> {
                try {
                    return batchMessageContainer.createOpSendMsg();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean hasSameSchema(MessageImpl<?> msg) {
        String key = this.getKey(msg);
        BatchMessageContainerImpl batchMessageContainer = this.batches.get(key);
        return batchMessageContainer == null || batchMessageContainer.hasSameSchema(msg);
    }

    private String getKey(MessageImpl<?> msg) {
        if (msg.hasOrderingKey()) {
            return Base64.getEncoder().encodeToString(msg.getOrderingKey());
        }
        return msg.getKey();
    }
}

