/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pulsar.common.util;

// CHECKSTYLE.OFF: IllegalImport
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;
// CHECKSTYLE.ON: IllegalImport

public class DirectMemoryUtils {

    /**
     * PlatformDependent.maxDirectMemory can be inaccurate if java property `org.apache.pulsar.shade.io.netty.maxDirectMemory` are setted.
     * Cache the result in this field.
     */
    private static final long JVM_MAX_DIRECT_MEMORY = PlatformDependent.estimateMaxDirectMemory();

    public static long jvmMaxDirectMemory() {
        return JVM_MAX_DIRECT_MEMORY;
    }

}
