/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.checksum;

import com.scurrilous.circe.checksum.IntHash;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Java9IntHash
implements IntHash {
    private static final Logger log = LoggerFactory.getLogger(Java9IntHash.class);
    static final boolean HAS_JAVA9_CRC32C;
    private static final Method UPDATE_BYTES;
    private static final Method UPDATE_DIRECT_BYTEBUFFER;
    private static final String CRC32C_CLASS_NAME = "java.util.zip.CRC32C";
    private static final FastThreadLocal<byte[]> TL_BUFFER;

    @Override
    public int calculate(ByteBuf buffer) {
        return this.resume(0, buffer);
    }

    @Override
    public int calculate(ByteBuf buffer, int offset, int len) {
        return this.resume(0, buffer, offset, len);
    }

    private int updateDirectByteBuffer(int current, long address, int offset, int length) {
        try {
            return (Integer)UPDATE_DIRECT_BYTEBUFFER.invoke(null, current, address, offset, offset + length);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int resume(int current, byte[] array, int offset, int length) {
        current ^= 0xFFFFFFFF;
        current = Java9IntHash.updateBytes(current, array, offset, length);
        return ~current;
    }

    @Override
    public boolean acceptsMemoryAddressBuffer() {
        return true;
    }

    private static int updateBytes(int current, byte[] array, int offset, int length) {
        try {
            return (Integer)UPDATE_BYTES.invoke(null, current, array, offset, offset + length);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int resume(int current, ByteBuf buffer) {
        return this.resume(current, buffer, buffer.readerIndex(), buffer.readableBytes());
    }

    @Override
    public int resume(int current, ByteBuf buffer, int offset, int len) {
        current ^= 0xFFFFFFFF;
        if (buffer.hasMemoryAddress()) {
            current = this.updateDirectByteBuffer(current, buffer.memoryAddress(), offset, len);
        } else if (buffer.hasArray()) {
            int arrayOffset = buffer.arrayOffset() + offset;
            current = Java9IntHash.updateBytes(current, buffer.array(), arrayOffset, len);
        } else {
            byte[] b = TL_BUFFER.get();
            int toRead = len;
            int loopOffset = offset;
            while (toRead > 0) {
                int length = Math.min(toRead, b.length);
                buffer.getBytes(loopOffset, b, 0, length);
                current = Java9IntHash.updateBytes(current, b, 0, length);
                toRead -= length;
                loopOffset += length;
            }
        }
        return ~current;
    }

    static {
        TL_BUFFER = new FastThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[4096];
            }
        };
        boolean hasJava9CRC32C = false;
        Method updateBytes = null;
        Method updateDirectByteBuffer = null;
        try {
            Class<?> c = Class.forName(CRC32C_CLASS_NAME);
            updateBytes = c.getDeclaredMethod("updateBytes", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
            updateBytes.setAccessible(true);
            updateDirectByteBuffer = c.getDeclaredMethod("updateDirectByteBuffer", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
            updateDirectByteBuffer.setAccessible(true);
            hasJava9CRC32C = true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to use reflected methods: ", (Throwable)e);
            }
            updateBytes = null;
            updateDirectByteBuffer = null;
        }
        HAS_JAVA9_CRC32C = hasJava9CRC32C;
        UPDATE_BYTES = updateBytes;
        UPDATE_DIRECT_BYTEBUFFER = updateDirectByteBuffer;
    }
}

