/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.opentelemetry.api.OpenTelemetry;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.common.tls.InetAddressUtils;
import org.apache.pulsar.common.util.DefaultPulsarSslFactory;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class ClientBuilderImpl
implements ClientBuilder {
    ClientConfigurationData conf;

    public ClientBuilderImpl() {
        this(new ClientConfigurationData());
    }

    public ClientBuilderImpl(ClientConfigurationData conf) {
        this.conf = conf;
    }

    public PulsarClient build() throws PulsarClientException {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.conf.getServiceUrl()) || this.conf.getServiceUrlProvider() != null, "service URL or service URL provider needs to be specified on the ClientBuilder object.");
        Preconditions.checkArgument(StringUtils.isBlank(this.conf.getServiceUrl()) || this.conf.getServiceUrlProvider() == null, "Can only chose one way service URL or service URL provider.");
        if (this.conf.getServiceUrlProvider() != null) {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.conf.getServiceUrlProvider().getServiceUrl()), "Cannot get service url from service url provider.");
            this.conf.setServiceUrl(this.conf.getServiceUrlProvider().getServiceUrl());
        }
        PulsarClientImpl client = new PulsarClientImpl(this.conf);
        if (this.conf.getServiceUrlProvider() != null) {
            this.conf.getServiceUrlProvider().initialize((PulsarClient)client);
        }
        return client;
    }

    public ClientBuilder clone() {
        return new ClientBuilderImpl(this.conf.clone());
    }

    public ClientBuilder loadConf(Map<String, Object> config) {
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, ClientConfigurationData.class);
        this.setAuthenticationFromPropsIfAvailable(this.conf);
        return this;
    }

    public ClientBuilder serviceUrl(String serviceUrl) {
        Preconditions.checkArgument(StringUtils.isNotBlank(serviceUrl), "Param serviceUrl must not be blank.");
        this.conf.setServiceUrl(serviceUrl);
        if (!this.conf.isUseTls()) {
            this.enableTls(serviceUrl.startsWith("pulsar+ssl") || serviceUrl.startsWith("https"));
        }
        return this;
    }

    public ClientBuilder serviceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        Preconditions.checkArgument(serviceUrlProvider != null, "Param serviceUrlProvider must not be null.");
        this.conf.setServiceUrlProvider(serviceUrlProvider);
        return this;
    }

    public ClientBuilder listenerName(String listenerName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(listenerName), "Param listenerName must not be blank.");
        this.conf.setListenerName(StringUtils.trim(listenerName));
        return this;
    }

    public ClientBuilder connectionMaxIdleSeconds(int connectionMaxIdleSeconds) {
        Preconditions.checkArgument(connectionMaxIdleSeconds < 0 || connectionMaxIdleSeconds >= 15, "Connection idle detect interval seconds at least 15.");
        this.conf.setConnectionMaxIdleSeconds(connectionMaxIdleSeconds);
        return this;
    }

    public ClientBuilder authentication(Authentication authentication) {
        this.conf.setAuthentication(authentication);
        return this;
    }

    public ClientBuilder openTelemetry(OpenTelemetry openTelemetry) {
        this.conf.setOpenTelemetry(openTelemetry);
        return this;
    }

    public ClientBuilder authentication(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthPluginClassName(authPluginClassName);
        this.conf.setAuthParams(authParamsString);
        this.conf.setAuthParamMap(null);
        this.conf.setAuthentication(AuthenticationFactory.create((String)authPluginClassName, (String)authParamsString));
        return this;
    }

    public ClientBuilder authentication(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthPluginClassName(authPluginClassName);
        this.conf.setAuthParamMap(authParams);
        this.conf.setAuthParams(null);
        this.conf.setAuthentication(AuthenticationFactory.create((String)authPluginClassName, authParams));
        return this;
    }

    private void setAuthenticationFromPropsIfAvailable(ClientConfigurationData clientConfig) {
        String authPluginClass = clientConfig.getAuthPluginClassName();
        String authParams = clientConfig.getAuthParams();
        Map<String, String> authParamMap = clientConfig.getAuthParamMap();
        if (StringUtils.isBlank(authPluginClass) || StringUtils.isBlank(authParams) && authParamMap == null) {
            return;
        }
        try {
            if (StringUtils.isNotBlank(authParams)) {
                this.authentication(authPluginClass, authParams);
            } else if (authParamMap != null) {
                this.authentication(authPluginClass, authParamMap);
            }
        }
        catch (PulsarClientException.UnsupportedAuthenticationException ex) {
            throw new RuntimeException("Failed to create authentication: " + ex.getMessage(), ex);
        }
    }

    public ClientBuilder operationTimeout(int operationTimeout, TimeUnit unit) {
        Preconditions.checkArgument(operationTimeout >= 0, "operationTimeout needs to be >= 0");
        this.conf.setOperationTimeoutMs(unit.toMillis(operationTimeout));
        return this;
    }

    public ClientBuilder lookupTimeout(int lookupTimeout, TimeUnit unit) {
        this.conf.setLookupTimeoutMs(unit.toMillis(lookupTimeout));
        return this;
    }

    public ClientBuilder ioThreads(int numIoThreads) {
        Preconditions.checkArgument(numIoThreads > 0, "ioThreads needs to be > 0");
        this.conf.setNumIoThreads(numIoThreads);
        return this;
    }

    public ClientBuilder listenerThreads(int numListenerThreads) {
        Preconditions.checkArgument(numListenerThreads > 0, "listenerThreads needs to be > 0");
        this.conf.setNumListenerThreads(numListenerThreads);
        return this;
    }

    public ClientBuilder connectionsPerBroker(int connectionsPerBroker) {
        Preconditions.checkArgument(connectionsPerBroker >= 0, "connectionsPerBroker needs to be >= 0");
        this.conf.setConnectionsPerBroker(connectionsPerBroker);
        return this;
    }

    public ClientBuilder enableTcpNoDelay(boolean useTcpNoDelay) {
        this.conf.setUseTcpNoDelay(useTcpNoDelay);
        return this;
    }

    public ClientBuilder enableTls(boolean useTls) {
        this.conf.setUseTls(useTls);
        return this;
    }

    public ClientBuilder tlsKeyFilePath(String tlsKeyFilePath) {
        this.conf.setTlsKeyFilePath(tlsKeyFilePath);
        return this;
    }

    public ClientBuilder tlsCertificateFilePath(String tlsCertificateFilePath) {
        this.conf.setTlsCertificateFilePath(tlsCertificateFilePath);
        return this;
    }

    public ClientBuilder enableTlsHostnameVerification(boolean enableTlsHostnameVerification) {
        this.conf.setTlsHostnameVerificationEnable(enableTlsHostnameVerification);
        return this;
    }

    public ClientBuilder tlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.conf.setTlsTrustCertsFilePath(tlsTrustCertsFilePath);
        return this;
    }

    public ClientBuilder allowTlsInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.conf.setTlsAllowInsecureConnection(tlsAllowInsecureConnection);
        return this;
    }

    public ClientBuilder useKeyStoreTls(boolean useKeyStoreTls) {
        this.conf.setUseKeyStoreTls(useKeyStoreTls);
        return this;
    }

    public ClientBuilder sslProvider(String sslProvider) {
        this.conf.setSslProvider(sslProvider);
        return this;
    }

    public ClientBuilder tlsKeyStoreType(String tlsKeyStoreType) {
        this.conf.setTlsKeyStoreType(tlsKeyStoreType);
        return this;
    }

    public ClientBuilder tlsKeyStorePath(String tlsTrustStorePath) {
        this.conf.setTlsKeyStorePath(tlsTrustStorePath);
        return this;
    }

    public ClientBuilder tlsKeyStorePassword(String tlsKeyStorePassword) {
        this.conf.setTlsKeyStorePassword(tlsKeyStorePassword);
        return this;
    }

    public ClientBuilder tlsTrustStoreType(String tlsTrustStoreType) {
        this.conf.setTlsTrustStoreType(tlsTrustStoreType);
        return this;
    }

    public ClientBuilder tlsTrustStorePath(String tlsTrustStorePath) {
        this.conf.setTlsTrustStorePath(tlsTrustStorePath);
        return this;
    }

    public ClientBuilder tlsTrustStorePassword(String tlsTrustStorePassword) {
        this.conf.setTlsTrustStorePassword(tlsTrustStorePassword);
        return this;
    }

    public ClientBuilder tlsCiphers(Set<String> tlsCiphers) {
        this.conf.setTlsCiphers(tlsCiphers);
        return this;
    }

    public ClientBuilder tlsProtocols(Set<String> tlsProtocols) {
        this.conf.setTlsProtocols(tlsProtocols);
        return this;
    }

    public ClientBuilder statsInterval(long statsInterval, TimeUnit unit) {
        this.conf.setStatsIntervalSeconds(unit.toSeconds(statsInterval));
        return this;
    }

    public ClientBuilder maxConcurrentLookupRequests(int concurrentLookupRequests) {
        this.conf.setConcurrentLookupRequest(concurrentLookupRequests);
        return this;
    }

    public ClientBuilder maxLookupRequests(int maxLookupRequests) {
        this.conf.setMaxLookupRequest(maxLookupRequests);
        return this;
    }

    public ClientBuilder maxLookupRedirects(int maxLookupRedirects) {
        this.conf.setMaxLookupRedirects(maxLookupRedirects);
        return this;
    }

    public ClientBuilder maxNumberOfRejectedRequestPerConnection(int maxNumberOfRejectedRequestPerConnection) {
        this.conf.setMaxNumberOfRejectedRequestPerConnection(maxNumberOfRejectedRequestPerConnection);
        return this;
    }

    public ClientBuilder keepAliveInterval(int keepAliveInterval, TimeUnit unit) {
        this.conf.setKeepAliveIntervalSeconds((int)unit.toSeconds(keepAliveInterval));
        return this;
    }

    public ClientBuilder connectionTimeout(int duration, TimeUnit unit) {
        this.conf.setConnectionTimeoutMs((int)unit.toMillis(duration));
        return this;
    }

    public ClientBuilder startingBackoffInterval(long duration, TimeUnit unit) {
        this.conf.setInitialBackoffIntervalNanos(unit.toNanos(duration));
        return this;
    }

    public ClientBuilder maxBackoffInterval(long duration, TimeUnit unit) {
        this.conf.setMaxBackoffIntervalNanos(unit.toNanos(duration));
        return this;
    }

    public ClientBuilder enableBusyWait(boolean enableBusyWait) {
        this.conf.setEnableBusyWait(enableBusyWait);
        return this;
    }

    public ClientConfigurationData getClientConfigurationData() {
        return this.conf;
    }

    public ClientBuilder memoryLimit(long memoryLimit, SizeUnit unit) {
        this.conf.setMemoryLimitBytes(unit.toBytes(memoryLimit));
        return this;
    }

    public ClientBuilder clock(Clock clock) {
        this.conf.setClock(clock);
        return this;
    }

    public ClientBuilder proxyServiceUrl(String proxyServiceUrl, ProxyProtocol proxyProtocol) {
        if (StringUtils.isNotBlank(proxyServiceUrl)) {
            Preconditions.checkArgument(proxyProtocol != null, "proxyProtocol must be present with proxyServiceUrl");
        }
        this.conf.setProxyServiceUrl(proxyServiceUrl);
        this.conf.setProxyProtocol(proxyProtocol);
        return this;
    }

    public ClientBuilder enableTransaction(boolean enableTransaction) {
        this.conf.setEnableTransaction(enableTransaction);
        return this;
    }

    public ClientBuilder dnsLookupBind(String address, int port) {
        Preconditions.checkArgument(port >= 0 && port <= 65535, "DnsLookBindPort need to be within the range of 0 and 65535");
        this.conf.setDnsLookupBindAddress(address);
        this.conf.setDnsLookupBindPort(port);
        return this;
    }

    public ClientBuilder dnsServerAddresses(List<InetSocketAddress> addresses) {
        for (InetSocketAddress address : addresses) {
            String ip = address.getHostString();
            Preconditions.checkArgument(InetAddressUtils.isIPv4Address(ip) || InetAddressUtils.isIPv6Address(ip), "DnsServerAddresses need to be valid IPv4 or IPv6 addresses");
        }
        this.conf.setDnsServerAddresses(addresses);
        return this;
    }

    public ClientBuilder socks5ProxyAddress(InetSocketAddress socks5ProxyAddress) {
        this.conf.setSocks5ProxyAddress(socks5ProxyAddress);
        return this;
    }

    public ClientBuilder socks5ProxyUsername(String socks5ProxyUsername) {
        this.conf.setSocks5ProxyUsername(socks5ProxyUsername);
        return this;
    }

    public ClientBuilder socks5ProxyPassword(String socks5ProxyPassword) {
        this.conf.setSocks5ProxyPassword(socks5ProxyPassword);
        return this;
    }

    public ClientBuilder sslFactoryPlugin(String sslFactoryPlugin) {
        if (StringUtils.isBlank(sslFactoryPlugin)) {
            this.conf.setSslFactoryPlugin(DefaultPulsarSslFactory.class.getName());
        } else {
            this.conf.setSslFactoryPlugin(sslFactoryPlugin);
        }
        return this;
    }

    public ClientBuilder sslFactoryPluginParams(String sslFactoryPluginParams) {
        this.conf.setSslFactoryPluginParams(sslFactoryPluginParams);
        return this;
    }

    public ClientBuilder autoCertRefreshSeconds(int autoCertRefreshSeconds) {
        this.conf.setAutoCertRefreshSeconds(autoCertRefreshSeconds);
        return this;
    }

    public ClientBuilder description(String description) {
        if (description != null && description.length() > 64) {
            throw new IllegalArgumentException("description should be at most 64 characters");
        }
        this.conf.setDescription(description);
        return this;
    }

    public ClientBuilder lookupProperties(Map<String, String> properties) {
        this.conf.setLookupProperties(properties);
        return this;
    }
}

