/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.IOException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public class PulsarClientException
extends IOException {
    public PulsarClientException(String msg) {
        super(msg);
    }

    public PulsarClientException(Throwable t) {
        super(t);
    }

    public static Throwable wrap(Throwable t, String msg) {
        msg = msg + "\n" + t.getMessage();
        if (t instanceof TimeoutException) {
            return new TimeoutException(msg);
        }
        if (t instanceof InvalidConfigurationException) {
            return new InvalidConfigurationException(msg);
        }
        if (t instanceof AuthenticationException) {
            return new AuthenticationException(msg);
        }
        if (t instanceof IncompatibleSchemaException) {
            return new IncompatibleSchemaException(msg);
        }
        if (t instanceof TooManyRequestsException) {
            return new TooManyRequestsException(msg);
        }
        if (t instanceof LookupException) {
            return new LookupException(msg);
        }
        if (t instanceof ConnectException) {
            return new ConnectException(msg);
        }
        if (t instanceof AlreadyClosedException) {
            return new AlreadyClosedException(msg);
        }
        if (t instanceof TopicTerminatedException) {
            return new TopicTerminatedException(msg);
        }
        if (t instanceof AuthorizationException) {
            return new AuthorizationException(msg);
        }
        if (t instanceof GettingAuthenticationDataException) {
            return new GettingAuthenticationDataException(msg);
        }
        if (t instanceof UnsupportedAuthenticationException) {
            return new UnsupportedAuthenticationException(msg);
        }
        if (t instanceof BrokerPersistenceException) {
            return new BrokerPersistenceException(msg);
        }
        if (t instanceof BrokerMetadataException) {
            return new BrokerMetadataException(msg);
        }
        if (t instanceof ProducerBusyException) {
            return new ProducerBusyException(msg);
        }
        if (t instanceof ConsumerBusyException) {
            return new ConsumerBusyException(msg);
        }
        if (t instanceof NotConnectedException) {
            return new NotConnectedException();
        }
        if (t instanceof InvalidMessageException) {
            return new InvalidMessageException(msg);
        }
        if (t instanceof InvalidTopicNameException) {
            return new InvalidTopicNameException(msg);
        }
        if (t instanceof NotSupportedException) {
            return new NotSupportedException(msg);
        }
        if (t instanceof ProducerQueueIsFullError) {
            return new ProducerQueueIsFullError(msg);
        }
        if (t instanceof ProducerBlockedQuotaExceededError) {
            return new ProducerBlockedQuotaExceededError(msg);
        }
        if (t instanceof ProducerBlockedQuotaExceededException) {
            return new ProducerBlockedQuotaExceededException(msg);
        }
        if (t instanceof ChecksumException) {
            return new ChecksumException(msg);
        }
        if (t instanceof CryptoException) {
            return new CryptoException(msg);
        }
        if (t instanceof PulsarClientException) {
            return new PulsarClientException(msg);
        }
        if (t instanceof CompletionException) {
            return t;
        }
        if (t instanceof RuntimeException) {
            return new RuntimeException(msg, t.getCause());
        }
        if (t instanceof InterruptedException) {
            return t;
        }
        if (t instanceof ExecutionException) {
            return t;
        }
        return t;
    }

    public static PulsarClientException unwrap(Throwable t) {
        if (t instanceof PulsarClientException) {
            return (PulsarClientException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof InterruptedException) {
            return new PulsarClientException(t);
        }
        if (!(t instanceof ExecutionException)) {
            return new PulsarClientException(t);
        }
        Throwable cause = t.getCause();
        String msg = cause.getMessage();
        if (cause instanceof TimeoutException) {
            return new TimeoutException(msg);
        }
        if (cause instanceof InvalidConfigurationException) {
            return new InvalidConfigurationException(msg);
        }
        if (cause instanceof AuthenticationException) {
            return new AuthenticationException(msg);
        }
        if (cause instanceof IncompatibleSchemaException) {
            return new IncompatibleSchemaException(msg);
        }
        if (cause instanceof TooManyRequestsException) {
            return new TooManyRequestsException(msg);
        }
        if (cause instanceof LookupException) {
            return new LookupException(msg);
        }
        if (cause instanceof ConnectException) {
            return new ConnectException(msg);
        }
        if (cause instanceof AlreadyClosedException) {
            return new AlreadyClosedException(msg);
        }
        if (cause instanceof TopicTerminatedException) {
            return new TopicTerminatedException(msg);
        }
        if (cause instanceof AuthorizationException) {
            return new AuthorizationException(msg);
        }
        if (cause instanceof GettingAuthenticationDataException) {
            return new GettingAuthenticationDataException(msg);
        }
        if (cause instanceof UnsupportedAuthenticationException) {
            return new UnsupportedAuthenticationException(msg);
        }
        if (cause instanceof BrokerPersistenceException) {
            return new BrokerPersistenceException(msg);
        }
        if (cause instanceof BrokerMetadataException) {
            return new BrokerMetadataException(msg);
        }
        if (cause instanceof ProducerBusyException) {
            return new ProducerBusyException(msg);
        }
        if (cause instanceof ConsumerBusyException) {
            return new ConsumerBusyException(msg);
        }
        if (cause instanceof NotConnectedException) {
            return new NotConnectedException();
        }
        if (cause instanceof InvalidMessageException) {
            return new InvalidMessageException(msg);
        }
        if (cause instanceof InvalidTopicNameException) {
            return new InvalidTopicNameException(msg);
        }
        if (cause instanceof NotSupportedException) {
            return new NotSupportedException(msg);
        }
        if (cause instanceof ProducerQueueIsFullError) {
            return new ProducerQueueIsFullError(msg);
        }
        if (cause instanceof ProducerBlockedQuotaExceededError) {
            return new ProducerBlockedQuotaExceededError(msg);
        }
        if (cause instanceof ProducerBlockedQuotaExceededException) {
            return new ProducerBlockedQuotaExceededException(msg);
        }
        if (cause instanceof ChecksumException) {
            return new ChecksumException(msg);
        }
        if (cause instanceof CryptoException) {
            return new CryptoException(msg);
        }
        return new PulsarClientException(t);
    }

    public static class CryptoException
    extends PulsarClientException {
        public CryptoException(String msg) {
            super(msg);
        }
    }

    public static class ChecksumException
    extends PulsarClientException {
        public ChecksumException(String msg) {
            super(msg);
        }
    }

    public static class ProducerBlockedQuotaExceededException
    extends PulsarClientException {
        public ProducerBlockedQuotaExceededException(String msg) {
            super(msg);
        }
    }

    public static class ProducerBlockedQuotaExceededError
    extends PulsarClientException {
        public ProducerBlockedQuotaExceededError(String msg) {
            super(msg);
        }
    }

    public static class ProducerQueueIsFullError
    extends PulsarClientException {
        public ProducerQueueIsFullError(String msg) {
            super(msg);
        }
    }

    public static class NotSupportedException
    extends PulsarClientException {
        public NotSupportedException(String msg) {
            super(msg);
        }
    }

    public static class InvalidTopicNameException
    extends PulsarClientException {
        public InvalidTopicNameException(String msg) {
            super(msg);
        }
    }

    public static class InvalidMessageException
    extends PulsarClientException {
        public InvalidMessageException(String msg) {
            super(msg);
        }
    }

    public static class NotConnectedException
    extends PulsarClientException {
        public NotConnectedException() {
            super("Not connected to broker");
        }
    }

    public static class ConsumerBusyException
    extends PulsarClientException {
        public ConsumerBusyException(String msg) {
            super(msg);
        }
    }

    public static class ProducerBusyException
    extends PulsarClientException {
        public ProducerBusyException(String msg) {
            super(msg);
        }
    }

    public static class BrokerMetadataException
    extends PulsarClientException {
        public BrokerMetadataException(String msg) {
            super(msg);
        }
    }

    public static class BrokerPersistenceException
    extends PulsarClientException {
        public BrokerPersistenceException(String msg) {
            super(msg);
        }
    }

    public static class UnsupportedAuthenticationException
    extends PulsarClientException {
        public UnsupportedAuthenticationException(Throwable t) {
            super(t);
        }

        public UnsupportedAuthenticationException(String msg) {
            super(msg);
        }
    }

    public static class GettingAuthenticationDataException
    extends PulsarClientException {
        public GettingAuthenticationDataException(Throwable t) {
            super(t);
        }

        public GettingAuthenticationDataException(String msg) {
            super(msg);
        }
    }

    public static class AuthorizationException
    extends PulsarClientException {
        public AuthorizationException(String msg) {
            super(msg);
        }
    }

    public static class AuthenticationException
    extends PulsarClientException {
        public AuthenticationException(String msg) {
            super(msg);
        }
    }

    public static class TopicTerminatedException
    extends PulsarClientException {
        public TopicTerminatedException(String msg) {
            super(msg);
        }
    }

    public static class AlreadyClosedException
    extends PulsarClientException {
        public AlreadyClosedException(String msg) {
            super(msg);
        }
    }

    public static class ConnectException
    extends PulsarClientException {
        public ConnectException(Throwable t) {
            super(t);
        }

        public ConnectException(String msg) {
            super(msg);
        }
    }

    public static class TooManyRequestsException
    extends LookupException {
        public TooManyRequestsException(String msg) {
            super(msg);
        }
    }

    public static class LookupException
    extends PulsarClientException {
        public LookupException(String msg) {
            super(msg);
        }
    }

    public static class TopicDoesNotExistException
    extends PulsarClientException {
        public TopicDoesNotExistException(String msg) {
            super(msg);
        }
    }

    public static class IncompatibleSchemaException
    extends PulsarClientException {
        public IncompatibleSchemaException(Throwable t) {
            super(t);
        }

        public IncompatibleSchemaException(String msg) {
            super(msg);
        }
    }

    public static class TimeoutException
    extends PulsarClientException {
        public TimeoutException(Throwable t) {
            super(t);
        }

        public TimeoutException(String msg) {
            super(msg);
        }
    }

    public static class NotFoundException
    extends PulsarClientException {
        public NotFoundException(String msg) {
            super(msg);
        }

        public NotFoundException(Throwable t) {
            super(t);
        }
    }

    public static class InvalidConfigurationException
    extends PulsarClientException {
        public InvalidConfigurationException(String msg) {
            super(msg);
        }

        public InvalidConfigurationException(Throwable t) {
            super(t);
        }
    }

    public static class InvalidServiceURL
    extends PulsarClientException {
        public InvalidServiceURL(Throwable t) {
            super(t);
        }
    }
}

