/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.oath.auth.KeyManagerProxy;
import com.oath.auth.KeyRefresher;
import com.oath.auth.KeyRefresherException;
import com.oath.auth.TrustManagerProxy;
import com.oath.auth.Utils;
import com.yahoo.athenz.auth.ServiceIdentityProvider;
import com.yahoo.athenz.auth.impl.SimpleServiceIdentityProvider;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.auth.util.CryptoException;
import com.yahoo.athenz.zts.RoleToken;
import com.yahoo.athenz.zts.ZTSClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.url.URL;
import org.apache.pulsar.client.impl.AuthenticationUtil;
import org.apache.pulsar.client.impl.auth.AuthenticationDataAthenz;

public class AuthenticationAthenz
implements Authentication,
EncodedAuthenticationParameterSupport {
    private static final long serialVersionUID = 1L;
    private static final String APPLICATION_X_PEM_FILE = "application/x-pem-file";
    private transient KeyRefresher keyRefresher = null;
    private transient ZTSClient ztsClient = null;
    private String ztsUrl = null;
    private String ztsProxyUrl = null;
    private String tenantDomain;
    private String tenantService;
    private String providerDomain;
    private PrivateKey privateKey = null;
    private String keyId = "0";
    private String privateKeyPath = null;
    private String x509CertChainPath = null;
    private String caCertPath = null;
    private String roleHeader = null;
    private boolean autoPrefetchEnabled = false;
    private volatile long cachedRoleTokenTimestamp;
    private String roleToken;
    private static final int minValidity = 7200;
    private static final int maxValidity = 86400;
    private static final int cacheDurationInMinutes = 90;
    private static final int retryFrequencyInMillis = 3600000;
    private final ReadWriteLock cachedRoleTokenLock = new ReentrantReadWriteLock();

    public String getAuthMethodName() {
        return "athenz";
    }

    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        Lock readLock = this.cachedRoleTokenLock.readLock();
        readLock.lock();
        try {
            if (this.cachedRoleTokenIsValid()) {
                AuthenticationDataAthenz authenticationDataAthenz = new AuthenticationDataAthenz(this.roleToken, StringUtils.isNotBlank((CharSequence)this.roleHeader) ? this.roleHeader : ZTSClient.getHeader());
                return authenticationDataAthenz;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.cachedRoleTokenLock.writeLock();
        writeLock.lock();
        try {
            RoleToken token = this.getZtsClient().getRoleToken(this.providerDomain, null, Integer.valueOf(7200), Integer.valueOf(86400), false);
            this.roleToken = token.getToken();
            this.cachedRoleTokenTimestamp = System.nanoTime();
            AuthenticationDataAthenz authenticationDataAthenz = new AuthenticationDataAthenz(this.roleToken, StringUtils.isNotBlank((CharSequence)this.roleHeader) ? this.roleHeader : ZTSClient.getHeader());
            return authenticationDataAthenz;
        }
        catch (Throwable t) {
            throw new PulsarClientException.GettingAuthenticationDataException(t);
        }
        finally {
            writeLock.unlock();
        }
    }

    private boolean cachedRoleTokenIsValid() {
        if (this.roleToken == null) {
            return false;
        }
        return System.nanoTime() - this.cachedRoleTokenTimestamp < TimeUnit.MINUTES.toNanos(90L);
    }

    public void configure(String encodedAuthParamString) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)encodedAuthParamString), (Object)"authParams must not be empty");
        try {
            this.setAuthParams(AuthenticationUtil.configureFromJsonString((String)encodedAuthParamString));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse authParams", e);
        }
    }

    @Deprecated
    public void configure(Map<String, String> authParams) {
        this.setAuthParams(authParams);
    }

    private void setAuthParams(Map<String, String> authParams) {
        this.tenantDomain = authParams.get("tenantDomain");
        this.tenantService = authParams.get("tenantService");
        this.providerDomain = authParams.get("providerDomain");
        this.keyId = authParams.getOrDefault("keyId", "0");
        this.autoPrefetchEnabled = Boolean.parseBoolean(authParams.getOrDefault("autoPrefetchEnabled", "false"));
        if (StringUtils.isNotBlank((CharSequence)authParams.get("x509CertChain"))) {
            AuthenticationAthenz.checkRequiredParams(authParams, "privateKey", "caCert", "providerDomain");
            this.x509CertChainPath = AuthenticationAthenz.getAbsolutePathFromUrl(authParams.get("x509CertChain"));
            this.privateKeyPath = AuthenticationAthenz.getAbsolutePathFromUrl(authParams.get("privateKey"));
            this.caCertPath = AuthenticationAthenz.getAbsolutePathFromUrl(authParams.get("caCert"));
        } else {
            AuthenticationAthenz.checkRequiredParams(authParams, "tenantDomain", "tenantService", "providerDomain");
            this.privateKey = StringUtils.isBlank((CharSequence)authParams.get("privateKey")) && StringUtils.isNotBlank((CharSequence)authParams.get("privateKeyPath")) ? AuthenticationAthenz.loadPrivateKey(authParams.get("privateKeyPath")) : AuthenticationAthenz.loadPrivateKey(authParams.get("privateKey"));
            if (this.privateKey == null) {
                throw new IllegalArgumentException("Failed to load private key from privateKey or privateKeyPath field");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)authParams.get("athenzConfPath"))) {
            System.setProperty("athenz.athenz_conf", authParams.get("athenzConfPath"));
        }
        if (StringUtils.isNotBlank((CharSequence)authParams.get("principalHeader"))) {
            System.setProperty("athenz.auth.principal.header", authParams.get("principalHeader"));
        }
        if (StringUtils.isNotBlank((CharSequence)authParams.get("roleHeader"))) {
            this.roleHeader = authParams.get("roleHeader");
            System.setProperty("athenz.auth.role.header", this.roleHeader);
        }
        if (StringUtils.isNotBlank((CharSequence)authParams.get("ztsUrl"))) {
            this.ztsUrl = authParams.get("ztsUrl");
        }
        if (StringUtils.isNotBlank((CharSequence)authParams.get("ztsProxyUrl"))) {
            this.ztsProxyUrl = authParams.get("ztsProxyUrl");
        }
    }

    public void start() throws PulsarClientException {
    }

    public void close() throws IOException {
        if (this.ztsClient != null) {
            this.ztsClient.close();
        }
        if (this.keyRefresher != null) {
            this.keyRefresher.shutdown();
        }
    }

    private ZTSClient getZtsClient() throws InterruptedException, IOException, KeyRefresherException {
        if (this.ztsClient == null) {
            if (this.x509CertChainPath != null) {
                if (this.keyRefresher == null) {
                    this.keyRefresher = Utils.generateKeyRefresherFromCaCert((String)this.caCertPath, (String)this.x509CertChainPath, (String)this.privateKeyPath);
                    this.keyRefresher.startup(3600000);
                }
                SSLContext sslContext = Utils.buildSSLContext((KeyManagerProxy)this.keyRefresher.getKeyManagerProxy(), (TrustManagerProxy)this.keyRefresher.getTrustManagerProxy());
                this.ztsClient = new ZTSClient(this.ztsUrl, this.ztsProxyUrl, sslContext);
            } else {
                SimpleServiceIdentityProvider siaProvider = new SimpleServiceIdentityProvider(this.tenantDomain, this.tenantService, this.privateKey, this.keyId);
                this.ztsClient = new ZTSClient(this.ztsUrl, this.ztsProxyUrl, this.tenantDomain, this.tenantService, (ServiceIdentityProvider)siaProvider);
            }
            ZTSClient.setPrefetchAutoEnable((boolean)this.autoPrefetchEnabled);
        }
        return this.ztsClient;
    }

    private static void checkRequiredParams(Map<String, String> authParams, String ... requiredParams) {
        for (String param : requiredParams) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)authParams.get(param)), (String)"Missing required parameter: %s", (Object)param);
        }
    }

    private static String getAbsolutePathFromUrl(String urlString) {
        try {
            java.net.URL url = new URL(urlString).openConnection().getURL();
            Preconditions.checkArgument((boolean)"file".equals(url.getProtocol()), (String)"Unsupported protocol: %s", (Object)url.getProtocol());
            Path path = Paths.get(url.getPath(), new String[0]);
            return path.isAbsolute() ? path.toString() : path.toAbsolutePath().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL format", e);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannnot get absolute path from specified URL", e);
        }
    }

    private static PrivateKey loadPrivateKey(String privateKeyURL) {
        PrivateKey privateKey = null;
        try {
            URLConnection urlConnection = new URL(privateKeyURL).openConnection();
            String protocol = urlConnection.getURL().getProtocol();
            if ("data".equals(protocol) && !APPLICATION_X_PEM_FILE.equals(urlConnection.getContentType())) {
                throw new IllegalArgumentException("Unsupported media type or encoding format: " + urlConnection.getContentType());
            }
            String keyData = CharStreams.toString((Readable)new InputStreamReader((InputStream)urlConnection.getContent(), Charset.defaultCharset()));
            privateKey = Crypto.loadPrivateKey((String)keyData);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid privateKey format", e);
        }
        catch (CryptoException | IOException | IllegalAccessException | InstantiationException e) {
            privateKey = null;
        }
        return privateKey;
    }
}

